#!/bin/bash
# build_and_restart.sh
# Script to rebuild JobArranger2 and restart server/agent in order

echo ">> removing pid "
rm -rf /var/run/jobarranger/*

echo ">> removing old log files"
rm -rf /var/log/jobarranger/jobarg_*


echo ">> Removing file under /var/lib/jobarranger2/server/"
sudo rm -rf /var/lib/jobarranger/server/*

SERVER_CONF="/etc/jobarranger2/jobarg_server.conf"
AGENT_CONF="/etc/jobarranger2/jobarg_agentd.conf"

# echo ">> Stopping existing jobarg_server and jobarg_agent..."
# pkill -f -9 jobarg_server || true
# pkill -f -9 jobarg_agent || true

echo ">> Starting jobarg_server..."
if jobarg_server -c "$SERVER_CONF" & then
    echo ">> jobarg_server started successfully."
else
    echo "!! Failed to start jobarg_server. Exiting."
    exit 1
fi

sleep 2  # give server some time to initialize

echo ">> Starting jobarg_agent..."
if jobarg_agentd -c "$AGENT_CONF" & then
    echo ">> jobarg_agentd started successfully."
else
    echo "!! Failed to start jobarg_agent."
    exit 1
fi

chown -R apache:apache /etc/jobarranger/web/

echo ">> Done. Both server and agent should now be running."
