<?php declare(strict_types=1);

use PHPUnit\Framework\TestCase;
use phpmock\phpunit\PHPMock;
use App\Controllers\Api\LoginApi;
use App\Utils\Constants;

define('ZBX_API_ROOT','http://172.23.99.55/zabbix');
define('SSL_VERIFICATION',1);

  /**
   * Override file_get_contents() in the My\Namespace namespace when testing
   *
   * @return string
   */
  // function zbx_api_check_response(): string
  // {

  // }
  // function file_get_contents($url, $val, $context): string
  // {
  //   switch ($url){
  //     case '':
  //       break;
  //     case ZBX_API_ROOT . Constants::ZBX_MAIN_END_POINT:
  //     return zbx_api_check_response();// return your mock or whatever value you want to use for testing
  //   }
  //   return "error";
  // }
final class LoginApiTest extends TestCase
{
    use PHPMock;
    
    /*
     *Testing for isJSON() function;
    */
    public function testNonJsonFormat(): void
    {
        $this->assertFalse(LoginApi::isJSON("non-json_format"));
    }

    public function testWrongJsonFormat(): void
    {
        $json_data = '{"jsonrpc":"require"}';
        $this->assertFalse(LoginApi::isJSON($json_data));
    }
    public function testMissingDataFormat(): void
    {
        $json_data = '{"jsonrpc":"required","id":1}';
        $this->assertFalse(LoginApi::isJSON($json_data));
    }
    public function testWrongResultFormat(): void
    {
        $json_data = '{"jsonrp":"required",
            "result": {
              "sessionid": "c3fbd74cf3741afd51980a7374137c62",
              "secret": "d5dda0a14c09de23f2a874d3b97a4f21"
            },"id":1}';
        $this->assertFalse(LoginApi::isJSON($json_data));
    }
    public function testRightFormatRightData(): void
    {
        $json_data = '{
            "jsonrpc": "2.0",
            "result": {
              "userid": "1",
              "username": "Admin",
              "name": "Zabbix",
              "surname": "Administrator",
              "url": "",
              "autologin": "1",
              "autologout": "0",
              "lang": "en_US",
              "refresh": "30s",
              "theme": "default",
              "attempt_failed": "0",
              "attempt_ip": "",
              "attempt_clock": "0",
              "rows_per_page": "50",
              "timezone": "Asia/Yangon",
              "roleid": "3",
              "userdirectoryid": "0",
              "ts_provisioned": "0",
              "debug_mode": 0,
              "deprovisioned": false,
              "gui_access": "1",
              "auth_type": 0,
              "type": 3,
              "userip": "172.23.96.1",
              "sessionid": "c3fbd74cf3741afd51980a7374137c62",
              "secret": "d5dda0a14c09de23f2a874d3b97a4f21"
            },
            "id": 1
          }';
        $this->assertTrue(LoginApi::isJSON($json_data));
    }
    public function testErrorApiResponse(): void
    {
        $json_data = '{
            "jsonrpc": "2.0",
            "error": {
              "code": -32500,
              "message": "Application error.",
              "data": "Incorrect user name or password or account is temporarily blocked."
            },
            "id": 1
          }';
        $this->assertTrue(LoginApi::isJSON($json_data));
    }
/*
 *===============================================
*/
/*
 *Testing for checkZbxApiInfo() function;
*/
    public function testVerifySuccess():void
    {
         // Define the URL and expected payload
         // Call the function under test
         
        // Mock the built-in function
        $fileGetContentMock = $this->getFunctionMock('App\Controllers\Api', 'file_get_contents');
        $fileGetContentMock->expects($this->any())->willReturn('{
          "jsonrpc": "2.0",
          "result": "6.4.14",
          "id": 1
        }');
         $result = LoginApi::checkZbxApiInfo();
 
         // Assert the result
         $this->assertSame("6.4.14", $result);
    }
    public function testVerifyFail():void
    {
         // Define the URL and expected payload
         $fileGetContentMock = $this->getFunctionMock('App\Controllers\Api', 'file_get_contents');
         $fileGetContentMock->expects($this->any())->willReturn('{
          "jsonrpc": "2.0",
          "error": {
            "code": -32700,
            "message": "Parse error",
            "data": "Invalid JSON. An error occurred on the server while parsing the JSON text."
          },
          "id": null
        }');
         // Call the function under test
         $result = LoginApi::checkZbxApiInfo();
 
         // Assert the result
         $this->assertFalse($result);
    }
    /*
     *===============================================
    */
    /*
     *Testing for AuthPathAPI() function;
    */
    public function testVersionErrorZabbix():void
    {
      //$checkZabbixVersionMock = $this->getFunctionMock('App\Controllers\Api','checkZbxApiInfo');
      $checkZabbixVersionMock = $this->getMockBuilder(LoginApi::class)
                                      ->onlyMethods(['checkZbxApiInfo'])
                                      ->getMock();
                                      //$loginApiMock->expects($this->once());
      $checkZabbixVersionMock->method('checkZbxApiInfo')->willReturn(false);
    
      $fileGetContentMock = $this->getFunctionMock('App\Controllers\Api', 'file_get_contents');
      $fileGetContentMock->expects($this->any())->willReturn('{
        "jsonrpc": "2.0",
        "error": {
          "code": -32700,
          "message": "Parse error",
          "data": "Invalid JSON. An error occurred on the server while parsing the JSON text."
        },
        "id": null
      }');
      $checkZabbixVersionMock = $this->getFunctionMock('App\Controllers\Api','isJSON');
      $checkZabbixVersionMock->expects($this->any())->willReturn(false);
      $data = ['username' => 'Admin', 'password' => 'zabbix'];
      $this->assertFalse(LoginApi::AuthPathAPI($data));
    }

    
    public function testVersionLessSixZabbix():void
    {
      //$checkZabbixVersionMock = $this->getFunctionMock('App\Controllers\Api','checkZbxApiInfo');
      $checkZabbixVersionMock = $this->getMockBuilder(LoginApi::class)
                                      ->onlyMethods(['checkZbxApiInfo'])
                                      ->getMock();
                                      //$loginApiMock->expects($this->once());
      $checkZabbixVersionMock->method('checkZbxApiInfo')->willReturn("5.1.0");
    
      $fileGetContentMock = $this->getFunctionMock('App\Controllers\Api', 'file_get_contents');
      $fileGetContentMock->expects($this->any())->willReturn('{
        "jsonrpc": "2.0",
        "error": {
          "code": -32700,
          "message": "Parse error",
          "data": "Invalid JSON. An error occurred on the server while parsing the JSON text."
        },
        "id": null
      }');
      $checkZabbixVersionMock = $this->getFunctionMock('App\Controllers\Api','isJSON');
      $checkZabbixVersionMock->expects($this->any())->willReturn(false);
      $data = ['username' => 'Admin', 'password' => 'zabbix'];
      $this->assertFalse(LoginApi::AuthPathAPI($data));
    }
    public function testZabbixLoginFail():void
    {
      //$checkZabbixVersionMock = $this->getFunctionMock('App\Controllers\Api','checkZbxApiInfo');
      $checkZabbixVersionMock = $this->getMockBuilder(LoginApi::class)
                                      ->onlyMethods(['checkZbxApiInfo'])
                                      ->getMock();
                                      //$loginApiMock->expects($this->once());
      $checkZabbixVersionMock->method('checkZbxApiInfo')->willReturn("6.1.0");
    
      $fileGetContentMock = $this->getFunctionMock('App\Controllers\Api', 'file_get_contents');
      $fileGetContentMock->expects($this->any())->willReturn('{
        "jsonrpc": "2.0",
        "result": "6.4.14",
        "id": 1
      }');
      $checkZabbixVersionMock = $this->getFunctionMock('App\Controllers\Api','isJSON');
      $checkZabbixVersionMock->expects($this->any())->willReturn(false);
      $data = ['username' => 'Admin', 'password' => 'zabbix'];
      $this->assertFalse(LoginApi::AuthPathAPI($data));
    }

    /* STILL WORKING ON IT! 
    public function testJsonFail():void
    {
      //$checkZabbixVersionMock = $this->getFunctionMock('App\Controllers\Api','checkZbxApiInfo');
      $checkZabbixVersionMock = $this->getMockBuilder(LoginApi::class)
                                      ->onlyMethods(['checkZbxApiInfo','isJSON'])
                                      ->getMock();
                                      //$loginApiMock->expects($this->once());
      $checkZabbixVersionMock->expects($this->any())->method('checkZbxApiInfo')->willReturn("6.1.0");
      $checkZabbixVersionMock->expects($this->any())->method('isJSON')->willReturn(false);
    
       $fileGetContentMock = $this->getFunctionMock('App\Controllers\Api', 'file_get_contents');
      $fileGetContentMock->expects($this->any())->willReturn('{
        "jsonrpc": "2.0",
        "result": "6.4.14",
        "id": 1
      }');
       //$fileGetContentMock->expects($this->any())->willReturn('{
      //   "jsonrpc": "2.0",
      //   "result": {
      //     "userid": "1",
      //     "username": "Admin",
      //     "name": "Zabbix",
      //     "surname": "Administrator",
      //     "url": "",
      //     "autologin": "1",
      //     "autologout": "0",
      //     "lang": "en_US",
      //     "refresh": "30s",
      //     "theme": "default",
      //     "attempt_failed": "0",
      //     "attempt_ip": "",
      //     "attempt_clock": "0",
      //     "rows_per_page": "50",
      //     "timezone": "Asia/Yangon",
      //     "roleid": "3",
      //     "userdirectoryid": "0",
      //     "ts_provisioned": "0",
      //     "debug_mode": 0,
      //     "deprovisioned": false,
      //     "gui_access": "1",
      //     "auth_type": 0,
      //     "type": 3,
      //     "userip": "172.23.96.1",
      //     "sessionid": "7208ee9282cb50fdf4b438bbc9ae3686",
      //     "secret": "9586241326769ba0e3a1ad3a4612ea57"
      //   },
      //   "id": 1
      // }');

      //$checkZabbixVersionMock = $this->getFunctionMock('App\Controllers\Api','isJSON');
      //$checkZabbixVersionMock->expects($this->any())->willReturn(false);
      
      $data = ['username' => 'Admin', 'password' => 'zabbix'];
      $res = $checkZabbixVersionMock->AuthPathAPI($data);
      $this->assertFalse($res);
    }
    */
}