import { Space, Divider } from "antd";
import { useTranslation } from "react-i18next";
import moment from "moment";
import {
  jobnetTimeoutTypeLabel,
  multipleStartUpLabel,
} from "../../../common/Jobnet";
import "./JobExecutionHeader.scss";
import { useSelector } from "react-redux";
import { formatUnixTimeWithTimeZone } from "../../../views/jobExecutionManagement/OperationTableCard";
import JobExecutionResultService from "../../../services/JobExecutionResultService";
import { setStandardTime, setTimeZone } from "../../../store/TimeZoneSlice";
import { useDispatch } from "react-redux";
import { useEffect } from "react";

const JobExecutionHeader = ({ id, info }) => {
  const { t } = useTranslation();
  const dispatch = useDispatch();
  const timeZone = useSelector((state) => state.timeZone.timeZone);
  const standardTime = useSelector((state) => state.timeZone.standardTime);

  useEffect(() => {
    // Try to fetch the timezone from the API
    JobExecutionResultService.getTimeZone()
      .then((result) => {
        // Successfully fetched timezone
        if (result?.detail?.data) {
          dispatch(setTimeZone(result.detail.data));
        }
      })
      .catch((error) => {
        // Handle the error case if the API call fails
        console.error('Failed to fetch timezone:', error);
        // Here, you can dispatch an action to set a default state or flag indicating failure
        dispatch(setTimeZone(null));  // Example of setting it to null or another fallback state
      });

    JobExecutionResultService.getJobArrangerStandardTime()
      .then((result) => {
        dispatch(setStandardTime(result?.detail?.data));
      })
      .catch((error) => {
        console.error('Failed to fetch standard time:', error);
        // Handle standard time fetch failure
      });
  }, []);

  
  

  return (
    <>
      <div className="exec-description">
        <div className="desc-item" style={{ width: 230 }}>
          <div className="header-label" style={{ width: "34%" }}>
            {t("col-manage-id")}
          </div>
          <div className="header-value" style={{ width: "66%" }}>
            {id}
          </div>
        </div>

        <div className="desc-item" style={{ width: 240 }}>
          <div className="header-label" style={{ width: "43%" }}>
            {t("lab-schedule-time")}
          </div>
          <div className="header-value" style={{ width: "57%" }}>
            {info.scheduled_time && info.scheduled_time !== "0"
              // ? moment.unix(info.scheduled_time).format('YYYY/MM/DD HH:mm:ss')
              ? formatUnixTimeWithTimeZone(info.scheduled_time, timeZone, standardTime)
              : ""}
          </div>
        </div>
        <div className="desc-item" style={{ width: 240 }}>
          <div className="header-label" style={{ width: "43%" }}>
            {t("col-srt-time")}
          </div>
          <div className="header-value" style={{ width: "57%" }}>
            {info.start_time && info.start_time !== "0"
              // ? moment.unix(info.start_time).format('YYYY/MM/DD HH:mm:ss')
              ? formatUnixTimeWithTimeZone(info.start_time, timeZone, standardTime)
              : ""}
          </div>
        </div>

        <div className="desc-item" style={{ width: 240 }}>
          <div className="header-label" style={{ width: "43%" }}>
            {t("col-end-time")}
          </div>
          <div className="header-value" style={{ width: "57%" }}>
            {info.end_time && info.end_time !== "0"
              // ? moment.unix(info.end_time).format('YYYY/MM/DD HH:mm:ss')
              ? formatUnixTimeWithTimeZone(info.end_time, timeZone, standardTime)
              : ""}
          </div>
        </div>
        <div className="desc-item" style={{ width: 410 }}>
          <div className="header-label" style={{ width: "25%" }}>
            {t("label-jobnet-id")}
          </div>
          <div className="header-value" style={{ width: "75%" }}>
            {info.jobnet_id || ""}
          </div>
        </div>
        <div className="desc-item" style={{ width: 150 }}>
          <div className="header-label" style={{ width: "60%" }}>
            {t("lab-multiple")}
          </div>
          <div className="header-value" style={{ width: "40%" }}>
            {info.multiple_start_up
              ? multipleStartUpLabel(info.multiple_start_up)
              : ""}
          </div>
        </div>
        <div className="desc-item" style={{ width: 150 }}>
          <div className="header-label" style={{ width: "60%" }}>
            {t("lab-pub")}
          </div>
          <div className="header-value" style={{ width: "40%" }}>
            {info.public_flag && info.public_flag === "1"
              ? t("sel-yes")
              : t("sel-no")}
          </div>
        </div>
        <div className="desc-item" style={{ width: 240 }}>
          <div className="header-label" style={{ width: "43%" }}>
            {t("lab-upd-date")}
          </div>
          <div className="header-value" style={{ width: "57%" }}>
            {info.update_date
              // ? moment.unix(info.update_date).format('YYYY/MM/DD HH:mm:ss')
              ? formatUnixTimeWithTimeZone(info.update_date, timeZone, standardTime)
              : ""}
          </div>
        </div>
        <div className="desc-item" style={{ width: 713 }}>
          <div className="header-label" style={{ width: "17%" }}>
            {t("label-jobnet-name")}
          </div>
          <div className="header-value" style={{ width: "83%" }}>
            {info.jobnet_name || ""}
          </div>
        </div>
        <div className="desc-item" style={{ width: 240 }}>
          <div className="header-label" style={{ width: "40%" }}>
            {t("lab-user-name")}
          </div>
          <div className="header-value" style={{ width: "60%" }}>
            {info.user_name || ""}
          </div>
        </div>
        <div className="desc-item" style={{ width: 620 }}>
          <div className="header-label" style={{ width: "15%" }}>
            {t("lab-description")}
          </div>
          <div className="header-value" style={{ width: "85%" }}>
            {info.memo || ""}
          </div>
        </div>
        <div className="desc-item" style={{ width: 330 }}>
          <div className="header-label" style={{ width: "50%" }}>
            {t("label-timeout-min")}
          </div>
          <div className="header-value" style={{ width: "50%" }}>
            <Space split={<Divider type="vertical" />}>
              <>{info.jobnet_timeout || ""}</>
              <>
                {info.timeout_run_type
                  ? jobnetTimeoutTypeLabel(info.timeout_run_type)
                  : ""}
              </>
            </Space>
          </div>
        </div>
        {!timeZone && (
            <div className="desc-item warn-msg" style={{ display: 'flex', justifyContent: 'start', alignItems: 'center'}}>
              <div className="header-label" style={{ fontWeight: 'bold' }}>
                {t("label-warn")}
              </div>
              <div className="header-value">
                <Space split={<Divider type="vertical" />}>
                  {t("label-timezone-warn")}
                </Space>
              </div>
            </div>          
        )}
      </div>
    </>
  );
};

export default JobExecutionHeader;
