import React, { useEffect } from "react";
import { useNavigate, useSearchParams } from "react-router-dom";
import AuthService from "../../services/Auth";
import { setUserInfo } from "../../store/UserSlice";
import { useDispatch } from "react-redux";
import "./Redirect.scss";
import { useTranslation } from "react-i18next";
import { loadAllScripts } from "../../common/Util";

const Redirect = () => {
  const [searchParams, setSearchParams] = useSearchParams();
  const dispatch = useDispatch();
  const navigate = useNavigate();
  const { t, i18n } = useTranslation();

  useEffect(() => {
    const token = searchParams.get("token");
    if (token) {
      AuthService.redirectLogin({
        token,
      })
        .then((res) => {
          // loadAllScripts();
          dispatch(setUserInfo(res.detail.data));
          navigate("/home");

          i18n.changeLanguage(res.detail.data.language.toLowerCase());
          if(i18n.language == 'jp')
          {
            document.documentElement.lang = 'ja';
          }
          else {
            document.documentElement.lang = i18n.language;
          }
        })
        .catch((err) => {
          console.log(err);
        });
    }
  }, []);

  return (
    <div className="loader-container">
      <div class="loader-content-wrapper">
        <div class="loader"></div>
        <div class="content">
          <h1>Please wait while we prepare the JobArranger Home Page...</h1>
        </div>
      </div>
    </div>
  );
};

export default Redirect;
