import { Modal, Spin } from "antd";
import React, { useState } from "react";
import { useTranslation } from "react-i18next";
import { useDispatch } from "react-redux";
import AuthService from "../../services/Auth";
import { logoutAndClearStorage } from "../../store/UserSlice";
import { useNavigate } from "react-router-dom";
import { SERVICE_RESPONSE } from "../../constants";
import { clearHideRow } from "../../store/ErrorOperationListSlice";
import { removeAllExecuteJob } from "../../store/JobExecutionSlice";

const Logout = ({ isOpen, onCancel }) => {
  const { t } = useTranslation();
  const dispatch = useDispatch();
  const navigate = useNavigate();
  const [isLoading, setIsLoading] = useState(false);

  const clearSessionAndLogout = () => {
    dispatch(logoutAndClearStorage());
    dispatch(clearHideRow());
    dispatch(removeAllExecuteJob());
    navigate("/login", { replace: true });
  };

  const onOkClick = () => {
    setIsLoading(true);
    AuthService.logout({})
      .then((res) => {
        if (res.type === SERVICE_RESPONSE.OK) {
          clearSessionAndLogout();
        } else if (
          res.type === SERVICE_RESPONSE.INCOMEPLETE &&
          res.detail.message === SERVICE_RESPONSE.NO_PERMISSION_TO_CALL
        ) {
          clearSessionAndLogout();
        }
      })
      .catch((error) => {})
      .finally(() => {
        setIsLoading(false);
      });
  };

  return (
    <Modal
      open={isOpen}
      title={t("title-msg-confirm")}
      onOk={onOkClick}
      okButtonProps={{ disabled: isLoading }}
      onCancel={onCancel}
      cancelButtonProps={{ disabled: isLoading }}
      width={450}
      centered={true}
      okText={t("btn-ok")}
      cancelText={t("btn-cancel")}
      maskClosable={false}
    >
      <Spin spinning={isLoading}>
        {" "}
        {}
        <div>{t("logout-confirm")}</div>
      </Spin>
    </Modal>
  );
};

export default Logout;
