%define _localsbindir /usr/local/sbin
%define _localbinjobargdir /usr/local/bin/jobarranger
%define debug_package %{nil}
%define _build_id_links none
%define __requires_exclude ^lib(mariadb|mysqlclient|pq)\.so.*$
%define _binary_payload w19.zstdio
%define _source_payload w19.zstdio

Name:           jobarranger
Version:        %{version}
Release:        1%{?dist}
Summary:        Open-source job controller solution for your IT infrastructure
Vendor:         Daiwa Institute of Research Ltd.

Group:          Applications/Internet
License:        GPL
URL:            https://www.%{name}.info/redmine/

Buildroot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

%description
Job Arranger for ZABBIX.

%package server
Summary:         Job Arranger server
Group:           Applications/Internet
Requires:        logrotate
Requires:        libvterm
Requires(pre):   /usr/sbin/useradd
Requires(post)  : systemd
Requires(preun) : systemd
Requires(postun): systemd

%description server
Job Arranger server

%prep
cp %{jobarg_source}/AUTHORS .
cp %{jobarg_source}/README.md .
cp %{jobarg_source}/COPYING .
cp %{jobarg_source}/ChangeLog .
cp -r %{jobarg_source}/database .

%install
rm -rf $RPM_BUILD_ROOT
cd %{jobarg_source}
make DESTDIR=$RPM_BUILD_ROOT install

# set up some required directories
mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}/logrotate.d
mkdir -p $RPM_BUILD_ROOT%{_datadir}
mkdir -p $RPM_BUILD_ROOT%{_localstatedir}/log/%{name}
mkdir -p $RPM_BUILD_ROOT%{_localstatedir}/run/%{name}
mkdir -p $RPM_BUILD_ROOT%{_localstatedir}/lib/%{name}
mkdir -p $RPM_BUILD_ROOT%{_localstatedir}/lib/%{name}/server
mkdir -p $RPM_BUILD_ROOT%{_prefix}/lib/systemd/system/
mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}/tmpfiles.d
mkdir -p $RPM_BUILD_ROOT%{_localbinjobargdir}/server_socks

# init scripts
install -m 0644 -p misc/service/jobarg-server.service $RPM_BUILD_ROOT%{_prefix}/lib/systemd/system/
install -m 0644 -p misc/service/jobarranger_server.conf $RPM_BUILD_ROOT%{_sysconfdir}/tmpfiles.d/

# log rotation
cat misc/logrotate/jobarg-logrotate.in | sed -e 's|COMPONENT|server|g' > \
     $RPM_BUILD_ROOT%{_sysconfdir}/logrotate.d/jobarg-server

%clean
rm -rf $RPM_BUILD_ROOT

%pre server
/usr/sbin/useradd -c "Job Arranger user" \
        -s /sbin/nologin -r -d %{_sysconfdir}/zabbix zabbix 2> /dev/null || :

%preun server
if [ $1 -eq 0 ]
then
  if [ -e  %{_prefix}/lib/systemd/system/jobarg-server.service ];then
    cd %{_prefix}/lib/systemd/system
    %{_prefix}/bin/systemctl stop jobarg-server.service >/dev/null 2>&1 || :
  fi

  rm -rf %{_localstatedir}/lib/%{name}/server/*
  rm -rf %{_localbinjobargdir}/server_socks/*
fi

%files server
%defattr(-,root,root,-)
%doc AUTHORS README.md COPYING ChangeLog
%doc database
%{_mandir}/man8/jobarg_server.8.*
%attr(0755,zabbix,zabbix) %dir %{_localstatedir}/log/%{name}
%attr(0755,zabbix,zabbix) %dir %{_localstatedir}/run/%{name}
%attr(0755,zabbix,zabbix) %dir %{_localstatedir}/lib/%{name}
%attr(0755,zabbix,zabbix) %dir %{_localstatedir}/lib/%{name}/server
%attr(0755,zabbix,zabbix) %dir %{_localbinjobargdir}/server_socks
%config(noreplace) %{_sysconfdir}/logrotate.d/jobarg-server
%attr(0755,zabbix,zabbix) %dir %{_sysconfdir}/%{name}
%attr(0644,zabbix,zabbix) %config(noreplace) %{_sysconfdir}/%{name}/jobarg_server.conf
%attr(0755,zabbix,zabbix) %dir %{_sysconfdir}/%{name}/locale
%attr(0744,zabbix,zabbix) %{_sysconfdir}/%{name}/locale/server_logmessage_64BIT.txt
%attr(0644,root,root) /usr/lib/systemd/system/jobarg-server.service
%attr(0644,root,root) %{_sysconfdir}/tmpfiles.d/jobarranger_server.conf
%attr(0755,root,root) %{_localsbindir}/jobarg_server
%attr(0755,root,root) %{_localsbindir}/jobarg_framework_server
%attr(0755,root,root) %{_localsbindir}/jobarg_manager_monitor_server
%attr(0755,zabbix,zabbix) %{_localbinjobargdir}/agentless_icon_client
%attr(0755,zabbix,zabbix) %{_localbinjobargdir}/calc_icon_client
%attr(0755,zabbix,zabbix) %{_localbinjobargdir}/checkjob_client
%attr(0755,zabbix,zabbix) %{_localbinjobargdir}/client_helper
%attr(0744,zabbix,zabbix) %{_localbinjobargdir}/dbsyncer_manager.so
%attr(0755,zabbix,zabbix) %{_localbinjobargdir}/end_icon_client
%attr(0755,zabbix,zabbix) %{_localbinjobargdir}/extension_icon_client
%attr(0755,zabbix,zabbix) %{_localbinjobargdir}/fcopy_icon_client
%attr(0744,zabbix,zabbix) %{_localbinjobargdir}/flow_manager.so
%attr(0755,zabbix,zabbix) %{_localbinjobargdir}/fwait_icon_client
%attr(0744,zabbix,zabbix) %{_localbinjobargdir}/housekeeper_manager.so
%attr(0744,zabbix,zabbix) %{_localbinjobargdir}/icon_exec_manager.so
%attr(0744,zabbix,zabbix) %{_localbinjobargdir}/icon_result_manager.so
%attr(0755,zabbix,zabbix) %{_localbinjobargdir}/ifend_icon_client
%attr(0755,zabbix,zabbix) %{_localbinjobargdir}/if_icon_client
%attr(0755,zabbix,zabbix) %{_localbinjobargdir}/info_icon_client
%attr(0755,zabbix,zabbix) %{_localbinjobargdir}/jobarg_monitor_maria
%attr(0755,zabbix,zabbix) %{_localbinjobargdir}/jobarg_monitor_mysql
%attr(0755,zabbix,zabbix) %{_localbinjobargdir}/jobarg_monitor_postgres
%attr(0755,zabbix,zabbix) %{_localbinjobargdir}/jobarg_winrm
%attr(0755,zabbix,zabbix) %{_localbinjobargdir}/job_icon_client
%attr(0755,zabbix,zabbix) %{_localbinjobargdir}/jobnet_icon_client
%attr(0744,zabbix,zabbix) %{_localbinjobargdir}/jobnet_manager.so
%attr(0755,zabbix,zabbix) %{_localbinjobargdir}/loop_icon_client
%attr(0744,zabbix,zabbix) %{_localbinjobargdir}/maria_database.so
%attr(0744,zabbix,zabbix) %{_localbinjobargdir}/mysql_database.so
%attr(0755,zabbix,zabbix) %{_localbinjobargdir}/m_icon_client
%attr(0744,zabbix,zabbix) %{_localbinjobargdir}/notification_manager.so
%attr(0744,zabbix,zabbix) %{_localbinjobargdir}/psql_database.so
%attr(0755,zabbix,zabbix) %{_localbinjobargdir}/reboot_icon_client
%attr(0744,zabbix,zabbix) %{_localbinjobargdir}/recovery_manager.so
%attr(0755,zabbix,zabbix) %{_localbinjobargdir}/release_icon_client
%attr(0755,zabbix,zabbix) %{_localbinjobargdir}/ssh_client
%attr(0755,zabbix,zabbix) %{_localbinjobargdir}/start_icon_client
%attr(0755,zabbix,zabbix) %{_localbinjobargdir}/task_icon_client
%attr(0744,zabbix,zabbix) %{_localbinjobargdir}/timer_manager.so
%attr(0744,zabbix,zabbix) %{_localbinjobargdir}/trapper_manager.so
%attr(0755,zabbix,zabbix) %{_localbinjobargdir}/variable_icon_client
%attr(0755,zabbix,zabbix) %{_localbinjobargdir}/w_icon_client
%attr(0755,zabbix,zabbix) %{_localbinjobargdir}/zabbix_icon_client
%attr(0744,zabbix,zabbix) %{_localbinjobargdir}/zabbix_link_manager.so
%attr(0744,zabbix,zabbix) %{_localbinjobargdir}/zabbix_v6.so
%attr(0744,zabbix,zabbix) %{_localbinjobargdir}/zabbix_v7.so

%changelog
* Sun Oct 12 2025 Copyright Daiwa Institute of Research Ltd. All Rights Reserved. <https://www.%{name}.info/jaz/jaz_release_note.html> %{version}
- Lastest RPM relese
