/*
** Job Arranger for ZABBIX
** Copyright (C) 2025 Daiwa Institute of Research Ltd. All Rights Reserved.
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
**/
package main

import (
	"fmt"
	"os"
	"time"

	utils "jobarranger2/src/jobarg_monitor/pkg/utils"
	"jobarranger2/src/libs/golibs/database"
)

type DBType string
type JA_SENDER_ID int

const (
	MariaDBType    DBType = "maria"
	MysqlDBType    DBType = "mysql"
	PostgresDBType DBType = "postgres"

	JOBNET_LOAD_SPAN              = "JOBNET_LOAD_SPAN"
	JA_SUMMARY_START_PENDING_NONE = 0
	DEFAULT_LOAD_SPAN             = 60
	MIN_LOAD_SPAN                 = 1
	MAX_LOAD_SPAN                 = 1439

	JA_SENDER_LOADER JA_SENDER_ID = 1
	JA_SENDER_RUN    JA_SENDER_ID = 2
	sqlErrFmt                     = "[ERROR] : %s\nQuery: %s\nDetails: %w"
	fetchErrFmt                   = "[ERROR] : failed to fetch from %s: %w"
)

func ProcessMonitor(dbconn database.DBConnection, args *utils.MonitorArgs) error {
	fmt.Printf("%d:%s [DEBUG] In ProcessMonitor().\n", os.Getppid(), time.Now().Format("20060102:150405.000"))

	//check loader
	err := JaCheckLoader(dbconn, args.LoadShiftTime)
	if err != nil {
		return fmt.Errorf("%s", err.Error())
	}

	//check run
	err = JaCheckRun(dbconn, args.RunShiftTime)
	if err != nil {
		return fmt.Errorf("%s", err.Error())
	}

	return nil
}
