/*
** Job Arranger for ZABBIX
** Copyright (C) 2025 Daiwa Institute of Research Ltd. All Rights Reserved.
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
**/
package main

import (
	"strings"

	"jobarranger2/src/libs/golibs/config_reader/server"
	"jobarranger2/src/libs/golibs/database"
)

func classifySQLError(errorCode string) DBErrorType {
	dbType := server.Options.DBType

	var retryCodeStr string

	switch dbType {
	case database.PostgresDBType:
		retryCodeStr = server.Options.PostgresDBRetryCodes
	case database.MysqlDBType:
		retryCodeStr = server.Options.MysqlDBRetryCodes
	case database.MariaDBType:
		retryCodeStr = server.Options.MariaDBRetryCodes
	default:
		return DBNonRetryableError
	}

	errorCode = strings.TrimSpace(errorCode)

	for retryCode := range strings.SplitSeq(retryCodeStr, ",") {
		if strings.TrimSpace(retryCode) == errorCode {
			return DBRetryableError
		}
	}

	return DBNonRetryableError
}
