/*
** Job Arranger for ZABBIX
** Copyright (C) 2025 Daiwa Institute of Research Ltd. All Rights Reserved.
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
**/

package events

import (
	"encoding/json"
	"flag"
	"fmt"
	"os"
	"path/filepath"
	"strconv"
	"strings"
	"testing"

	"jobarranger2/src/libs/golibs/common"
	"jobarranger2/src/libs/golibs/utils"
)

type TestEvent string
type TestIcon string

var (
    inputEvent = flag.String("event", "", 
        "Event Types (ready|run)")
	inputIcon = flag.String("icon", "", 
        "Icon Types (agentless|job|)")
	inputCmdType = flag.String("cmd", "", 
        "Command (jacmdsleep|jacmdtime|jacmdweek|zabbix_sender)")
)

const (
	TestAgentlessIcon TestIcon = "agentless"
	TestJobIcon TestIcon = "job"
	TestExtJobIcon TestIcon = "ext"
	TestIfIcon TestIcon = "if"
	TestStartIcon TestIcon = "start"
	TestEndIcon TestIcon = "end"
	TestCalcuIcon TestIcon = "calculate"
	TestFwaitIcon TestIcon = "fwait"
	TestFcopyIcon TestIcon = "fcopy"
	TestRebootIcon TestIcon = "reboot"
	TestZabbixLinkIcon TestIcon = "zabbix"
	TestTaskIcon TestIcon = "task"
	TestReleaseIcon TestIcon = "release"
	TestValueIcon TestIcon = "value"
	TestInfoIcon TestIcon = "info"
	TestJobnetIcon TestIcon = "jobnet"
	TestIfEndICon TestIcon = "ifend"
	TestWIcon TestIcon = "w"
	TestMIcon TestIcon = "m"
	TestLoopIcon TestIcon = "loop"

	TestReadyEvent TestEvent = "ready"
	TestRunEvent TestEvent = "run"
	TestEndEvent TestEvent = "end"
	TestAbortEvent TestEvent = "abort"
)

const(
	TestAgentlessReadyEventStr string = `
	{
		"event": {

			"name": "icon_ready",

			"unique_key": ""

		},

		"next_process": {

			"name": "icon_execution_manager",

			"data": {

			"run_job_data": {

				"inner_job_id": 1428,

				"inner_jobnet_id": 0,

				"inner_jobnet_main_id": 1500000000000000033,

				"inner_job_id_fs_link": 0,

				"created_date": 0,

				"invo_flag": 0,

				"job_type": 18,

				"data": {
					"command": "hostname\r\n",
					"timeout": 0,
					"run_mode": 0,
					"host_flag": 0,
					"host_name": "oss.linux.rhel8",
					"stop_code": "",
					"login_user": "root",
					"passphrase": "",
					"public_key": "",
					"session_id": "271",
					"auth_method": 0,
					"private_key": "",
					"session_flag": 0,
					"prompt_string": "#",
					"terminal_type": "vanilla",
					"character_code": "Unspecified",
					"line_feed_code": 0,
					"login_password": "1000945080204715d504b515454",
					"connection_method": 0
				},

				"test_flag": 0,

				"method_flag": 0,

				"force_flag": 0,

				"timeout_flag": 0,

				"status": 0,

				"boot_count": 0,

				"end_count": 0,

				"start_time": 0,

				"end_time": 0,

				"point_x": 0,

				"point_y": 0,

				"job_id": "",

				"job_name": "",

				"continue_flag": 0,

				"run_user": "",

				"run_user_password": ""

			},

			"RunJobVariableData": {

				"inner_job_id": 0,

				"inner_jobnet_id": 0,

				"before_variable": null,

				"after_variable": null,

				"before_seq_no": 0,

				"after_seq_no": 0

			}

		}

	},

		"queries": [

			"INSERT INTO ja_2_run_job_variable_table (inner_job_id, inner_jobnet_id, before_variable, before_seq_no) VALUES (1428, 1500000000000000033, '{\"JOBNET_ID\":1234,\"USER_NAME\":\"admin\",\"JOBNET_NAME\":\"SampleJobnet\",\"MANAGEMENT_ID\":1500000000000000006,\"JOBNET_BOOT_TIME\":\"20250520134658\",\"JOBNET_SCHEDULED_TIME\":\"20250519120000\"}', 20250601171106)",

			"select status from ja_run_job_table where inner_job_id = 1428 for update",

			"update ja_run_job_table set status = 1, start_time = 0, end_time = 0 where inner_job_id = 1428"

		],

		"transfer": {

			"files": [

			{

				"source": "/var/lib/jobarranger/server/iconexecmanager/in/1500000000000000033_1428_20250601171106.json",

				"destination": "/tmp"

			}

			],

			"uds": {

			"socket_path": ""

			}

		}

	}`

	TestAgentlessRunEventStr string = `
	{
		"event": {
			"name": "icon_exec_run",
			"unique_key": "agentless_icon_client_1750128515335531784"
		},
		"next_process": {
			"name": "iconexeccutionmanager",
			"data": {
				"transaction_file_id": "1500000000000000033_1428_20250601171106",
				"exec_process_data": {
					"run_job_data": {
						"inner_job_id": 1428,
						"inner_jobnet_id": 1500000000000000033,
						"inner_jobnet_main_id": 1500000000000000033,
						"job_type": 18
					},
					"run_jobnet_data": {
						"inner_jobnet_id": 1234,
						"inner_jobnet_main_id": 1500000000000000033,
						"inner_job_id": 1428,
						"jobnet_id": ""
					}
				}
			}
		},
		"queries": null,
		"transfer": {
			"files": [
				{
					"source": "/var/lib/jobarranger/server/iconexecmanager/in/150000000000000020_123_20250617091835.json",
					"destination": "/var/lib/jobarranger/server/150000000000000020_123_20250617091835.json"
				}
			],
			"uds": {
			"socket_path": "iconexeccutionmanager.sock"
			}
		}
	}
	`

	TestAgentlessEndEventStr string = `
	{
		"event": {
			"name": "icon_exec_end",
			"unique_key": "client_helper_1753689580473690813"
		},
		"next_process": {
			"name": "iconexecmanager",
			"data": {
				"transaction_file_id": "1500000000000000033_1428_20250601171106",
				"exec_process_data": {
					"run_job_data": {
						"inner_job_id": 1428,
						"inner_jobnet_id": 1500000000000000033,
						"inner_jobnet_main_id": 1500000000000000033,
						"job_type": 18
					},
					"run_jobnet_data": {
						"inner_jobnet_id": 1234,
						"inner_jobnet_main_id": 1500000000000000033,
						"inner_job_id": 1428,
						"jobnet_id": ""
					}
				}
			}
		},
		"queries": null,
		"transfer": {
			"files": [
			{
				"source": "/var/lib/jobarranger/server/iconexecmanager/in/1500000000000000033_1428_20250728142940.json",
				"destination": ""
			}
			],
			"uds": {
			"socket_path": ""
			}
		}
	}
	`

	TestAgentlessAbortEventStr string = `
	{
		"event": {
			"name": "icon_abort",
			"unique_key": "flowmanager_20250621063406"
		},
		"next_process": {
			"name": "iconexecmanager",
			"data": {
			"run_job_data": {
				"inner_job_id": 1426,
				"inner_jobnet_id": 1500000000000000033,
				"inner_jobnet_main_id": 1500000000000000033,
				"created_date": 1748347168,
				"invo_flag": 0,
				"job_type": 18,
				"data": null,
				"test_flag": 0,
				"method_flag": 3,
				"force_flag": 0,
				"timeout_flag": 0,
				"status": 2,
				"boot_count": 1,
				"end_count": 0,
				"start_time": 0,
				"end_time": 0,
				"point_x": 490,
				"point_y": 340,
				"job_id": "JOB-1",
				"job_name": "",
				"continue_flag": 0,
				"run_user": "",
				"run_user_password": "",
				"client_pid": 1234556789
			},
			"RunJobVariableData": {
				"inner_job_id": 0,
				"inner_jobnet_id": 0,
				"before_variable": null,
				"after_variable": null,
				"before_seq_no": 0,
				"after_seq_no": 0
			},
			"RunValueJobConData": null,
			"RunValueJobData": null,
			"SessionData": {
				"session_id": "",
				"inner_jobnet_main_id": 0,
				"inner_job_id": 0,
				"operation_flag": 0,
				"status": 0,
				"force_stop": 0,
				"pid": 1234556789,
				"ssh_client_socket": ""
			}
		}
	},
		"queries": [
			"UPDATE ja_2_run_job_table SET method_flag = 3 where inner_job_id = 1426"
		],
		"transfer": {
			"files": [
			{
				"source": "/var/lib/jobarranger/tmp/dbsyncermanager/in/1500000000000000033_1426_20250621063402.json",
				"destination": "/var/lib/jobarranger/tmp/iconexecmanager/in/1500000000000000033_1426_20250621063402.json"
			}
			],
			"uds": {
			"socket_path": ""
			}
		}
	}
	`

	TestJobReadyEventStr = `
	{
	"event": {
		"name": "icon_ready",
		"unique_key": "flowmanager_20250711161807"
	},
	"next_process": {
		"name": "iconexecmanager",
		"data": {
		"run_job_data": {
			"inner_job_id": 298,
			"inner_jobnet_id": 1500000000000000073,
			"inner_jobnet_main_id": 1500000000000000073,
			"created_date": 1752218275,
			"invo_flag": 0,
			"job_type": 4,
			"data": {
			"command": "hostname",
			"command_type": 0,
			"host_flag": 0,
			"host_ip": "10.1.8.85",
			"host_name": "oss.linux",
			"stop_code": "",
			"stop_command": "",
			"stop_flag": 0,
			"timeout": 0,
			"timeout_run_type": 0
			},
			"test_flag": 0,
			"method_flag": 0,
			"force_flag": 0,
			"timeout_flag": 0,
			"status": 1,
			"boot_count": 1,
			"end_count": 0,
			"start_time": 0,
			"end_time": 0,
			"point_x": 480,
			"point_y": 180,
			"job_id": "JOB-1",
			"jobnet_id": "",
			"job_name": "",
			"continue_flag": 0,
			"run_user": "",
			"run_user_password": "",
			"client_pid": 0,
			"stop_code": 0,
			"command_id": ""
		},
		"run_jobnet_data": {
			"inner_jobnet_id": 1234567890123456789,
			"inner_jobnet_main_id": 1234567890123456788,
			"inner_job_id": 9876543210987654321,
			"update_date": 1700784000,
			"created_date": 1700780000,
			"run_type": 1,
			"main_flag": 1,
			"invo_flag": 0,
			"timeout_flag": 0,
			"scheduled_time": 1700790000,
			"start_time": 1700790300,
			"end_time": 1700793900,
			"public_flag": 0,
			"multiple_start_up": 0,
			"jobnet_id": "JOBNET-001",
			"user_name": "alice",
			"jobnet_name": "Daily ETL",
			"memo": null,
			"schedule_id": null,
			"calendar_id": null,
			"boot_time": null,
			"execution_user_name": "etl_user",
			"running_job_id": null,
			"running_job_name": null,
			"initial_scheduled_time": 1700786400
		},
		"run_job_variable_data": {
			"inner_job_id": 298,
			"inner_jobnet_id": 1500000000000000073,
			"before_variable": {
			"inner_jobnet_main_id": 1500000000000000073,
			"jobnet_id": "JOBNET_1",
			"job_id": "JOB-1",
			"job_name": "",
			"full_job_id": "JOBNET_1/JOB-1",
			"jobnet_boot_time": "",
			"jobnet_scheduled_time": "",
			"current_time": "20250711161800"
			},
			"after_variable": null,
			"seq_no": 0
		},
		"RunValueJobConData": null,
		"run_value_job_data": null,
		"session_data": {
			"session_id": "",
			"inner_jobnet_main_id": 0,
			"inner_job_id": 0,
			"operation_flag": 0,
			"status": 0,
			"force_stop": 0,
			"pid": 0,
			"ssh_client_socket": ""
		},
		"run_flow_data": {
			"inner_flow_id": 0,
			"inner_jobnet_id": 0,
			"start_inner_job_id": 0,
			"end_inner_job_id": 0,
			"flow_type": 0,
			"flow_width": 0,
			"flow_style": ""
		},
		"job_result": {
			"jobid": "",
			"type": "",
			"method": 0,
			"script": "",
			"cur_unique_id": "",
			"pre_unique_id": "",
			"argument": null,
			"env": null,
			"run_user": null,
			"run_user_password": null,
			"jobstatus": 0,
			"pid": 0,
			"message": "",
			"hostname": "",
			"result": 0,
			"std_out": "",
			"std_err": "",
			"return_code": 0,
			"signal": 0
		},
		"parameter_data": {
			"parameter_name": "",
			"value": "",
			"created_date": 0
		},
		"jobnet_start_time": 0,
		"info_result_data": {
			"status": 0,
			"cal_result": false
		}
		}
	},
	"queries": [
		"DELETE FROM ja_2_run_job_variable_table WHERE inner_job_id = 298",
		"INSERT INTO ja_2_run_job_variable_table (inner_job_id, inner_jobnet_id, before_variable) VALUES (298, 1500000000000000073, '{\"inner_jobnet_main_id\":1500000000000000073,\"jobnet_id\":\"JOBNET_1\",\"job_id\":\"JOB-1\",\"job_name\":\"\",\"full_job_id\":\"JOBNET_1/JOB-1\",\"jobnet_boot_time\":\"\",\"jobnet_scheduled_time\":\"\",\"current_time\":\"20250711161800\"}')",
		"DELETE FROM ja_2_run_job_variable_table WHERE inner_job_id = 298",
		"INSERT INTO ja_2_run_job_variable_table (inner_job_id, inner_jobnet_id, before_variable) VALUES (298, 1500000000000000073, '{\"inner_jobnet_main_id\":1500000000000000073,\"jobnet_id\":\"JOBNET_1\",\"job_id\":\"JOB-1\",\"job_name\":\"\",\"full_job_id\":\"JOBNET_1/JOB-1\",\"jobnet_boot_time\":\"\",\"jobnet_scheduled_time\":\"\",\"current_time\":\"20250711161800\"}')",
		"select status from ja_2_run_job_table where inner_job_id = 298 for update",
		"update ja_2_run_job_table set status = 1, start_time = 0, end_time = 0 where inner_job_id = 298"
	],
	"transfer": {
		"files": [
		{
			"source": "/var/lib/jobarranger/server/dbsyncermanager/in/298_JOBNET_1_298_20250711161800.json",
			"destination": "/var/lib/jobarranger/server/iconexecmanager/in/298_JOBNET_1_298_20250711161800.json"
		}
		],
		"uds": {
		"socket_path": "/usr/local/bin/jobarranger/icon_exec_manager.sock"
		}
	}
	}
	`

	TestJobRunEventStr string = `
	{
		"event": {
			"name": "icon_exec_run",
			"unique_key": "job_icon_client_1750128515335531784"
		},
		"next_process": {
			"name": "iconexeccutionmanager",
			"data": {
				"transaction_file_id": "298_JOBNET_1_298_20250711161800",
				"exec_process_data": {
					"run_job_data": {
						"inner_job_id": 298,
						"inner_jobnet_id": 1500000000000000073,
						"inner_jobnet_main_id": 1500000000000000073,
						"created_date": 1752218275,
						"invo_flag": 0,
						"job_type": 4,
						"data": {
						},
						"test_flag": 0,
						"method_flag": 0,
						"force_flag": 0,
						"timeout_flag": 0,
						"status": 1,
						"boot_count": 1,
						"end_count": 0,
						"start_time": 0,
						"end_time": 0,
						"point_x": 480,
						"point_y": 180,
						"job_id": "JOB-1",
						"jobnet_id": "",
						"job_name": "",
						"continue_flag": 0,
						"run_user": "",
						"run_user_password": "",
						"client_pid": 0,
						"stop_code": 0,
						"command_id": ""
					},
					"run_jobnet_data": {
						"inner_jobnet_id": 1234567890123456789,
						"inner_jobnet_main_id": 1234567890123456788,
						"inner_job_id": 9876543210987654321,
						"update_date": 1700784000,
						"created_date": 1700780000,
						"run_type": 1,
						"main_flag": 1,
						"invo_flag": 0,
						"timeout_flag": 0,
						"scheduled_time": 1700790000,
						"start_time": 1700790300,
						"end_time": 1700793900,
						"public_flag": 0,
						"multiple_start_up": 0,
						"jobnet_id": "JOBNET-001",
						"user_name": "alice",
						"jobnet_name": "Daily ETL",
						"memo": null,
						"schedule_id": null,
						"calendar_id": null,
						"boot_time": null,
						"execution_user_name": "etl_user",
						"running_job_id": null,
						"running_job_name": null,
						"initial_scheduled_time": 1700786400
					},
					"run_job_variable_data": {
						"inner_job_id": 298,
						"inner_jobnet_id": 1500000000000000073,
						"before_variable": {
						"inner_jobnet_main_id": 1500000000000000073,
						"jobnet_id": "JOBNET_1",
						"job_id": "JOB-1",
						"job_name": "",
						"full_job_id": "JOBNET_1/JOB-1",
						"jobnet_boot_time": "",
						"jobnet_scheduled_time": "",
						"current_time": "20250711161800"
						},
						"after_variable": null,
						"seq_no": 0
					},
					"RunValueJobConData": null,
					"run_value_job_data": null,
					"session_data": {
						"session_id": "",
						"inner_jobnet_main_id": 0,
						"inner_job_id": 0,
						"operation_flag": 0,
						"status": 0,
						"force_stop": 0,
						"pid": 0,
						"ssh_client_socket": ""
					},
					"run_flow_data": {
						"inner_flow_id": 0,
						"inner_jobnet_id": 0,
						"start_inner_job_id": 0,
						"end_inner_job_id": 0,
						"flow_type": 0,
						"flow_width": 0,
						"flow_style": ""
					},
					"job_result": {
						"jobid": "",
						"type": "",
						"method": 0,
						"script": "",
						"cur_unique_id": "",
						"pre_unique_id": "",
						"argument": null,
						"env": null,
						"run_user": null,
						"run_user_password": null,
						"jobstatus": 0,
						"pid": 0,
						"message": "",
						"hostname": "",
						"result": 0,
						"std_out": "",
						"std_err": "",
						"return_code": 0,
						"signal": 0
					},
					"parameter_data": {
						"parameter_name": "",
						"value": "",
						"created_date": 0
					},
					"jobnet_start_time": 0,
					"info_result_data": {
						"status": 0,
						"cal_result": false
					}
				}
			}
		},
		"queries": null,
		"transfer": {
			"files": [
				{
					"source": "/var/lib/jobarranger/server/iconexecmanager/in/150000000000000020_123_20250617091835.json",
					"destination": "/var/lib/jobarranger/server/150000000000000020_123_20250617091835.json"
				}
			],
			"uds": {
			"socket_path": "iconexeccutionmanager.sock"
			}
		}
	}`

	TestJobEndEventStr string = `
	{
		"event": {
			"name": "icon_exec_end",
			"unique_key": "client_helper_1753691904708806857"
		},
		"next_process": {
			"name": "iconexecmanager",
			"data": {
			"transaction_file_id": "298_JOBNET_1_298_20250711161800",
			"result": {
				"JobId": 0,
				"Result": 0,
				"ReturnCode": 0,
				"Signal": 0,
				"Hostname": "",
				"Message": "",
				"Stdout": "",
				"Stderr": "",
				"CurUniqueId": "",
				"PreUniqueId": ""
			},
			"exec_process_data": {
				"run_job_data": {
				"inner_job_id": 298,
				"inner_jobnet_id": 1500000000000000073,
				"inner_jobnet_main_id": 1500000000000000073,
				"created_date": 1752218275,
				"invo_flag": 0,
				"job_type": 4,
				"data": {
					"command": "hostname",
					"command_type": 0,
					"host_flag": 0,
					"host_ip": "10.1.8.85",
					"host_name": "oss.linux",
					"stop_code": "",
					"stop_command": "",
					"stop_flag": 0,
					"timeout": 0,
					"timeout_run_type": 0
				},
				"test_flag": 0,
				"method_flag": 0,
				"force_flag": 0,
				"timeout_flag": 0,
				"status": 1,
				"boot_count": 1,
				"end_count": 0,
				"retry_count": 0,
				"start_time": 0,
				"end_time": 0,
				"point_x": 480,
				"point_y": 180,
				"job_id": "JOB-1",
				"job_name": "",
				"continue_flag": 0,
				"run_user": "",
				"run_user_password": "",
				"client_pid": 0
				},
				"run_jobnet_data": {
				"inner_jobnet_id": 0,
				"inner_jobnet_main_id": 0,
				"inner_job_id": 0,
				"update_date": 0,
				"created_date": 0,
				"run_type": 0,
				"main_flag": 0,
				"timeout_flag": 0,
				"status": 0,
				"scheduled_time": 0,
				"start_time": 0,
				"end_time": 0,
				"public_flag": 0,
				"multiple_start_up": 0,
				"jobnet_id": "",
				"user_name": "",
				"jobnet_name": "",
				"memo": "",
				"schedule_id": "",
				"calendar_id": "",
				"boot_time": "",
				"execution_user_name": "",
				"running_job_id": "",
				"running_job_name": "",
				"initial_scheduled_time": 0
				},
				"run_job_variable_data": {
				"inner_job_id": 298,
				"inner_jobnet_id": 1500000000000000073,
				"before_variable": {
					"inner_jobnet_main_id": 1500000000000000073,
					"jobnet_id": "JOBNET_1",
					"job_id": "JOB-1",
					"job_name": "",
					"full_job_id": "JOBNET_1/JOB-1",
					"jobnet_boot_time": "",
					"jobnet_scheduled_time": "",
					"current_time": "20250711161800"
				},
				"after_variable": null,
				"seq_no": 0
				},
				"run_value_jobcon_data": null,
				"run_value_job_data": null,
				"session_data": {
				"session_id": "",
				"inner_jobnet_main_id": 0,
				"inner_job_id": 0,
				"operation_flag": 0,
				"status": 0,
				"force_stop": 0,
				"pid": 0,
				"ssh_client_socket": ""
				},
				"job_result": {
				"jobid": "",
				"type": "",
				"method": 0,
				"script": "",
				"cur_unique_id": "",
				"pre_unique_id": "",
				"argument": null,
				"env": null,
				"run_user": null,
				"run_user_password": null,
				"jobstatus": 0,
				"pid": 0,
				"message": "",
				"hostname": "",
				"result": 0,
				"std_out": "",
				"std_err": "",
				"return_code": 0,
				"signal": 0,
				"host_job_list": null
				},
				"parameter_data": {
				"parameter_name": "",
				"value": "",
				"created_date": 0
				},
				"jobnet_start_time": 0,
				"info_status": 0,
				"jobnet_run_data": {
				"run_type": 0,
				"scheduled_time": 0,
				"multiple_start_up": 0,
				"main_flag": 0,
				"status": 0,
				"jobnet_id": "",
				"jobnet_name": "",
				"user_name": "",
				"inner_jobnet_main_id": 0,
				"inner_jobnet_id": 0,
				"inner_job_id": 0,
				"job_type": 0,
				"start_pending_flag": 0,
				"timeout_run_type": 0,
				"icon_timeout_run_type": 0,
				"load_status": 0,
				"jobnet_timeout": 0
				}
			}
			}
		},
		"queries": null,
		"transfer": {
			"files": [
			{
				"source": "/var/lib/jobarranger/server/iconexecmanager/in/1500000000000000073_298_20250728150824.json",
				"destination": ""
			}
			],
			"uds": {
			"socket_path": ""
			}
		}
	}
	`

	TestJobAbortEventStr = `
	{
		"event": {
			"name": "icon_ready",
			"unique_key": "flowmanager_20250711161807"
		},
		"next_process": {
			"name": "iconexecmanager",
			"data": {
			"run_job_data": {
				"inner_job_id": 298,
				"inner_jobnet_id": 1500000000000000073,
				"inner_jobnet_main_id": 1500000000000000073,
				"created_date": 1752218275,
				"invo_flag": 0,
				"job_type": 4,
				"data": {
				"command": "hostname",
				"command_type": 0,
				"host_flag": 0,
				"host_ip": "10.1.8.85",
				"host_name": "oss.linux",
				"stop_code": "",
				"stop_command": "",
				"stop_flag": 0,
				"timeout": 0,
				"timeout_run_type": 0
				},
				"test_flag": 0,
				"method_flag": 3,
				"force_flag": 0,
				"timeout_flag": 0,
				"status": 1,
				"boot_count": 1,
				"end_count": 0,
				"start_time": 0,
				"end_time": 0,
				"point_x": 480,
				"point_y": 180,
				"job_id": "JOB-1",
				"jobnet_id": "",
				"job_name": "",
				"continue_flag": 0,
				"run_user": "",
				"run_user_password": "",
				"client_pid": 0,
				"stop_code": 0,
				"command_id": ""
			},
			"run_job_variable_data": {
				"inner_job_id": 298,
				"inner_jobnet_id": 1500000000000000073,
				"before_variable": {
				"inner_jobnet_main_id": 1500000000000000073,
				"jobnet_id": "JOBNET_1",
				"job_id": "JOB-1",
				"job_name": "",
				"full_job_id": "JOBNET_1/JOB-1",
				"jobnet_boot_time": "",
				"jobnet_scheduled_time": "",
				"current_time": "20250711161800"
				},
				"after_variable": null,
				"seq_no": 0
			},
			"RunValueJobConData": null,
			"run_value_job_data": null,
			"session_data": {
				"session_id": "",
				"inner_jobnet_main_id": 0,
				"inner_job_id": 0,
				"operation_flag": 0,
				"status": 0,
				"force_stop": 0,
				"pid": 0,
				"ssh_client_socket": ""
			},
			"run_flow_data": {
				"inner_flow_id": 0,
				"inner_jobnet_id": 0,
				"start_inner_job_id": 0,
				"end_inner_job_id": 0,
				"flow_type": 0,
				"flow_width": 0,
				"flow_style": ""
			},
			"job_result": {
				"jobid": "",
				"type": "",
				"method": 0,
				"script": "",
				"cur_unique_id": "",
				"pre_unique_id": "",
				"argument": null,
				"env": null,
				"run_user": null,
				"run_user_password": null,
				"jobstatus": 0,
				"pid": 0,
				"message": "",
				"hostname": "",
				"result": 0,
				"std_out": "",
				"std_err": "",
				"return_code": 0,
				"signal": 0
			},
			"parameter_data": {
				"parameter_name": "",
				"value": "",
				"created_date": 0
			},
			"jobnet_start_time": 0,
			"info_result_data": {
				"status": 0,
				"cal_result": false
			}
			}
		},
		"queries": [
			"DELETE FROM ja_2_run_job_variable_table WHERE inner_job_id = 298",
			"INSERT INTO ja_2_run_job_variable_table (inner_job_id, inner_jobnet_id, before_variable) VALUES (298, 1500000000000000073, '{\"inner_jobnet_main_id\":1500000000000000073,\"jobnet_id\":\"JOBNET_1\",\"job_id\":\"JOB-1\",\"job_name\":\"\",\"full_job_id\":\"JOBNET_1/JOB-1\",\"jobnet_boot_time\":\"\",\"jobnet_scheduled_time\":\"\",\"current_time\":\"20250711161800\"}')",
			"DELETE FROM ja_2_run_job_variable_table WHERE inner_job_id = 298",
			"INSERT INTO ja_2_run_job_variable_table (inner_job_id, inner_jobnet_id, before_variable) VALUES (298, 1500000000000000073, '{\"inner_jobnet_main_id\":1500000000000000073,\"jobnet_id\":\"JOBNET_1\",\"job_id\":\"JOB-1\",\"job_name\":\"\",\"full_job_id\":\"JOBNET_1/JOB-1\",\"jobnet_boot_time\":\"\",\"jobnet_scheduled_time\":\"\",\"current_time\":\"20250711161800\"}')",
			"select status from ja_2_run_job_table where inner_job_id = 298 for update",
			"update ja_2_run_job_table set status = 1, start_time = 0, end_time = 0 where inner_job_id = 298"
		],
		"transfer": {
			"files": [
			{
				"source": "/var/lib/jobarranger/server/dbsyncermanager/in/298_JOBNET_1_298_20250711161800.json",
				"destination": "/var/lib/jobarranger/server/iconexecmanager/in/298_JOBNET_1_298_20250711161800.json"
			}
			],
			"uds": {
			"socket_path": "/usr/local/bin/jobarranger/icon_exec_manager.sock"
			}
		}
	}
	`

	TestExtJobReadyEventStr string = `
	{
		"event": {

			"name": "icon_ready",

			"unique_key": ""

		},

		"next_process": {

			"name": "icon_execution_manager",

			"data": {

			"run_job_data": {

				"inner_job_id": 1428,

				"inner_jobnet_id": 0,

				"inner_jobnet_main_id": 1500000000000000033,

				"inner_job_id_fs_link": 0,

				"created_date": 0,

				"invo_flag": 0,

				"job_type": 9,

				"data": {
					"command_id": "",
					"value": ""
				},

				"test_flag": 0,

				"method_flag": 0,

				"force_flag": 0,

				"timeout_flag": 0,

				"status": 0,

				"boot_count": 0,

				"end_count": 0,

				"start_time": 0,

				"end_time": 0,

				"point_x": 0,

				"point_y": 0,

				"job_id": "",

				"job_name": "",

				"continue_flag": 0,

				"run_user": "",

				"run_user_password": ""

			},

			"RunJobVariableData": {

				"inner_job_id": 0,

				"inner_jobnet_id": 0,

				"before_variable": null,

				"after_variable": null,

				"before_seq_no": 0,

				"after_seq_no": 0

			}

		}

	},

		"queries": [

			"INSERT INTO ja_2_run_job_variable_table (inner_job_id, inner_jobnet_id, before_variable, before_seq_no) VALUES (1428, 1500000000000000033, '{\"JOBNET_ID\":1234,\"USER_NAME\":\"admin\",\"JOBNET_NAME\":\"SampleJobnet\",\"MANAGEMENT_ID\":1500000000000000006,\"JOBNET_BOOT_TIME\":\"20250520134658\",\"JOBNET_SCHEDULED_TIME\":\"20250519120000\"}', 20250601171106)",

			"select status from ja_run_job_table where inner_job_id = 1428 for update",

			"update ja_run_job_table set status = 1, start_time = 0, end_time = 0 where inner_job_id = 1428"

		],

		"transfer": {

			"files": [

			{

				"source": "/var/lib/jobarranger/server/iconexecmanager/in/1500000000000000033_1428_20250601171106.json",

				"destination": "/tmp"

			}

			],

			"uds": {

			"socket_path": ""

			}

		}

	}`

	TestExtJobAbortEventStr string = `
	{
		"event": {

			"name": "icon_ready",

			"unique_key": ""

		},

		"next_process": {

			"name": "icon_execution_manager",

			"data": {

			"run_job_data": {

				"inner_job_id": 1428,

				"inner_jobnet_id": 0,

				"inner_jobnet_main_id": 1500000000000000033,

				"inner_job_id_fs_link": 0,

				"created_date": 0,

				"invo_flag": 0,

				"job_type": 9,

				"data": {
					"command_id": "",
					"value": ""
				},

				"test_flag": 0,

				"method_flag": 3,

				"force_flag": 0,

				"timeout_flag": 0,

				"status": 0,

				"boot_count": 0,

				"end_count": 0,

				"start_time": 0,

				"end_time": 0,

				"point_x": 0,

				"point_y": 0,

				"job_id": "",

				"job_name": "",

				"continue_flag": 0,

				"run_user": "",

				"run_user_password": ""

			},

			"RunJobVariableData": {

				"inner_job_id": 0,

				"inner_jobnet_id": 0,

				"before_variable": null,

				"after_variable": null,

				"before_seq_no": 0,

				"after_seq_no": 0

			}

		}

	},

		"queries": [

			"INSERT INTO ja_2_run_job_variable_table (inner_job_id, inner_jobnet_id, before_variable, before_seq_no) VALUES (1428, 1500000000000000033, '{\"JOBNET_ID\":1234,\"USER_NAME\":\"admin\",\"JOBNET_NAME\":\"SampleJobnet\",\"MANAGEMENT_ID\":1500000000000000006,\"JOBNET_BOOT_TIME\":\"20250520134658\",\"JOBNET_SCHEDULED_TIME\":\"20250519120000\"}', 20250601171106)",

			"select status from ja_run_job_table where inner_job_id = 1428 for update",

			"update ja_run_job_table set status = 1, start_time = 0, end_time = 0 where inner_job_id = 1428"

		],

		"transfer": {

			"files": [

			{

				"source": "/var/lib/jobarranger/server/iconexecmanager/in/1500000000000000033_1428_20250601171106.json",

				"destination": "/tmp"

			}

			],

			"uds": {

			"socket_path": ""

			}

		}

	}`
	
	TestExtJobRunEventStr string = `
	{
		"event": {
			"name": "icon_exec_run",
			"unique_key": "agentless_icon_client_1750128515335531784"
		},
		"next_process": {
			"name": "iconexeccutionmanager",
			"data": {
				"transaction_file_id": "1500000000000000033_1428_20250601171106",
				"exec_process_data": {
					"run_job_data": {
						"inner_job_id": 1428,
						"inner_jobnet_id": 1500000000000000033,
						"inner_jobnet_main_id": 1500000000000000033,
						"job_type": 9
					},
					"run_jobnet_data": {
						"inner_jobnet_id": 1234,
						"inner_jobnet_main_id": 1500000000000000033,
						"inner_job_id": 1428,
						"jobnet_id": ""
					}
				}
			}
		},
		"queries": null,
		"transfer": {
			"files": [
				{
					"source": "/var/lib/jobarranger/server/iconexecmanager/in/150000000000000020_123_20250617091835.json",
					"destination": "/var/lib/jobarranger/server/150000000000000020_123_20250617091835.json"
				}
			],
			"uds": {
			"socket_path": "iconexeccutionmanager.sock"
			}
		}
	}`

	TestExtJobEndEventStr string = `
	{
		"event": {
			"name": "icon_exec_end",
			"unique_key": "client_helper_1751512021329853579"
		},
		"next_process": {
			"name": "iconexecmanager",
			"data": {
			"transaction_file_id": "1500000000000000033_1428_20250601171106",
			"exec_process_data": {
				"run_job_data": {
					"inner_job_id": 1428,
					"inner_jobnet_id": 1500000000000000033,
					"inner_jobnet_main_id": 1500000000000000033,
					"job_type": 9
				},
				"run_jobnet_data": {
					"inner_jobnet_id": 1234,
					"inner_jobnet_main_id": 1500000000000000033,
					"inner_job_id": 1428,
					"jobnet_id": ""
				}
			}
		}
		},
		"queries": null,
		"transfer": {
			"files": [
			{
				"source": "/var/lib/jobarranger/server/iconexecmanager/in/1500000000000000033_1428_20250703093701.json",
				"destination": ""
			}
			],
			"uds": {
			"socket_path": ""
			}
		}
	}
	`

	TestIfReadyEventStr string = `
	{
		"event": {

			"name": "icon_ready",

			"unique_key": ""

		},

		"next_process": {

			"name": "icon_execution_manager",

			"data": {

			"run_job_data": {

				"inner_job_id": 1428,

				"inner_jobnet_id": 0,

				"inner_jobnet_main_id": 1500000000000000033,

				"inner_job_id_fs_link": 0,

				"created_date": 0,

				"invo_flag": 0,

				"job_type": 2,

				"data": {
					"hand_flag": 0,
					"ValueName": "",
					"ComparisonValue": ""
				},

				"test_flag": 0,

				"method_flag": 0,

				"force_flag": 0,

				"timeout_flag": 0,

				"status": 0,

				"boot_count": 0,

				"end_count": 0,

				"start_time": 0,

				"end_time": 0,

				"point_x": 0,

				"point_y": 0,

				"job_id": "",

				"job_name": "",

				"continue_flag": 0,

				"run_user": "",

				"run_user_password": ""

			},

			"RunJobVariableData": {

				"inner_job_id": 0,

				"inner_jobnet_id": 0,

				"before_variable": null,

				"after_variable": null,

				"before_seq_no": 0,

				"after_seq_no": 0

			}

		}

	},

		"queries": [

			"INSERT INTO ja_2_run_job_variable_table (inner_job_id, inner_jobnet_id, before_variable, before_seq_no) VALUES (1428, 1500000000000000033, '{\"JOBNET_ID\":1234,\"USER_NAME\":\"admin\",\"JOBNET_NAME\":\"SampleJobnet\",\"MANAGEMENT_ID\":1500000000000000006,\"JOBNET_BOOT_TIME\":\"20250520134658\",\"JOBNET_SCHEDULED_TIME\":\"20250519120000\"}', 20250601171106)",

			"select status from ja_run_job_table where inner_job_id = 1428 for update",

			"update ja_run_job_table set status = 1, start_time = 0, end_time = 0 where inner_job_id = 1428"

		],

		"transfer": {

			"files": [

			{

				"source": "/var/lib/jobarranger/server/iconexecmanager/in/1500000000000000033_1428_20250601171106.json",

				"destination": "/tmp"

			}

			],

			"uds": {

			"socket_path": ""

			}

		}

	}`

	TestIfRunEventStr string = `
	{
		"event": {
			"name": "icon_exec_run",
			"unique_key": "agentless_icon_client_1750128515335531784"
		},
		"next_process": {
			"name": "iconexeccutionmanager",
			"data": {
				"transaction_file_id": "1500000000000000033_1428_20250601171106",
				"exec_process_data": {
					"run_job_data": {
						"inner_job_id": 1428,
						"inner_jobnet_id": 1500000000000000033,
						"inner_jobnet_main_id": 1500000000000000033,
						"job_type": 2
					},
					"run_jobnet_data": {
						"inner_jobnet_id": 1234,
						"inner_jobnet_main_id": 1500000000000000033,
						"inner_job_id": 1428,
						"jobnet_id": ""
					}
				}
			}
		},
		"queries": null,
		"transfer": {
			"files": [
				{
					"source": "/var/lib/jobarranger/server/iconexecmanager/in/150000000000000020_123_20250617091835.json",
					"destination": "/var/lib/jobarranger/server/150000000000000020_123_20250617091835.json"
				}
			],
			"uds": {
			"socket_path": "iconexeccutionmanager.sock"
			}
		}
	}`

	TestIfEndEventStr string = `
	{
	"event": {
		"name": "icon_exec_end",
		"unique_key": "client_helper_1751615405798447803"
	},
	"next_process": {
		"name": "iconexecmanager",
		"data": {
			"transaction_file_id": "1500000000000000033_1428_20250601171106",
			"exec_process_data": {
				"run_job_data": {
					"inner_job_id": 1428,
					"inner_jobnet_id": 1500000000000000033,
					"inner_jobnet_main_id": 1500000000000000033,
					"job_type": 2
				},
				"run_jobnet_data": {
					"inner_jobnet_id": 1234,
					"inner_jobnet_main_id": 1500000000000000033,
					"inner_job_id": 1428,
					"jobnet_id": ""
				}
			}
		}
	},
	"queries": null,
	"transfer": {
		"files": [
		{
			"source": "/var/lib/jobarranger/server/iconexecmanager/in/1500000000000000033_1428_20250704142005.json",
			"destination": ""
		}
		],
		"uds": {
		"socket_path": ""
		}
	}
	}
	`

	TestStartReadyEventStr string = `
	{
		"event": {

			"name": "icon_ready",

			"unique_key": ""

		},

		"next_process": {

			"name": "icon_execution_manager",

			"data": {

			"run_job_data": {

				"inner_job_id": 1428,

				"inner_jobnet_id": 0,

				"inner_jobnet_main_id": 1500000000000000033,

				"inner_job_id_fs_link": 0,

				"created_date": 0,

				"invo_flag": 0,

				"job_type": 0,

				"test_flag": 0,

				"method_flag": 0,

				"force_flag": 0,

				"timeout_flag": 0,

				"status": 0,

				"boot_count": 0,

				"end_count": 0,

				"start_time": 0,

				"end_time": 0,

				"point_x": 0,

				"point_y": 0,

				"job_id": "",

				"job_name": "",

				"continue_flag": 0,

				"run_user": "",

				"run_user_password": ""

			},

			"RunJobVariableData": {

				"inner_job_id": 0,

				"inner_jobnet_id": 0,

				"before_variable": null,

				"after_variable": null,

				"before_seq_no": 0,

				"after_seq_no": 0

			}

		}

	},

		"queries": [

			"INSERT INTO ja_2_run_job_variable_table (inner_job_id, inner_jobnet_id, before_variable, before_seq_no) VALUES (1428, 1500000000000000033, '{\"JOBNET_ID\":1234,\"USER_NAME\":\"admin\",\"JOBNET_NAME\":\"SampleJobnet\",\"MANAGEMENT_ID\":1500000000000000006,\"JOBNET_BOOT_TIME\":\"20250520134658\",\"JOBNET_SCHEDULED_TIME\":\"20250519120000\"}', 20250601171106)",

			"select status from ja_run_job_table where inner_job_id = 1428 for update",

			"update ja_run_job_table set status = 1, start_time = 0, end_time = 0 where inner_job_id = 1428"

		],

		"transfer": {

			"files": [

			{

				"source": "/var/lib/jobarranger/server/iconexecmanager/in/1500000000000000033_1428_20250601171106.json",

				"destination": "/tmp"

			}

			],

			"uds": {

			"socket_path": ""

			}

		}

	}`

	TestStartRunEventStr string = `
	{
		"event": {
			"name": "icon_exec_run",
			"unique_key": "agentless_icon_client_1750128515335531784"
		},
		"next_process": {
			"name": "iconexeccutionmanager",
			"data":	{
				"transaction_file_id": "1500000000000000033_1428_20250601171106",
				"exec_process_data": {
					"run_job_data": {
						"inner_job_id": 1428,
						"inner_jobnet_id": 1500000000000000033,
						"inner_jobnet_main_id": 1500000000000000033,
						"job_type": 0
					},
					"run_jobnet_data": {
						"inner_jobnet_id": 1234,
						"inner_jobnet_main_id": 1500000000000000033,
						"inner_job_id": 1428,
						"jobnet_id": ""
					}
				}
			}
		},
		"queries": null,
		"transfer": {
			"files": [
				{
					"source": "/var/lib/jobarranger/server/iconexecmanager/in/150000000000000020_123_20250617091835.json",
					"destination": "/var/lib/jobarranger/server/150000000000000020_123_20250617091835.json"
				}
			],
			"uds": {
			"socket_path": "iconexeccutionmanager.sock"
			}
		}
	}`

	TestStartEndEventStr string = `
	{
		"event": {
			"name": "icon_exec_end",
			"unique_key": "client_helper_1753689580473690813"
		},
		"next_process": {
			"name": "iconexecmanager",
			"data": {
				"transaction_file_id": "1500000000000000033_1428_20250601171106",
				"exec_process_data": {
					"run_job_data": {
						"inner_job_id": 1428,
						"inner_jobnet_id": 1500000000000000033,
						"inner_jobnet_main_id": 1500000000000000033,
						"job_type": 0
					},
					"run_jobnet_data": {
						"inner_jobnet_id": 1234,
						"inner_jobnet_main_id": 1500000000000000033,
						"inner_job_id": 1428,
						"jobnet_id": ""
					}
				}
			}
		},
		"queries": null,
		"transfer": {
			"files": [
			{
				"source": "/var/lib/jobarranger/server/iconexecmanager/in/1500000000000000033_1428_20250728142940.json",
				"destination": ""
			}
			],
			"uds": {
			"socket_path": ""
			}
		}
	}
	`

	TestEndReadyEventStr string = `
	{
		"event": {

			"name": "icon_ready",

			"unique_key": ""

		},

		"next_process": {

			"name": "icon_execution_manager",

			"data": {

			"run_job_data": {

				"inner_job_id": 1428,

				"inner_jobnet_id": 0,

				"inner_jobnet_main_id": 1500000000000000033,

				"inner_job_id_fs_link": 0,

				"created_date": 0,

				"invo_flag": 0,

				"job_type": 1,

				"data": {
					"jobnet_stop_code": 1,
					"jobnet_stop_flag": 1
				},

				"test_flag": 0,

				"method_flag": 0,

				"force_flag": 0,

				"timeout_flag": 0,

				"status": 0,

				"boot_count": 0,

				"end_count": 0,

				"start_time": 0,

				"end_time": 0,

				"point_x": 0,

				"point_y": 0,

				"job_id": "",

				"job_name": "",

				"continue_flag": 0,

				"run_user": "",

				"run_user_password": ""

			},

			"RunJobVariableData": {

				"inner_job_id": 0,

				"inner_jobnet_id": 0,

				"before_variable": null,

				"after_variable": null,

				"before_seq_no": 0,

				"after_seq_no": 0

			}

		}

	},

		"queries": [

			"INSERT INTO ja_2_run_job_variable_table (inner_job_id, inner_jobnet_id, before_variable, before_seq_no) VALUES (1428, 1500000000000000033, '{\"JOBNET_ID\":1234,\"USER_NAME\":\"admin\",\"JOBNET_NAME\":\"SampleJobnet\",\"MANAGEMENT_ID\":1500000000000000006,\"JOBNET_BOOT_TIME\":\"20250520134658\",\"JOBNET_SCHEDULED_TIME\":\"20250519120000\"}', 20250601171106)",

			"select status from ja_run_job_table where inner_job_id = 1428 for update",

			"update ja_run_job_table set status = 1, start_time = 0, end_time = 0 where inner_job_id = 1428"

		],

		"transfer": {

			"files": [

			{

				"source": "/var/lib/jobarranger/server/iconexecmanager/in/1500000000000000033_1428_20250601171106.json",

				"destination": "/tmp"

			}

			],

			"uds": {

			"socket_path": ""

			}

		}

	}`

	TestEndRunEventStr string = `
	{
		"event": {
			"name": "icon_exec_run",
			"unique_key": "agentless_icon_client_1750128515335531784"
		},
		"next_process": {
			"name": "iconexeccutionmanager",
			"data": {
				"transaction_file_id": "1500000000000000033_1428_20250601171106",
				"exec_process_data": {
					"run_job_data": {
						"inner_job_id": 298,
						"inner_jobnet_id": 1500000000000000073,
						"inner_jobnet_main_id": 1500000000000000073,
						"created_date": 1752218275,
						"invo_flag": 0,
						"job_type": 1,
						"data": {
						},
						"test_flag": 0,
						"method_flag": 0,
						"force_flag": 0,
						"timeout_flag": 0,
						"status": 1,
						"boot_count": 1,
						"end_count": 0,
						"start_time": 0,
						"end_time": 0,
						"point_x": 480,
						"point_y": 180,
						"job_id": "JOB-1",
						"jobnet_id": "",
						"job_name": "",
						"continue_flag": 0,
						"run_user": "",
						"run_user_password": "",
						"client_pid": 0,
						"stop_code": 0,
						"command_id": ""
					},
					"run_job_variable_data": {
						"inner_job_id": 298,
						"inner_jobnet_id": 1500000000000000073,
						"before_variable": {
						"inner_jobnet_main_id": 1500000000000000073,
						"jobnet_id": "JOBNET_1",
						"job_id": "JOB-1",
						"job_name": "",
						"full_job_id": "JOBNET_1/JOB-1",
						"jobnet_boot_time": "",
						"jobnet_scheduled_time": "",
						"current_time": "20250711161800"
						},
						"after_variable": null,
						"seq_no": 0
					},
					"RunValueJobConData": null,
					"run_value_job_data": null,
					"session_data": {
						"session_id": "",
						"inner_jobnet_main_id": 0,
						"inner_job_id": 0,
						"operation_flag": 0,
						"status": 0,
						"force_stop": 0,
						"pid": 0,
						"ssh_client_socket": ""
					},
					"run_flow_data": {
						"inner_flow_id": 0,
						"inner_jobnet_id": 0,
						"start_inner_job_id": 0,
						"end_inner_job_id": 0,
						"flow_type": 0,
						"flow_width": 0,
						"flow_style": ""
					},
					"job_result": {
						"jobid": "",
						"type": "",
						"method": 0,
						"script": "",
						"cur_unique_id": "",
						"pre_unique_id": "",
						"argument": null,
						"env": null,
						"run_user": null,
						"run_user_password": null,
						"jobstatus": 0,
						"pid": 0,
						"message": "",
						"hostname": "",
						"result": 0,
						"std_out": "",
						"std_err": "",
						"return_code": 0,
						"signal": 0
					},
					"parameter_data": {
						"parameter_name": "",
						"value": "",
						"created_date": 0
					},
					"jobnet_start_time": 0,
					"info_result_data": {
						"status": 0,
						"cal_result": false
					}
				}
			}
		},
		"queries": null,
		"transfer": {
			"files": [
				{
					"source": "/var/lib/jobarranger/server/iconexecmanager/in/150000000000000020_123_20250617091835.json",
					"destination": "/var/lib/jobarranger/server/150000000000000020_123_20250617091835.json"
				}
			],
			"uds": {
			"socket_path": "iconexeccutionmanager.sock"
			}
		}
	}`

	TestEndEndEventStr string = `
		{
			"event": {
				"name": "icon_exec_end",
				"unique_key": "client_helper_1753690247072159428"
			},
			"next_process": {
				"name": "iconexecmanager",
				"data": {
				"transaction_file_id": "1500000000000000033_1428_20250601171106",
				"result": {
					"JobId": 0,
					"Result": 0,
					"ReturnCode": 0,
					"Signal": 0,
					"Hostname": "",
					"Message": "",
					"Stdout": "",
					"Stderr": "",
					"CurUniqueId": "",
					"PreUniqueId": ""
				},
				"exec_process_data": {
					"run_job_data": {
					"inner_job_id": 1428,
					"inner_jobnet_id": 0,
					"inner_jobnet_main_id": 1500000000000000033,
					"created_date": 0,
					"invo_flag": 0,
					"job_type": 1,
					"data": {
						"jobnet_stop_code": 1,
						"jobnet_stop_flag": 1
					},
					"test_flag": 0,
					"method_flag": 0,
					"force_flag": 0,
					"timeout_flag": 0,
					"status": 0,
					"boot_count": 0,
					"end_count": 0,
					"retry_count": 0,
					"start_time": 0,
					"end_time": 0,
					"point_x": 0,
					"point_y": 0,
					"job_id": "",
					"job_name": "",
					"continue_flag": 0,
					"run_user": "",
					"run_user_password": "",
					"client_pid": 0
					},
					"run_jobnet_data": {
					"inner_jobnet_id": 0,
					"inner_jobnet_main_id": 0,
					"inner_job_id": 0,
					"update_date": 0,
					"created_date": 0,
					"run_type": 0,
					"main_flag": 0,
					"timeout_flag": 0,
					"status": 0,
					"scheduled_time": 0,
					"start_time": 0,
					"end_time": 0,
					"public_flag": 0,
					"multiple_start_up": 0,
					"jobnet_id": "",
					"user_name": "",
					"jobnet_name": "",
					"memo": "",
					"schedule_id": "",
					"calendar_id": "",
					"boot_time": "",
					"execution_user_name": "",
					"running_job_id": "",
					"running_job_name": "",
					"initial_scheduled_time": 0
					},
					"run_job_variable_data": {
					"inner_job_id": 0,
					"inner_jobnet_id": 0,
					"before_variable": null,
					"after_variable": null,
					"seq_no": 0
					},
					"run_value_jobcon_data": null,
					"run_value_job_data": null,
					"session_data": {
					"session_id": "",
					"inner_jobnet_main_id": 0,
					"inner_job_id": 0,
					"operation_flag": 0,
					"status": 0,
					"force_stop": 0,
					"pid": 0,
					"ssh_client_socket": ""
					},
					"job_result": {
					"jobid": "",
					"type": "",
					"method": 0,
					"script": "",
					"cur_unique_id": "",
					"pre_unique_id": "",
					"argument": null,
					"env": null,
					"run_user": null,
					"run_user_password": null,
					"jobstatus": 0,
					"pid": 0,
					"message": "",
					"hostname": "",
					"result": 0,
					"std_out": "",
					"std_err": "",
					"return_code": 0,
					"signal": 0,
					"host_job_list": null
					},
					"parameter_data": {
					"parameter_name": "",
					"value": "",
					"created_date": 0
					},
					"jobnet_start_time": 0,
					"info_status": 0,
					"jobnet_run_data": {
					"run_type": 0,
					"scheduled_time": 0,
					"multiple_start_up": 0,
					"main_flag": 0,
					"status": 0,
					"jobnet_id": "",
					"jobnet_name": "",
					"user_name": "",
					"inner_jobnet_main_id": 0,
					"inner_jobnet_id": 0,
					"inner_job_id": 0,
					"job_type": 0,
					"start_pending_flag": 0,
					"timeout_run_type": 0,
					"icon_timeout_run_type": 0,
					"load_status": 0,
					"jobnet_timeout": 0
					}
				}
				}
			},
			"queries": null,
			"transfer": {
				"files": [
				{
					"source": "/var/lib/jobarranger/server/iconexecmanager/in/1500000000000000033_1428_20250728144047.json",
					"destination": ""
				}
				],
				"uds": {
				"socket_path": ""
				}
			}
		}
	`

	TestCalculateReadyEventStr string = `
	{
		"event": {

			"name": "icon_ready",

			"unique_key": ""

		},

		"next_process": {

			"name": "icon_execution_manager",

			"data": {

			"run_job_data": {

				"inner_job_id": 1428,

				"inner_jobnet_id": 0,

				"inner_jobnet_main_id": 1500000000000000033,

				"inner_job_id_fs_link": 0,

				"created_date": 0,

				"invo_flag": 0,

				"job_type": 10,

				"data": {
					"hand_flag": 0,
					"formula": "",
					"value_name": "",
					"value": ""
				},

				"test_flag": 0,

				"method_flag": 0,

				"force_flag": 0,

				"timeout_flag": 0,

				"status": 0,

				"boot_count": 0,

				"end_count": 0,

				"start_time": 0,

				"end_time": 0,

				"point_x": 0,

				"point_y": 0,

				"job_id": "",

				"job_name": "",

				"continue_flag": 0,

				"run_user": "",

				"run_user_password": ""

			},

			"RunJobVariableData": {

				"inner_job_id": 0,

				"inner_jobnet_id": 0,

				"before_variable": null,

				"after_variable": null,

				"before_seq_no": 0,

				"after_seq_no": 0

			}

		}

	},

		"queries": [

			"INSERT INTO ja_2_run_job_variable_table (inner_job_id, inner_jobnet_id, before_variable, before_seq_no) VALUES (1428, 1500000000000000033, '{\"JOBNET_ID\":1234,\"USER_NAME\":\"admin\",\"JOBNET_NAME\":\"SampleJobnet\",\"MANAGEMENT_ID\":1500000000000000006,\"JOBNET_BOOT_TIME\":\"20250520134658\",\"JOBNET_SCHEDULED_TIME\":\"20250519120000\"}', 20250601171106)",

			"select status from ja_run_job_table where inner_job_id = 1428 for update",

			"update ja_run_job_table set status = 1, start_time = 0, end_time = 0 where inner_job_id = 1428"

		],

		"transfer": {

			"files": [

			{

				"source": "/var/lib/jobarranger/server/iconexecmanager/in/1500000000000000033_1428_20250601171106.json",

				"destination": "/tmp"

			}

			],

			"uds": {

			"socket_path": ""

			}

		}

	}`

	TestCalculateRunEventStr string = `
	{
		"event": {
			"name": "icon_exec_run",
			"unique_key": "agentless_icon_client_1750128515335531784"
		},
		"next_process": {
			"name": "iconexeccutionmanager",
			"data": {
			"transaction_file_id": "1500000000000000033_1428_20250601171106",
			"exec_process_data": {
				"run_job_data": {
					"inner_job_id": 1428,
					"inner_jobnet_id": 1500000000000000033,
					"inner_jobnet_main_id": 1500000000000000033,
					"job_type": 10
				},
				"run_jobnet_data": {
					"inner_jobnet_id": 1234,
					"inner_jobnet_main_id": 1500000000000000033,
					"inner_job_id": 1428,
					"jobnet_id": ""
				}
			}
			}
		},
		"queries": null,
		"transfer": {
			"files": [
				{
					"source": "/var/lib/jobarranger/server/iconexecmanager/in/150000000000000020_123_20250617091835.json",
					"destination": "/var/lib/jobarranger/server/150000000000000020_123_20250617091835.json"
				}
			],
			"uds": {
			"socket_path": "iconexeccutionmanager.sock"
			}
		}
	}`

	TestCalculateEndEventStr string = `
	{
	"event": {
		"name": "icon_exec_end",
		"unique_key": "client_helper_1752081023462990868"
	},
	"next_process": {
		"name": "iconexecmanager",
		"data": {
			"transaction_file_id": "1500000000000000033_1428_20250601171106",
			"exec_process_data": {
				"run_job_data": {
					"inner_job_id": 1428,
					"inner_jobnet_id": 1500000000000000033,
					"inner_jobnet_main_id": 1500000000000000033,
					"job_type": 10
				},
				"run_jobnet_data": {
					"inner_jobnet_id": 1234,
					"inner_jobnet_main_id": 1500000000000000033,
					"inner_job_id": 1428,
					"jobnet_id": ""
				}
			}
		}
	},
	"queries": null,
	"transfer": {
		"files": [
		{
			"source": "/var/lib/jobarranger/server/iconexecmanager/in/1500000000000000033_1428_20250709234023.json",
			"destination": ""
		}
		],
		"uds": {
		"socket_path": ""
		}
	}
	}
	`

	TestFcopyReadyEventStr string = `
	{
		"event": {

			"name": "icon_ready",

			"unique_key": ""

		},

		"next_process": {

			"name": "icon_execution_manager",

			"data": {

			"run_job_data": {

				"inner_job_id": 1428,

				"inner_jobnet_id": 0,

				"inner_jobnet_main_id": 1500000000000000033,

				"inner_job_id_fs_link": 0,

				"created_date": 0,

				"invo_flag": 0,

				"job_type": 14,

				"data": {
					"from_host_flag": 1,
					"from_host_port": 22,
					"to_host_flag": 1,
					"to_host_port": 22,
					"overwrite_flag": 0,
					"jaz1_support_flag": 1,
					"from_host_name": "source-server",
					"from_host_ip": "192.168.1.10",
					"from_directory": "/data/source",
					"from_file_name": "example.txt",
					"to_host_name": "destination-server",
					"to_host_ip": "192.168.1.20",
					"to_directory": "/data/destination"
				},

				"test_flag": 0,

				"method_flag": 0,

				"force_flag": 0,

				"timeout_flag": 0,

				"status": 0,

				"boot_count": 0,

				"end_count": 0,

				"start_time": 0,

				"end_time": 0,

				"point_x": 0,

				"point_y": 0,

				"job_id": "",

				"job_name": "",

				"continue_flag": 0,

				"run_user": "",

				"run_user_password": ""

			},

			"RunJobVariableData": {

				"inner_job_id": 0,

				"inner_jobnet_id": 0,

				"before_variable": null,

				"after_variable": null,

				"before_seq_no": 0,

				"after_seq_no": 0

			}

		}

	},

		"queries": [

			"INSERT INTO ja_2_run_job_variable_table (inner_job_id, inner_jobnet_id, before_variable, before_seq_no) VALUES (1428, 1500000000000000033, '{\"JOBNET_ID\":1234,\"USER_NAME\":\"admin\",\"JOBNET_NAME\":\"SampleJobnet\",\"MANAGEMENT_ID\":1500000000000000006,\"JOBNET_BOOT_TIME\":\"20250520134658\",\"JOBNET_SCHEDULED_TIME\":\"20250519120000\"}', 20250601171106)",

			"select status from ja_run_job_table where inner_job_id = 1428 for update",

			"update ja_run_job_table set status = 1, start_time = 0, end_time = 0 where inner_job_id = 1428"

		],

		"transfer": {

			"files": [

			{

				"source": "/var/lib/jobarranger/server/iconexecmanager/in/1500000000000000033_1428_20250601171106.json",

				"destination": "/tmp"

			}

			],

			"uds": {

			"socket_path": ""

			}

		}

	}`

	TestFcopyRunEventStr string = `
	{
		"event": {
			"name": "icon_exec_run",
			"unique_key": "agentless_icon_client_1750128515335531784"
		},
		"next_process": {
			"name": "iconexeccutionmanager",
			"data": {
			"transaction_file_id": "1500000000000000033_1428_20250601171106",
			"exec_process_data": {
				"run_job_data": {
					"inner_job_id": 1428,
					"inner_jobnet_id": 1500000000000000033,
					"inner_jobnet_main_id": 1500000000000000033,
					"job_type": 14
				},
				"run_jobnet_data": {
					"inner_jobnet_id": 1234,
					"inner_jobnet_main_id": 1500000000000000033,
					"inner_job_id": 1428,
					"jobnet_id": ""
				}
			}
			}
		},
		"queries": null,
		"transfer": {
			"files": [
				{
					"source": "/var/lib/jobarranger/server/iconexecmanager/in/150000000000000020_123_20250617091835.json",
					"destination": "/var/lib/jobarranger/server/150000000000000020_123_20250617091835.json"
				}
			],
			"uds": {
			"socket_path": "iconexeccutionmanager.sock"
			}
		}
	}`

	TestFcopyEndEventStr string = `
	{
		"event": {
			"name": "icon_exec_end",
			"unique_key": "client_helper_1752738279660806925"
		},
		"next_process": {
			"name": "iconexecmanager",
			"data": {
			"transaction_file_id": "1500000000000000033_1428_20250601171106",
			"exec_process_data": {
				"run_job_data": {
					"inner_job_id": 1428,
					"inner_jobnet_id": 1500000000000000033,
					"inner_jobnet_main_id": 1500000000000000033,
					"job_type": 14
				},
				"run_jobnet_data": {
					"inner_jobnet_id": 1234,
					"inner_jobnet_main_id": 1500000000000000033,
					"inner_job_id": 1428,
					"jobnet_id": ""
				}
			}
		}
		},
		"queries": null,
		"transfer": {
			"files": [
			{
				"source": "/var/lib/jobarranger/server/iconexecmanager/in/1500000000000000033_1428_20250717141439.json",
				"destination": ""
			}
			],
			"uds": {
			"socket_path": ""
			}
		}
	}
	`

	TestFwaitReadyEventStr string = `
	{
		"event": {

			"name": "icon_ready",

			"unique_key": ""

		},

		"next_process": {

			"name": "icon_execution_manager",

			"data": {

			"run_job_data": {

				"inner_job_id": 1428,

				"inner_jobnet_id": 0,

				"inner_jobnet_main_id": 1500000000000000033,

				"inner_job_id_fs_link": 0,

				"created_date": 0,

				"invo_flag": 0,

				"job_type": 15,

				"data": {
					"host_flag": 1,
					"host_ip": "192.168.1.30",
					"host_port": 22,
					"fwait_mode_flag": 0,
					"file_delete_flag": 1,
					"file_wait_time": 300,
					"jaz1_support_flag": 1,
					"host_name": "wait-server",
					"file_name": "ready.signal"
				},

				"test_flag": 0,

				"method_flag": 0,

				"force_flag": 0,

				"timeout_flag": 0,

				"status": 0,

				"boot_count": 0,

				"end_count": 0,

				"start_time": 0,

				"end_time": 0,

				"point_x": 0,

				"point_y": 0,

				"job_id": "",

				"job_name": "",

				"continue_flag": 0,

				"run_user": "",

				"run_user_password": ""

			},

			"RunJobVariableData": {

				"inner_job_id": 0,

				"inner_jobnet_id": 0,

				"before_variable": null,

				"after_variable": null,

				"before_seq_no": 0,

				"after_seq_no": 0

			}

		}

	},

		"queries": [

			"INSERT INTO ja_2_run_job_variable_table (inner_job_id, inner_jobnet_id, before_variable, before_seq_no) VALUES (1428, 1500000000000000033, '{\"JOBNET_ID\":1234,\"USER_NAME\":\"admin\",\"JOBNET_NAME\":\"SampleJobnet\",\"MANAGEMENT_ID\":1500000000000000006,\"JOBNET_BOOT_TIME\":\"20250520134658\",\"JOBNET_SCHEDULED_TIME\":\"20250519120000\"}', 20250601171106)",

			"select status from ja_run_job_table where inner_job_id = 1428 for update",

			"update ja_run_job_table set status = 1, start_time = 0, end_time = 0 where inner_job_id = 1428"

		],

		"transfer": {

			"files": [

			{

				"source": "/var/lib/jobarranger/server/iconexecmanager/in/1500000000000000033_1428_20250601171106.json",

				"destination": "/tmp"

			}

			],

			"uds": {

			"socket_path": ""

			}

		}

	}`

	TestFwaitAbortEventStr string = `
	{
		"event": {

			"name": "icon_ready",

			"unique_key": ""

		},

		"next_process": {

			"name": "icon_execution_manager",

			"data": {

			"run_job_data": {

				"inner_job_id": 1428,

				"inner_jobnet_id": 0,

				"inner_jobnet_main_id": 1500000000000000033,

				"inner_job_id_fs_link": 0,

				"created_date": 0,

				"invo_flag": 0,

				"job_type": 15,

				"data": {
					"host_flag": 1,
					"host_ip": "192.168.1.30",
					"host_port": 22,
					"fwait_mode_flag": 0,
					"file_delete_flag": 1,
					"file_wait_time": 300,
					"jaz1_support_flag": 1,
					"host_name": "wait-server",
					"file_name": "ready.signal"
				},

				"test_flag": 0,

				"method_flag": 0,

				"force_flag": 0,

				"timeout_flag": 0,

				"status": 0,

				"boot_count": 0,

				"end_count": 0,

				"start_time": 0,

				"end_time": 0,

				"point_x": 0,

				"point_y": 0,

				"job_id": "",

				"job_name": "",

				"continue_flag": 0,

				"run_user": "",

				"run_user_password": ""

			},

			"RunJobVariableData": {

				"inner_job_id": 0,

				"inner_jobnet_id": 0,

				"before_variable": null,

				"after_variable": null,

				"before_seq_no": 0,

				"after_seq_no": 0

			}

		}

	},

		"queries": [

			"INSERT INTO ja_2_run_job_variable_table (inner_job_id, inner_jobnet_id, before_variable, before_seq_no) VALUES (1428, 1500000000000000033, '{\"JOBNET_ID\":1234,\"USER_NAME\":\"admin\",\"JOBNET_NAME\":\"SampleJobnet\",\"MANAGEMENT_ID\":1500000000000000006,\"JOBNET_BOOT_TIME\":\"20250520134658\",\"JOBNET_SCHEDULED_TIME\":\"20250519120000\"}', 20250601171106)",

			"select status from ja_run_job_table where inner_job_id = 1428 for update",

			"update ja_run_job_table set status = 1, start_time = 0, end_time = 0 where inner_job_id = 1428"

		],

		"transfer": {

			"files": [

			{

				"source": "/var/lib/jobarranger/server/iconexecmanager/in/1500000000000000033_1428_20250601171106.json",

				"destination": "/tmp"

			}

			],

			"uds": {

			"socket_path": ""

			}

		}

	}`

	TestFwaitRunEventStr string = `
	{
		"event": {
			"name": "icon_exec_run",
			"unique_key": "agentless_icon_client_1750128515335531784"
		},
		"next_process": {
			"name": "iconexeccutionmanager",
			"data": {
				"transaction_file_id": "1500000000000000033_1428_20250601171106",
				"exec_process_data": {
					"run_job_data": {
						"inner_job_id": 1428,
						"inner_jobnet_id": 1500000000000000033,
						"inner_jobnet_main_id": 1500000000000000033,
						"job_type": 15
					},
					"run_jobnet_data": {
						"inner_jobnet_id": 1234,
						"inner_jobnet_main_id": 1500000000000000033,
						"inner_job_id": 1428,
						"jobnet_id": ""
					}
				}
			}
		},
		"queries": null,
		"transfer": {
			"files": [
				{
					"source": "/var/lib/jobarranger/server/iconexecmanager/in/150000000000000020_123_20250617091835.json",
					"destination": "/var/lib/jobarranger/server/150000000000000020_123_20250617091835.json"
				}
			],
			"uds": {
			"socket_path": "iconexeccutionmanager.sock"
			}
		}
	}`

	TestFwaitEndEventStr string = `
	{
		"event": {
			"name": "icon_exec_end",
			"unique_key": "client_helper_1752738456758170855"
		},
		"next_process": {
			"name": "iconexecmanager",
			"data": {
			"transaction_file_id": "1500000000000000033_1428_20250601171106",
			"exec_process_data": {
				"run_job_data": {
					"inner_job_id": 1428,
					"inner_jobnet_id": 1500000000000000033,
					"inner_jobnet_main_id": 1500000000000000033,
					"job_type": 15
				},
				"run_jobnet_data": {
					"inner_jobnet_id": 1234,
					"inner_jobnet_main_id": 1500000000000000033,
					"inner_job_id": 1428,
					"jobnet_id": ""
				}
			}
		}
		},
		"queries": null,
		"transfer": {
			"files": [
			{
				"source": "/var/lib/jobarranger/server/iconexecmanager/in/1500000000000000033_1428_20250717141736.json",
				"destination": ""
			}
			],
			"uds": {
			"socket_path": ""
			}
		}
	}`

	TestRebootReadyEventStr = `
	{
		"event": {
			"name": "icon_ready",
			"unique_key": "flowmanager_20250711161807"
		},
		"next_process": {
			"name": "iconexecmanager",
			"data": {
			"run_job_data": {
				"inner_job_id": 298,
				"inner_jobnet_id": 1500000000000000073,
				"inner_jobnet_main_id": 1500000000000000073,
				"created_date": 1752218275,
				"invo_flag": 0,
				"job_type": 16,
				"data": {
					"host_flag": 1,
					"host_ip": "192.168.1.40",
					"host_port": 22,
					"reboot_mode_flag": 0,
					"reboot_wait_time": 120,
					"jaz1_support_flag": 1,
					"host_name": "reboot-server",
					"timeout": "5m"
				},
				"test_flag": 0,
				"method_flag": 0,
				"force_flag": 0,
				"timeout_flag": 0,
				"status": 1,
				"boot_count": 1,
				"end_count": 0,
				"start_time": 0,
				"end_time": 0,
				"point_x": 480,
				"point_y": 180,
				"job_id": "JOB-1",
				"jobnet_id": "",
				"job_name": "",
				"continue_flag": 0,
				"run_user": "",
				"run_user_password": "",
				"client_pid": 0,
				"stop_code": 0,
				"command_id": ""
			},
			"run_job_variable_data": {
				"inner_job_id": 298,
				"inner_jobnet_id": 1500000000000000073,
				"before_variable": {
				"inner_jobnet_main_id": 1500000000000000073,
				"jobnet_id": "JOBNET_1",
				"job_id": "JOB-1",
				"job_name": "",
				"full_job_id": "JOBNET_1/JOB-1",
				"jobnet_boot_time": "",
				"jobnet_scheduled_time": "",
				"current_time": "20250711161800"
				},
				"after_variable": null,
				"seq_no": 0
			},
			"RunValueJobConData": null,
			"run_value_job_data": null,
			"session_data": {
				"session_id": "",
				"inner_jobnet_main_id": 0,
				"inner_job_id": 0,
				"operation_flag": 0,
				"status": 0,
				"force_stop": 0,
				"pid": 0,
				"ssh_client_socket": ""
			},
			"run_flow_data": {
				"inner_flow_id": 0,
				"inner_jobnet_id": 0,
				"start_inner_job_id": 0,
				"end_inner_job_id": 0,
				"flow_type": 0,
				"flow_width": 0,
				"flow_style": ""
			},
			"job_result": {
				"jobid": "",
				"type": "",
				"method": 0,
				"script": "",
				"cur_unique_id": "",
				"pre_unique_id": "",
				"argument": null,
				"env": null,
				"run_user": null,
				"run_user_password": null,
				"jobstatus": 0,
				"pid": 0,
				"message": "",
				"hostname": "",
				"result": 0,
				"std_out": "",
				"std_err": "",
				"return_code": 0,
				"signal": 0
			},
			"parameter_data": {
				"parameter_name": "",
				"value": "",
				"created_date": 0
			},
			"jobnet_start_time": 0,
			"info_result_data": {
				"status": 0,
				"cal_result": false
			}
			}
		},
		"queries": [
			"DELETE FROM ja_2_run_job_variable_table WHERE inner_job_id = 298",
			"INSERT INTO ja_2_run_job_variable_table (inner_job_id, inner_jobnet_id, before_variable) VALUES (298, 1500000000000000073, '{\"inner_jobnet_main_id\":1500000000000000073,\"jobnet_id\":\"JOBNET_1\",\"job_id\":\"JOB-1\",\"job_name\":\"\",\"full_job_id\":\"JOBNET_1/JOB-1\",\"jobnet_boot_time\":\"\",\"jobnet_scheduled_time\":\"\",\"current_time\":\"20250711161800\"}')",
			"DELETE FROM ja_2_run_job_variable_table WHERE inner_job_id = 298",
			"INSERT INTO ja_2_run_job_variable_table (inner_job_id, inner_jobnet_id, before_variable) VALUES (298, 1500000000000000073, '{\"inner_jobnet_main_id\":1500000000000000073,\"jobnet_id\":\"JOBNET_1\",\"job_id\":\"JOB-1\",\"job_name\":\"\",\"full_job_id\":\"JOBNET_1/JOB-1\",\"jobnet_boot_time\":\"\",\"jobnet_scheduled_time\":\"\",\"current_time\":\"20250711161800\"}')",
			"select status from ja_2_run_job_table where inner_job_id = 298 for update",
			"update ja_2_run_job_table set status = 1, start_time = 0, end_time = 0 where inner_job_id = 298"
		],
		"transfer": {
			"files": [
			{
				"source": "/var/lib/jobarranger/server/dbsyncermanager/in/298_JOBNET_1_298_20250711161800.json",
				"destination": "/var/lib/jobarranger/server/iconexecmanager/in/298_JOBNET_1_298_20250711161800.json"
			}
			],
			"uds": {
			"socket_path": "/usr/local/bin/jobarranger/icon_exec_manager.sock"
			}
		}
	}
	`

	TestRebootAbortEventStr = `
	{
		"event": {
			"name": "icon_ready",
			"unique_key": "flowmanager_20250711161807"
		},
		"next_process": {
			"name": "iconexecmanager",
			"data": {
			"run_job_data": {
				"inner_job_id": 298,
				"inner_jobnet_id": 1500000000000000073,
				"inner_jobnet_main_id": 1500000000000000073,
				"created_date": 1752218275,
				"invo_flag": 0,
				"job_type": 16,
				"data": {
					"host_flag": 1,
					"host_ip": "192.168.1.40",
					"host_port": 22,
					"reboot_mode_flag": 0,
					"reboot_wait_time": 120,
					"jaz1_support_flag": 1,
					"host_name": "reboot-server",
					"timeout": "5m"
				},
				"test_flag": 0,
				"method_flag": 3,
				"force_flag": 0,
				"timeout_flag": 0,
				"status": 1,
				"boot_count": 1,
				"end_count": 0,
				"start_time": 0,
				"end_time": 0,
				"point_x": 480,
				"point_y": 180,
				"job_id": "JOB-1",
				"jobnet_id": "",
				"job_name": "",
				"continue_flag": 0,
				"run_user": "",
				"run_user_password": "",
				"client_pid": 0,
				"stop_code": 0,
				"command_id": ""
			},
			"run_job_variable_data": {
				"inner_job_id": 298,
				"inner_jobnet_id": 1500000000000000073,
				"before_variable": {
				"inner_jobnet_main_id": 1500000000000000073,
				"jobnet_id": "JOBNET_1",
				"job_id": "JOB-1",
				"job_name": "",
				"full_job_id": "JOBNET_1/JOB-1",
				"jobnet_boot_time": "",
				"jobnet_scheduled_time": "",
				"current_time": "20250711161800"
				},
				"after_variable": null,
				"seq_no": 0
			},
			"RunValueJobConData": null,
			"run_value_job_data": null,
			"session_data": {
				"session_id": "",
				"inner_jobnet_main_id": 0,
				"inner_job_id": 0,
				"operation_flag": 0,
				"status": 0,
				"force_stop": 0,
				"pid": 0,
				"ssh_client_socket": ""
			},
			"run_flow_data": {
				"inner_flow_id": 0,
				"inner_jobnet_id": 0,
				"start_inner_job_id": 0,
				"end_inner_job_id": 0,
				"flow_type": 0,
				"flow_width": 0,
				"flow_style": ""
			},
			"job_result": {
				"jobid": "",
				"type": "",
				"method": 0,
				"script": "",
				"cur_unique_id": "",
				"pre_unique_id": "",
				"argument": null,
				"env": null,
				"run_user": null,
				"run_user_password": null,
				"jobstatus": 0,
				"pid": 0,
				"message": "",
				"hostname": "",
				"result": 0,
				"std_out": "",
				"std_err": "",
				"return_code": 0,
				"signal": 0
			},
			"parameter_data": {
				"parameter_name": "",
				"value": "",
				"created_date": 0
			},
			"jobnet_start_time": 0,
			"info_result_data": {
				"status": 0,
				"cal_result": false
			}
			}
		},
		"queries": [
			"DELETE FROM ja_2_run_job_variable_table WHERE inner_job_id = 298",
			"INSERT INTO ja_2_run_job_variable_table (inner_job_id, inner_jobnet_id, before_variable) VALUES (298, 1500000000000000073, '{\"inner_jobnet_main_id\":1500000000000000073,\"jobnet_id\":\"JOBNET_1\",\"job_id\":\"JOB-1\",\"job_name\":\"\",\"full_job_id\":\"JOBNET_1/JOB-1\",\"jobnet_boot_time\":\"\",\"jobnet_scheduled_time\":\"\",\"current_time\":\"20250711161800\"}')",
			"DELETE FROM ja_2_run_job_variable_table WHERE inner_job_id = 298",
			"INSERT INTO ja_2_run_job_variable_table (inner_job_id, inner_jobnet_id, before_variable) VALUES (298, 1500000000000000073, '{\"inner_jobnet_main_id\":1500000000000000073,\"jobnet_id\":\"JOBNET_1\",\"job_id\":\"JOB-1\",\"job_name\":\"\",\"full_job_id\":\"JOBNET_1/JOB-1\",\"jobnet_boot_time\":\"\",\"jobnet_scheduled_time\":\"\",\"current_time\":\"20250711161800\"}')",
			"select status from ja_2_run_job_table where inner_job_id = 298 for update",
			"update ja_2_run_job_table set status = 1, start_time = 0, end_time = 0 where inner_job_id = 298"
		],
		"transfer": {
			"files": [
			{
				"source": "/var/lib/jobarranger/server/dbsyncermanager/in/298_JOBNET_1_298_20250711161800.json",
				"destination": "/var/lib/jobarranger/server/iconexecmanager/in/298_JOBNET_1_298_20250711161800.json"
			}
			],
			"uds": {
			"socket_path": "/usr/local/bin/jobarranger/icon_exec_manager.sock"
			}
		}
	}
	`

	TestRebootRunEventStr string = `
	{
		"event": {
			"name": "icon_exec_run",
			"unique_key": "job_icon_client_1750128515335531784"
		},
		"next_process": {
			"name": "iconexeccutionmanager",
			"data": {
				"transaction_file_id": "298_JOBNET_1_298_20250711161800",
				"exec_process_data": {
				"run_job_data": {
					"inner_job_id": 1428,
					"inner_jobnet_id": 1500000000000000033,
					"inner_jobnet_main_id": 1500000000000000033,
					"job_type": 16
				},
				"run_jobnet_data": {
					"inner_jobnet_id": 1234,
					"inner_jobnet_main_id": 1500000000000000033,
					"inner_job_id": 1428,
					"jobnet_id": ""
				}
			}
			}
		},
		"queries": null,
		"transfer": {
			"files": [
				{
					"source": "/var/lib/jobarranger/server/iconexecmanager/in/150000000000000020_123_20250617091835.json",
					"destination": "/var/lib/jobarranger/server/150000000000000020_123_20250617091835.json"
				}
			],
			"uds": {
			"socket_path": "iconexeccutionmanager.sock"
			}
		}
	}`

	TestRebootEndEventStr string = `
	{
		"event": {
			"name": "icon_exec_end",
			"unique_key": "client_helper_1752738456758170855"
		},
		"next_process": {
			"name": "iconexecmanager",
			"data": {
			"transaction_file_id": "298_JOBNET_1_298_20250711161800",
			"exec_process_data": {
				"run_job_data": {
					"inner_job_id": 1428,
					"inner_jobnet_id": 1500000000000000033,
					"inner_jobnet_main_id": 1500000000000000033,
					"job_type": 16
				},
				"run_jobnet_data": {
					"inner_jobnet_id": 1234,
					"inner_jobnet_main_id": 1500000000000000033,
					"inner_job_id": 1428,
					"jobnet_id": ""
				}
			}
		}
		},
		"queries": null,
		"transfer": {
			"files": [
			{
				"source": "/var/lib/jobarranger/server/iconexecmanager/in/1500000000000000033_1428_20250717141736.json",
				"destination": ""
			}
			],
			"uds": {
			"socket_path": ""
			}
		}
	}`

	TestZbxLinkReadyEventStr = `
	{
		"event": {
			"name": "icon_ready",
			"unique_key": "flowmanager_20250711161807"
		},
		"next_process": {
			"name": "iconexecmanager",
			"data": {
			"run_job_data": {
				"inner_job_id": 298,
				"inner_jobnet_id": 1500000000000000073,
				"inner_jobnet_main_id": 1500000000000000073,
				"created_date": 1752218275,
				"invo_flag": 0,
				"job_type": 19,
				"data": {
					"test_flag": 1,
					"link_target": 2,
					"link_operation": 0,
					"groupid": "101",
					"hostid": "202",
					"itemid": "303",
					"triggerid": "404",
					"zbx_last_status": 0,
					"zbx_lastest_data": "75%",
					"zbx_data_type": 12,
					"execution_user_name": "zabbix_user",
					"inner_job_id": 123456789
				},
				"test_flag": 0,
				"method_flag": 0,
				"force_flag": 0,
				"timeout_flag": 0,
				"status": 1,
				"boot_count": 1,
				"end_count": 0,
				"start_time": 0,
				"end_time": 0,
				"point_x": 480,
				"point_y": 180,
				"job_id": "JOB-1",
				"jobnet_id": "",
				"job_name": "",
				"continue_flag": 0,
				"run_user": "",
				"run_user_password": "",
				"client_pid": 0,
				"stop_code": 0,
				"command_id": ""
			},
			"run_job_variable_data": {
				"inner_job_id": 298,
				"inner_jobnet_id": 1500000000000000073,
				"before_variable": {
				"inner_jobnet_main_id": 1500000000000000073,
				"jobnet_id": "JOBNET_1",
				"job_id": "JOB-1",
				"job_name": "",
				"full_job_id": "JOBNET_1/JOB-1",
				"jobnet_boot_time": "",
				"jobnet_scheduled_time": "",
				"current_time": "20250711161800"
				},
				"after_variable": null,
				"seq_no": 0
			},
			"RunValueJobConData": null,
			"run_value_job_data": null,
			"session_data": {
				"session_id": "",
				"inner_jobnet_main_id": 0,
				"inner_job_id": 0,
				"operation_flag": 0,
				"status": 0,
				"force_stop": 0,
				"pid": 0,
				"ssh_client_socket": ""
			},
			"run_flow_data": {
				"inner_flow_id": 0,
				"inner_jobnet_id": 0,
				"start_inner_job_id": 0,
				"end_inner_job_id": 0,
				"flow_type": 0,
				"flow_width": 0,
				"flow_style": ""
			},
			"job_result": {
				"jobid": "",
				"type": "",
				"method": 0,
				"script": "",
				"cur_unique_id": "",
				"pre_unique_id": "",
				"argument": null,
				"env": null,
				"run_user": null,
				"run_user_password": null,
				"jobstatus": 0,
				"pid": 0,
				"message": "",
				"hostname": "",
				"result": 0,
				"std_out": "",
				"std_err": "",
				"return_code": 0,
				"signal": 0
			},
			"parameter_data": {
				"parameter_name": "",
				"value": "",
				"created_date": 0
			},
			"jobnet_start_time": 0,
			"info_result_data": {
				"status": 0,
				"cal_result": false
			}
			}
		},
		"queries": [
			"DELETE FROM ja_2_run_job_variable_table WHERE inner_job_id = 298",
			"INSERT INTO ja_2_run_job_variable_table (inner_job_id, inner_jobnet_id, before_variable) VALUES (298, 1500000000000000073, '{\"inner_jobnet_main_id\":1500000000000000073,\"jobnet_id\":\"JOBNET_1\",\"job_id\":\"JOB-1\",\"job_name\":\"\",\"full_job_id\":\"JOBNET_1/JOB-1\",\"jobnet_boot_time\":\"\",\"jobnet_scheduled_time\":\"\",\"current_time\":\"20250711161800\"}')",
			"DELETE FROM ja_2_run_job_variable_table WHERE inner_job_id = 298",
			"INSERT INTO ja_2_run_job_variable_table (inner_job_id, inner_jobnet_id, before_variable) VALUES (298, 1500000000000000073, '{\"inner_jobnet_main_id\":1500000000000000073,\"jobnet_id\":\"JOBNET_1\",\"job_id\":\"JOB-1\",\"job_name\":\"\",\"full_job_id\":\"JOBNET_1/JOB-1\",\"jobnet_boot_time\":\"\",\"jobnet_scheduled_time\":\"\",\"current_time\":\"20250711161800\"}')",
			"select status from ja_2_run_job_table where inner_job_id = 298 for update",
			"update ja_2_run_job_table set status = 1, start_time = 0, end_time = 0 where inner_job_id = 298"
		],
		"transfer": {
			"files": [
			{
				"source": "/var/lib/jobarranger/server/dbsyncermanager/in/298_JOBNET_1_298_20250711161800.json",
				"destination": "/var/lib/jobarranger/server/iconexecmanager/in/298_JOBNET_1_298_20250711161800.json"
			}
			],
			"uds": {
			"socket_path": "/usr/local/bin/jobarranger/icon_exec_manager.sock"
			}
		}
	}
	`

	TestZbxLinkRunEventStr string = `
	{
		"event": {
			"name": "icon_exec_run",
			"unique_key": "job_icon_client_1750128515335531784"
		},
		"next_process": {
			"name": "iconexeccutionmanager",
			"data": {
				"transaction_file_id": "298_JOBNET_1_298_20250711161800",
				"exec_process_data": {
					"run_job_data": {
						"inner_job_id": 1428,
						"inner_jobnet_id": 1500000000000000033,
						"inner_jobnet_main_id": 1500000000000000033,
						"job_type": 19
					},
					"run_jobnet_data": {
						"inner_jobnet_id": 1234,
						"inner_jobnet_main_id": 1500000000000000033,
						"inner_job_id": 1428,
						"jobnet_id": ""
					}
				}
			}
		},
		"queries": null,
		"transfer": {
			"files": [
				{
					"source": "/var/lib/jobarranger/server/iconexecmanager/in/150000000000000020_123_20250617091835.json",
					"destination": "/var/lib/jobarranger/server/150000000000000020_123_20250617091835.json"
				}
			],
			"uds": {
			"socket_path": "iconexeccutionmanager.sock"
			}
		}
	}`

	TestZbxLinkEndEventStr string = `
	{
		"event": {
			"name": "icon_exec_end",
			"unique_key": "client_helper_1752824942577371724"
		},
		"next_process": {
			"name": "iconexecmanager",
			"data": {
			"transaction_file_id": "298_JOBNET_1_298_20250711161800",
			"exec_process_data": {
				"run_job_data": {
					"inner_job_id": 1428,
					"inner_jobnet_id": 1500000000000000033,
					"inner_jobnet_main_id": 1500000000000000033,
					"job_type": 19
				},
				"run_jobnet_data": {
					"inner_jobnet_id": 1234,
					"inner_jobnet_main_id": 1500000000000000033,
					"inner_job_id": 1428,
					"jobnet_id": ""
				}
			}
		}
		},
		"queries": null,
		"transfer": {
			"files": [
			{
				"source": "/var/lib/jobarranger/server/iconexecmanager/in/1500000000000000073_298_20250718141902.json",
				"destination": ""
			}
			],
			"uds": {
			"socket_path": ""
			}
		}
	}
	`

	TestTaskReadyEventStr = `
	{
		"event": {
			"name": "icon_ready",
			"unique_key": "flowmanager_20250711161807"
		},
		"next_process": {
			"name": "iconexecmanager",
			"data": {
			"run_job_data": {
				"inner_job_id": 298,
				"inner_jobnet_id": 1500000000000000073,
				"inner_jobnet_main_id": 1500000000000000073,
				"created_date": 1752218275,
				"invo_flag": 0,
				"job_type": 11,
				"data": {
					"submit_inner_jobnet_id": 123,
					"submit_jobnet_id": "JOBNET-1"
				},
				"test_flag": 0,
				"method_flag": 0,
				"force_flag": 0,
				"timeout_flag": 0,
				"status": 1,
				"boot_count": 1,
				"end_count": 0,
				"start_time": 0,
				"end_time": 0,
				"point_x": 480,
				"point_y": 180,
				"job_id": "JOB-1",
				"jobnet_id": "",
				"job_name": "",
				"continue_flag": 0,
				"run_user": "",
				"run_user_password": "",
				"client_pid": 0,
				"stop_code": 0,
				"command_id": ""
			},
			"run_job_variable_data": {
				"inner_job_id": 298,
				"inner_jobnet_id": 1500000000000000073,
				"before_variable": {
				"inner_jobnet_main_id": 1500000000000000073,
				"jobnet_id": "JOBNET_1",
				"job_id": "JOB-1",
				"job_name": "",
				"full_job_id": "JOBNET_1/JOB-1",
				"jobnet_boot_time": "",
				"jobnet_scheduled_time": "",
				"current_time": "20250711161800"
				},
				"after_variable": null,
				"seq_no": 0
			},
			"RunValueJobConData": null,
			"run_value_job_data": null,
			"session_data": {
				"session_id": "",
				"inner_jobnet_main_id": 0,
				"inner_job_id": 0,
				"operation_flag": 0,
				"status": 0,
				"force_stop": 0,
				"pid": 0,
				"ssh_client_socket": ""
			},
			"run_flow_data": {
				"inner_flow_id": 0,
				"inner_jobnet_id": 0,
				"start_inner_job_id": 0,
				"end_inner_job_id": 0,
				"flow_type": 0,
				"flow_width": 0,
				"flow_style": ""
			},
			"job_result": {
				"jobid": "",
				"type": "",
				"method": 0,
				"script": "",
				"cur_unique_id": "",
				"pre_unique_id": "",
				"argument": null,
				"env": null,
				"run_user": null,
				"run_user_password": null,
				"jobstatus": 0,
				"pid": 0,
				"message": "",
				"hostname": "",
				"result": 0,
				"std_out": "",
				"std_err": "",
				"return_code": 0,
				"signal": 0
			},
			"parameter_data": {
				"parameter_name": "",
				"value": "",
				"created_date": 0
			},
			"jobnet_start_time": 0,
			"info_result_data": {
				"status": 0,
				"cal_result": false
			}
			}
		},
		"queries": [
			"DELETE FROM ja_2_run_job_variable_table WHERE inner_job_id = 298",
			"INSERT INTO ja_2_run_job_variable_table (inner_job_id, inner_jobnet_id, before_variable) VALUES (298, 1500000000000000073, '{\"inner_jobnet_main_id\":1500000000000000073,\"jobnet_id\":\"JOBNET_1\",\"job_id\":\"JOB-1\",\"job_name\":\"\",\"full_job_id\":\"JOBNET_1/JOB-1\",\"jobnet_boot_time\":\"\",\"jobnet_scheduled_time\":\"\",\"current_time\":\"20250711161800\"}')",
			"DELETE FROM ja_2_run_job_variable_table WHERE inner_job_id = 298",
			"INSERT INTO ja_2_run_job_variable_table (inner_job_id, inner_jobnet_id, before_variable) VALUES (298, 1500000000000000073, '{\"inner_jobnet_main_id\":1500000000000000073,\"jobnet_id\":\"JOBNET_1\",\"job_id\":\"JOB-1\",\"job_name\":\"\",\"full_job_id\":\"JOBNET_1/JOB-1\",\"jobnet_boot_time\":\"\",\"jobnet_scheduled_time\":\"\",\"current_time\":\"20250711161800\"}')",
			"select status from ja_2_run_job_table where inner_job_id = 298 for update",
			"update ja_2_run_job_table set status = 1, start_time = 0, end_time = 0 where inner_job_id = 298"
		],
		"transfer": {
			"files": [
			{
				"source": "/var/lib/jobarranger/server/dbsyncermanager/in/298_JOBNET_1_298_20250711161800.json",
				"destination": "/var/lib/jobarranger/server/iconexecmanager/in/298_JOBNET_1_298_20250711161800.json"
			}
			],
			"uds": {
			"socket_path": "/usr/local/bin/jobarranger/icon_exec_manager.sock"
			}
		}
	}
	`

	TestTaskRunEventStr string = `
	{
		"event": {
			"name": "icon_exec_run",
			"unique_key": "task_icon_client_1750128515335531784"
		},
		"next_process": {
			"name": "iconexeccutionmanager",
			"data": {
				"transaction_file_id": "298_JOBNET_1_298_20250711161800",
				"exec_process_data": {
					"run_job_data": {
						"inner_job_id": 1428,
						"inner_jobnet_id": 1500000000000000033,
						"inner_jobnet_main_id": 1500000000000000033,
						"job_type": 11
					},
					"run_jobnet_data": {
						"inner_jobnet_id": 1234,
						"inner_jobnet_main_id": 1500000000000000033,
						"inner_job_id": 1428,
						"jobnet_id": ""
					}
				}
			}
		},
		"queries": null,
		"transfer": {
			"files": [
				{
					"source": "/var/lib/jobarranger/server/iconexecmanager/in/150000000000000020_123_20250617091835.json",
					"destination": "/var/lib/jobarranger/server/150000000000000020_123_20250617091835.json"
				}
			],
			"uds": {
			"socket_path": "iconexeccutionmanager.sock"
			}
		}
	}`

	TestTaskEndEventStr string = `
	{
		"event": {
			"name": "icon_exec_end",
			"unique_key": "client_helper_1753157782489836989"
		},
		"next_process": {
			"name": "iconexecmanager",
			"data": {
			"transaction_file_id": "298_JOBNET_1_298_20250711161800",
			"exec_process_data": {
				"run_job_data": {
					"inner_job_id": 1428,
					"inner_jobnet_id": 1500000000000000033,
					"inner_jobnet_main_id": 1500000000000000033,
					"job_type": 11
				},
				"run_jobnet_data": {
					"inner_jobnet_id": 1234,
					"inner_jobnet_main_id": 1500000000000000033,
					"inner_job_id": 1428,
					"jobnet_id": ""
				}
			}
		}
		},
		"queries": null,
		"transfer": {
			"files": [
			{
				"source": "/var/lib/jobarranger/server/iconexecmanager/in/1500000000000000073_298_20250722104622.json",
				"destination": ""
			}
			],
			"uds": {
			"socket_path": ""
			}
		}
	}
	`

	TestRelReadyEventStr = `
	{
		"event": {
			"name": "icon_ready",
			"unique_key": "flowmanager_20250711161807"
		},
		"next_process": {
			"name": "iconexecmanager",
			"data": {
			"run_job_data": {
				"inner_job_id": 298,
				"inner_jobnet_id": 1500000000000000073,
				"inner_jobnet_main_id": 1500000000000000073,
				"created_date": 1752218275,
				"invo_flag": 0,
				"job_type": 17,
				"data": {
					"release_job_id": "",
					"release_inner_job_id": 123
				},
				"test_flag": 0,
				"method_flag": 0,
				"force_flag": 0,
				"timeout_flag": 0,
				"status": 1,
				"boot_count": 1,
				"end_count": 0,
				"start_time": 0,
				"end_time": 0,
				"point_x": 480,
				"point_y": 180,
				"job_id": "JOB-1",
				"jobnet_id": "",
				"job_name": "",
				"continue_flag": 0,
				"run_user": "",
				"run_user_password": "",
				"client_pid": 0,
				"stop_code": 0,
				"command_id": ""
			},
			"run_job_variable_data": {
				"inner_job_id": 298,
				"inner_jobnet_id": 1500000000000000073,
				"before_variable": {
				"inner_jobnet_main_id": 1500000000000000073,
				"jobnet_id": "JOBNET_1",
				"job_id": "JOB-1",
				"job_name": "",
				"full_job_id": "JOBNET_1/JOB-1",
				"jobnet_boot_time": "",
				"jobnet_scheduled_time": "",
				"current_time": "20250711161800"
				},
				"after_variable": null,
				"seq_no": 0
			},
			"RunValueJobConData": null,
			"run_value_job_data": null,
			"session_data": {
				"session_id": "",
				"inner_jobnet_main_id": 0,
				"inner_job_id": 0,
				"operation_flag": 0,
				"status": 0,
				"force_stop": 0,
				"pid": 0,
				"ssh_client_socket": ""
			},
			"run_flow_data": {
				"inner_flow_id": 0,
				"inner_jobnet_id": 0,
				"start_inner_job_id": 0,
				"end_inner_job_id": 0,
				"flow_type": 0,
				"flow_width": 0,
				"flow_style": ""
			},
			"job_result": {
				"jobid": "",
				"type": "",
				"method": 0,
				"script": "",
				"cur_unique_id": "",
				"pre_unique_id": "",
				"argument": null,
				"env": null,
				"run_user": null,
				"run_user_password": null,
				"jobstatus": 0,
				"pid": 0,
				"message": "",
				"hostname": "",
				"result": 0,
				"std_out": "",
				"std_err": "",
				"return_code": 0,
				"signal": 0
			},
			"parameter_data": {
				"parameter_name": "",
				"value": "",
				"created_date": 0
			},
			"jobnet_start_time": 0,
			"info_result_data": {
				"status": 0,
				"cal_result": false
			}
			}
		},
		"queries": [
			"DELETE FROM ja_2_run_job_variable_table WHERE inner_job_id = 298",
			"INSERT INTO ja_2_run_job_variable_table (inner_job_id, inner_jobnet_id, before_variable) VALUES (298, 1500000000000000073, '{\"inner_jobnet_main_id\":1500000000000000073,\"jobnet_id\":\"JOBNET_1\",\"job_id\":\"JOB-1\",\"job_name\":\"\",\"full_job_id\":\"JOBNET_1/JOB-1\",\"jobnet_boot_time\":\"\",\"jobnet_scheduled_time\":\"\",\"current_time\":\"20250711161800\"}')",
			"DELETE FROM ja_2_run_job_variable_table WHERE inner_job_id = 298",
			"INSERT INTO ja_2_run_job_variable_table (inner_job_id, inner_jobnet_id, before_variable) VALUES (298, 1500000000000000073, '{\"inner_jobnet_main_id\":1500000000000000073,\"jobnet_id\":\"JOBNET_1\",\"job_id\":\"JOB-1\",\"job_name\":\"\",\"full_job_id\":\"JOBNET_1/JOB-1\",\"jobnet_boot_time\":\"\",\"jobnet_scheduled_time\":\"\",\"current_time\":\"20250711161800\"}')",
			"select status from ja_2_run_job_table where inner_job_id = 298 for update",
			"update ja_2_run_job_table set status = 1, start_time = 0, end_time = 0 where inner_job_id = 298"
		],
		"transfer": {
			"files": [
			{
				"source": "/var/lib/jobarranger/server/dbsyncermanager/in/298_JOBNET_1_298_20250711161800.json",
				"destination": "/var/lib/jobarranger/server/iconexecmanager/in/298_JOBNET_1_298_20250711161800.json"
			}
			],
			"uds": {
			"socket_path": "/usr/local/bin/jobarranger/icon_exec_manager.sock"
			}
		}
	}
	`

	TestRelRunEventStr string = `
	{
		"event": {
			"name": "icon_exec_run",
			"unique_key": "rel_icon_client_1750128515335531784"
		},
		"next_process": {
			"name": "iconexeccutionmanager",
			"data": {
				"transaction_file_id": "298_JOBNET_1_298_20250711161800",
				"exec_process_data": {
					"run_job_data": {
						"inner_job_id": 1428,
						"inner_jobnet_id": 1500000000000000033,
						"inner_jobnet_main_id": 1500000000000000033,
						"job_type": 17
					},
					"run_jobnet_data": {
						"inner_jobnet_id": 1234,
						"inner_jobnet_main_id": 1500000000000000033,
						"inner_job_id": 1428,
						"jobnet_id": ""
					}
				}
			}
		},
		"queries": null,
		"transfer": {
			"files": [
				{
					"source": "/var/lib/jobarranger/server/iconexecmanager/in/150000000000000020_123_20250617091835.json",
					"destination": "/var/lib/jobarranger/server/150000000000000020_123_20250617091835.json"
				}
			],
			"uds": {
			"socket_path": "iconexeccutionmanager.sock"
			}
		}
	}`

	TestRelEndEventStr string = `
	{
		"event": {
			"name": "icon_exec_end",
			"unique_key": "client_helper_1753170726818581673"
		},
		"next_process": {
			"name": "iconexecmanager",
			"data": {
			"transaction_file_id": "298_JOBNET_1_298_20250711161800",
			"exec_process_data": {
				"run_job_data": {
					"inner_job_id": 1428,
					"inner_jobnet_id": 1500000000000000033,
					"inner_jobnet_main_id": 1500000000000000033,
					"job_type": 17
				},
				"run_jobnet_data": {
					"inner_jobnet_id": 1234,
					"inner_jobnet_main_id": 1500000000000000033,
					"inner_job_id": 1428,
					"jobnet_id": ""
				}
			}
		}
		},
		"queries": null,
		"transfer": {
			"files": [
			{
				"source": "/var/lib/jobarranger/server/iconexecmanager/in/1500000000000000073_298_20250722142206.json",
				"destination": ""
			}
			],
			"uds": {
			"socket_path": ""
			}
		}
	}
	`

	TestValueReadyEventStr = `
	{
		"event": {
			"name": "icon_ready",
			"unique_key": "flowmanager_20250711161807"
		},
		"next_process": {
			"name": "iconexecmanager",
			"data": {
			"run_job_data": {
				"inner_job_id": 298,
				"inner_jobnet_id": 1500000000000000073,
				"inner_jobnet_main_id": 1500000000000000073,
				"created_date": 1752218275,
				"invo_flag": 0,
				"job_type": 3,
				"data": {
					"variables": {
						"ENV": "production",
						"REGION": "us-east-1",
						"VERSION": "v1.2.3",
						"DEBUG": "false"
					}
				},
				"test_flag": 0,
				"method_flag": 0,
				"force_flag": 0,
				"timeout_flag": 0,
				"status": 1,
				"boot_count": 1,
				"end_count": 0,
				"start_time": 0,
				"end_time": 0,
				"point_x": 480,
				"point_y": 180,
				"job_id": "JOB-1",
				"jobnet_id": "",
				"job_name": "",
				"continue_flag": 0,
				"run_user": "",
				"run_user_password": "",
				"client_pid": 0,
				"stop_code": 0,
				"command_id": ""
			},
			"run_job_variable_data": {
				"inner_job_id": 298,
				"inner_jobnet_id": 1500000000000000073,
				"before_variable": {
				"inner_jobnet_main_id": 1500000000000000073,
				"jobnet_id": "JOBNET_1",
				"job_id": "JOB-1",
				"job_name": "",
				"full_job_id": "JOBNET_1/JOB-1",
				"jobnet_boot_time": "",
				"jobnet_scheduled_time": "",
				"current_time": "20250711161800"
				},
				"after_variable": null,
				"seq_no": 0
			},
			"RunValueJobConData": null,
			"run_value_job_data": null,
			"session_data": {
				"session_id": "",
				"inner_jobnet_main_id": 0,
				"inner_job_id": 0,
				"operation_flag": 0,
				"status": 0,
				"force_stop": 0,
				"pid": 0,
				"ssh_client_socket": ""
			},
			"run_flow_data": {
				"inner_flow_id": 0,
				"inner_jobnet_id": 0,
				"start_inner_job_id": 0,
				"end_inner_job_id": 0,
				"flow_type": 0,
				"flow_width": 0,
				"flow_style": ""
			},
			"job_result": {
				"jobid": "",
				"type": "",
				"method": 0,
				"script": "",
				"cur_unique_id": "",
				"pre_unique_id": "",
				"argument": null,
				"env": null,
				"run_user": null,
				"run_user_password": null,
				"jobstatus": 0,
				"pid": 0,
				"message": "",
				"hostname": "",
				"result": 0,
				"std_out": "",
				"std_err": "",
				"return_code": 0,
				"signal": 0
			},
			"parameter_data": {
				"parameter_name": "",
				"value": "",
				"created_date": 0
			},
			"jobnet_start_time": 0,
			"info_result_data": {
				"status": 0,
				"cal_result": false
			}
			}
		},
		"queries": [
			"DELETE FROM ja_2_run_job_variable_table WHERE inner_job_id = 298",
			"INSERT INTO ja_2_run_job_variable_table (inner_job_id, inner_jobnet_id, before_variable) VALUES (298, 1500000000000000073, '{\"inner_jobnet_main_id\":1500000000000000073,\"jobnet_id\":\"JOBNET_1\",\"job_id\":\"JOB-1\",\"job_name\":\"\",\"full_job_id\":\"JOBNET_1/JOB-1\",\"jobnet_boot_time\":\"\",\"jobnet_scheduled_time\":\"\",\"current_time\":\"20250711161800\"}')",
			"DELETE FROM ja_2_run_job_variable_table WHERE inner_job_id = 298",
			"INSERT INTO ja_2_run_job_variable_table (inner_job_id, inner_jobnet_id, before_variable) VALUES (298, 1500000000000000073, '{\"inner_jobnet_main_id\":1500000000000000073,\"jobnet_id\":\"JOBNET_1\",\"job_id\":\"JOB-1\",\"job_name\":\"\",\"full_job_id\":\"JOBNET_1/JOB-1\",\"jobnet_boot_time\":\"\",\"jobnet_scheduled_time\":\"\",\"current_time\":\"20250711161800\"}')",
			"select status from ja_2_run_job_table where inner_job_id = 298 for update",
			"update ja_2_run_job_table set status = 1, start_time = 0, end_time = 0 where inner_job_id = 298"
		],
		"transfer": {
			"files": [
			{
				"source": "/var/lib/jobarranger/server/dbsyncermanager/in/298_JOBNET_1_298_20250711161800.json",
				"destination": "/var/lib/jobarranger/server/iconexecmanager/in/298_JOBNET_1_298_20250711161800.json"
			}
			],
			"uds": {
			"socket_path": "/usr/local/bin/jobarranger/icon_exec_manager.sock"
			}
		}
	}
	`

	TestValueRunEventStr string = `
	{
		"event": {
			"name": "icon_exec_run",
			"unique_key": "val_icon_client_1750128515335531784"
		},
		"next_process": {
			"name": "iconexeccutionmanager",
			"data": {
				"transaction_file_id": "298_JOBNET_1_298_20250711161800",
				"exec_process_data": {
					"run_job_data": {
						"inner_job_id": 1428,
						"inner_jobnet_id": 1500000000000000033,
						"inner_jobnet_main_id": 1500000000000000033,
						"job_type": 3
					},
					"run_jobnet_data": {
						"inner_jobnet_id": 1234,
						"inner_jobnet_main_id": 1500000000000000033,
						"inner_job_id": 1428,
						"jobnet_id": ""
					}
				}
			}
		},
		"queries": null,
		"transfer": {
			"files": [
				{
					"source": "/var/lib/jobarranger/server/iconexecmanager/in/150000000000000020_123_20250617091835.json",
					"destination": "/var/lib/jobarranger/server/150000000000000020_123_20250617091835.json"
				}
			],
			"uds": {
			"socket_path": "iconexeccutionmanager.sock"
			}
		}
	}`

	TestValueEndEventStr string = `
	{
		"event": {
			"name": "icon_exec_end",
			"unique_key": "client_helper_1753255500398357181"
		},
		"next_process": {
			"name": "iconexecmanager",
			"data": {
			"transaction_file_id": "298_JOBNET_1_298_20250711161800",
			"exec_process_data": {
				"run_job_data": {
					"inner_job_id": 1428,
					"inner_jobnet_id": 1500000000000000033,
					"inner_jobnet_main_id": 1500000000000000033,
					"job_type": 3
				},
				"run_jobnet_data": {
					"inner_jobnet_id": 1234,
					"inner_jobnet_main_id": 1500000000000000033,
					"inner_job_id": 1428,
					"jobnet_id": ""
				}
			}
		}
		},
		"queries": null,
		"transfer": {
			"files": [
			{
				"source": "/var/lib/jobarranger/server/iconexecmanager/in/1500000000000000073_298_20250723135500.json",
				"destination": ""
			}
			],
			"uds": {
			"socket_path": ""
			}
		}
	}
	`

	TestInfoReadyEventStr = `
	{
		"event": {
			"name": "icon_ready",
			"unique_key": "flowmanager_20250711161807"
		},
		"next_process": {
			"name": "iconexecmanager",
			"data": {
			"run_job_data": {
				"inner_job_id": 298,
				"inner_jobnet_id": 1500000000000000073,
				"inner_jobnet_main_id": 1500000000000000073,
				"created_date": 1752218275,
				"invo_flag": 0,
				"job_type": 12,
				"data": {
					"info_flag": 1,
					"item_id": 5001,
					"trigger_id": 6002,
					"host_group": "web-servers",
					"host_name": "app-server-01",
					"get_job_id": "job-12345",
					"get_calendar_id": "calendar-67890",
					"status": 0
				},
				"test_flag": 0,
				"method_flag": 0,
				"force_flag": 0,
				"timeout_flag": 0,
				"status": 1,
				"boot_count": 1,
				"end_count": 0,
				"start_time": 0,
				"end_time": 0,
				"point_x": 480,
				"point_y": 180,
				"job_id": "JOB-1",
				"jobnet_id": "",
				"job_name": "",
				"continue_flag": 0,
				"run_user": "",
				"run_user_password": "",
				"client_pid": 0,
				"stop_code": 0,
				"command_id": ""
			},
			"run_job_variable_data": {
				"inner_job_id": 298,
				"inner_jobnet_id": 1500000000000000073,
				"before_variable": {
				"inner_jobnet_main_id": 1500000000000000073,
				"jobnet_id": "JOBNET_1",
				"job_id": "JOB-1",
				"job_name": "",
				"full_job_id": "JOBNET_1/JOB-1",
				"jobnet_boot_time": "",
				"jobnet_scheduled_time": "",
				"current_time": "20250711161800"
				},
				"after_variable": null,
				"seq_no": 0
			},
			"RunValueJobConData": null,
			"run_value_job_data": null,
			"session_data": {
				"session_id": "",
				"inner_jobnet_main_id": 0,
				"inner_job_id": 0,
				"operation_flag": 0,
				"status": 0,
				"force_stop": 0,
				"pid": 0,
				"ssh_client_socket": ""
			},
			"run_flow_data": {
				"inner_flow_id": 0,
				"inner_jobnet_id": 0,
				"start_inner_job_id": 0,
				"end_inner_job_id": 0,
				"flow_type": 0,
				"flow_width": 0,
				"flow_style": ""
			},
			"job_result": {
				"jobid": "",
				"type": "",
				"method": 0,
				"script": "",
				"cur_unique_id": "",
				"pre_unique_id": "",
				"argument": null,
				"env": null,
				"run_user": null,
				"run_user_password": null,
				"jobstatus": 0,
				"pid": 0,
				"message": "",
				"hostname": "",
				"result": 0,
				"std_out": "",
				"std_err": "",
				"return_code": 0,
				"signal": 0
			},
			"parameter_data": {
				"parameter_name": "",
				"value": "",
				"created_date": 0
			},
			"jobnet_start_time": 0,
			"info_result_data": {
				"status": 0,
				"cal_result": false
			}
			}
		},
		"queries": [
			"DELETE FROM ja_2_run_job_variable_table WHERE inner_job_id = 298",
			"INSERT INTO ja_2_run_job_variable_table (inner_job_id, inner_jobnet_id, before_variable) VALUES (298, 1500000000000000073, '{\"inner_jobnet_main_id\":1500000000000000073,\"jobnet_id\":\"JOBNET_1\",\"job_id\":\"JOB-1\",\"job_name\":\"\",\"full_job_id\":\"JOBNET_1/JOB-1\",\"jobnet_boot_time\":\"\",\"jobnet_scheduled_time\":\"\",\"current_time\":\"20250711161800\"}')",
			"DELETE FROM ja_2_run_job_variable_table WHERE inner_job_id = 298",
			"INSERT INTO ja_2_run_job_variable_table (inner_job_id, inner_jobnet_id, before_variable) VALUES (298, 1500000000000000073, '{\"inner_jobnet_main_id\":1500000000000000073,\"jobnet_id\":\"JOBNET_1\",\"job_id\":\"JOB-1\",\"job_name\":\"\",\"full_job_id\":\"JOBNET_1/JOB-1\",\"jobnet_boot_time\":\"\",\"jobnet_scheduled_time\":\"\",\"current_time\":\"20250711161800\"}')",
			"select status from ja_2_run_job_table where inner_job_id = 298 for update",
			"update ja_2_run_job_table set status = 1, start_time = 0, end_time = 0 where inner_job_id = 298"
		],
		"transfer": {
			"files": [
			{
				"source": "/var/lib/jobarranger/server/dbsyncermanager/in/298_JOBNET_1_298_20250711161800.json",
				"destination": "/var/lib/jobarranger/server/iconexecmanager/in/298_JOBNET_1_298_20250711161800.json"
			}
			],
			"uds": {
			"socket_path": "/usr/local/bin/jobarranger/icon_exec_manager.sock"
			}
		}
	}
	`

	TestInfoRunEventStr string = `
	{
		"event": {
			"name": "icon_exec_run",
			"unique_key": "val_icon_client_1750128515335531784"
		},
		"next_process": {
			"name": "iconexeccutionmanager",
			"data": {
				"transaction_file_id": "298_JOBNET_1_298_20250711161800",
				"exec_process_data": {
					"run_job_data": {
						"inner_job_id": 1428,
						"inner_jobnet_id": 1500000000000000033,
						"inner_jobnet_main_id": 1500000000000000033,
						"job_type": 12
					},
					"run_jobnet_data": {
						"inner_jobnet_id": 1234,
						"inner_jobnet_main_id": 1500000000000000033,
						"inner_job_id": 1428,
						"jobnet_id": ""
					}
				}
			}
		},
		"queries": null,
		"transfer": {
			"files": [
				{
					"source": "/var/lib/jobarranger/server/iconexecmanager/in/150000000000000020_123_20250617091835.json",
					"destination": "/var/lib/jobarranger/server/150000000000000020_123_20250617091835.json"
				}
			],
			"uds": {
			"socket_path": "iconexeccutionmanager.sock"
			}
		}
	}`

	TestInfoEndEventStr string = `
	{
		"event": {
			"name": "icon_exec_end",
			"unique_key": "client_helper_1753257948148785014"
		},
		"next_process": {
			"name": "iconexecmanager",
			"data": {
			"transaction_file_id": "298_JOBNET_1_298_20250711161800",
			"exec_process_data": {
				"run_job_data": {
					"inner_job_id": 1428,
					"inner_jobnet_id": 1500000000000000033,
					"inner_jobnet_main_id": 1500000000000000033,
					"job_type": 12
				},
				"run_jobnet_data": {
					"inner_jobnet_id": 1234,
					"inner_jobnet_main_id": 1500000000000000033,
					"inner_job_id": 1428,
					"jobnet_id": ""
				}
			}
		}
		},
		"queries": null,
		"transfer": {
			"files": [
			{
				"source": "/var/lib/jobarranger/server/iconexecmanager/in/1500000000000000073_298_20250723143548.json",
				"destination": ""
			}
			],
			"uds": {
			"socket_path": ""
			}
		}
	}
	`

	TestJobnetReadyEventStr = `
	{
		"event": {
			"name": "icon_ready",
			"unique_key": "flowmanager_20250711161807"
		},
		"next_process": {
			"name": "iconexecmanager",
			"data": {
			"run_job_data": {
				"inner_job_id": 298,
				"inner_jobnet_id": 1500000000000000073,
				"inner_jobnet_main_id": 1500000000000000073,
				"created_date": 1752218275,
				"invo_flag": 0,
				"job_type": 5,
				"data": {
					"info_flag": "132"
				},
				"test_flag": 0,
				"method_flag": 0,
				"force_flag": 0,
				"timeout_flag": 0,
				"status": 1,
				"boot_count": 1,
				"end_count": 0,
				"start_time": 0,
				"end_time": 0,
				"point_x": 480,
				"point_y": 180,
				"job_id": "JOB-1",
				"jobnet_id": "",
				"job_name": "",
				"continue_flag": 0,
				"run_user": "",
				"run_user_password": "",
				"client_pid": 0,
				"stop_code": 0,
				"command_id": ""
			},
			"run_job_variable_data": {
				"inner_job_id": 298,
				"inner_jobnet_id": 1500000000000000073,
				"before_variable": {
				"inner_jobnet_main_id": 1500000000000000073,
				"jobnet_id": "JOBNET_1",
				"job_id": "JOB-1",
				"job_name": "",
				"full_job_id": "JOBNET_1/JOB-1",
				"jobnet_boot_time": "",
				"jobnet_scheduled_time": "",
				"current_time": "20250711161800"
				},
				"after_variable": null,
				"seq_no": 0
			},
			"RunValueJobConData": null,
			"run_value_job_data": null,
			"session_data": {
				"session_id": "",
				"inner_jobnet_main_id": 0,
				"inner_job_id": 0,
				"operation_flag": 0,
				"status": 0,
				"force_stop": 0,
				"pid": 0,
				"ssh_client_socket": ""
			},
			"run_flow_data": {
				"inner_flow_id": 0,
				"inner_jobnet_id": 0,
				"start_inner_job_id": 0,
				"end_inner_job_id": 0,
				"flow_type": 0,
				"flow_width": 0,
				"flow_style": ""
			},
			"job_result": {
				"jobid": "",
				"type": "",
				"method": 0,
				"script": "",
				"cur_unique_id": "",
				"pre_unique_id": "",
				"argument": null,
				"env": null,
				"run_user": null,
				"run_user_password": null,
				"jobstatus": 0,
				"pid": 0,
				"message": "",
				"hostname": "",
				"result": 0,
				"std_out": "",
				"std_err": "",
				"return_code": 0,
				"signal": 0
			},
			"parameter_data": {
				"parameter_name": "",
				"value": "",
				"created_date": 0
			},
			"jobnet_start_time": 0,
			"info_result_data": {
				"status": 0,
				"cal_result": false
			}
			}
		},
		"queries": [
			"DELETE FROM ja_2_run_job_variable_table WHERE inner_job_id = 298",
			"INSERT INTO ja_2_run_job_variable_table (inner_job_id, inner_jobnet_id, before_variable) VALUES (298, 1500000000000000073, '{\"inner_jobnet_main_id\":1500000000000000073,\"jobnet_id\":\"JOBNET_1\",\"job_id\":\"JOB-1\",\"job_name\":\"\",\"full_job_id\":\"JOBNET_1/JOB-1\",\"jobnet_boot_time\":\"\",\"jobnet_scheduled_time\":\"\",\"current_time\":\"20250711161800\"}')",
			"DELETE FROM ja_2_run_job_variable_table WHERE inner_job_id = 298",
			"INSERT INTO ja_2_run_job_variable_table (inner_job_id, inner_jobnet_id, before_variable) VALUES (298, 1500000000000000073, '{\"inner_jobnet_main_id\":1500000000000000073,\"jobnet_id\":\"JOBNET_1\",\"job_id\":\"JOB-1\",\"job_name\":\"\",\"full_job_id\":\"JOBNET_1/JOB-1\",\"jobnet_boot_time\":\"\",\"jobnet_scheduled_time\":\"\",\"current_time\":\"20250711161800\"}')",
			"select status from ja_2_run_job_table where inner_job_id = 298 for update",
			"update ja_2_run_job_table set status = 1, start_time = 0, end_time = 0 where inner_job_id = 298"
		],
		"transfer": {
			"files": [
			{
				"source": "/var/lib/jobarranger/server/dbsyncermanager/in/298_JOBNET_1_298_20250711161800.json",
				"destination": "/var/lib/jobarranger/server/iconexecmanager/in/298_JOBNET_1_298_20250711161800.json"
			}
			],
			"uds": {
			"socket_path": "/usr/local/bin/jobarranger/icon_exec_manager.sock"
			}
		}
	}
	`

	TestJobnetRunEventStr string = `
	{
		"event": {
			"name": "icon_exec_run",
			"unique_key": "jobnet_icon_client_1750128515335531784"
		},
		"next_process": {
			"name": "iconexeccutionmanager",
			"data": {
				"transaction_file_id": "298_JOBNET_1_298_20250711161800",
				"exec_process_data": {
					"run_job_data": {
						"inner_job_id": 1428,
						"inner_jobnet_id": 1500000000000000033,
						"inner_jobnet_main_id": 1500000000000000033,
						"job_type": 5
					},
					"run_jobnet_data": {
						"inner_jobnet_id": 1234,
						"inner_jobnet_main_id": 1500000000000000033,
						"inner_job_id": 1428,
						"jobnet_id": ""
					}
				}
			}
		},
		"queries": null,
		"transfer": {
			"files": [
				{
					"source": "/var/lib/jobarranger/server/iconexecmanager/in/150000000000000020_123_20250617091835.json",
					"destination": "/var/lib/jobarranger/server/150000000000000020_123_20250617091835.json"
				}
			],
			"uds": {
				"socket_path": "iconexeccutionmanager.sock"
			}
		}
	}
	`

	TestJobnetEndEventStr string = `
	{
		"event": {
			"name": "icon_exec_end",
			"unique_key": "client_helper_1753259033508852556"
		},
		"next_process": {
			"name": "iconexecmanager",
			"data": {
			"transaction_file_id": "298_JOBNET_1_298_20250711161800",
			"exec_process_data": {
				"run_job_data": {
					"inner_job_id": 1428,
					"inner_jobnet_id": 1500000000000000033,
					"inner_jobnet_main_id": 1500000000000000033,
					"job_type": 5
				},
				"run_jobnet_data": {
					"inner_jobnet_id": 1234,
					"inner_jobnet_main_id": 1500000000000000033,
					"inner_job_id": 1428,
					"jobnet_id": ""
				}
			}
		}
		},
		"queries": null,
		"transfer": {
			"files": [
			{
				"source": "/var/lib/jobarranger/server/iconexecmanager/in/1500000000000000073_298_20250723145353.json",
				"destination": ""
			}
			],
			"uds": {
			"socket_path": ""
			}
		}
	}
	`

	TestJobnetAbortEventStr = `
	{
		"event": {
			"name": "icon_ready",
			"unique_key": "flowmanager_20250711161807"
		},
		"next_process": {
			"name": "iconexecmanager",
			"data": {
			"run_job_data": {
				"inner_job_id": 298,
				"inner_jobnet_id": 1500000000000000073,
				"inner_jobnet_main_id": 1500000000000000073,
				"created_date": 1752218275,
				"invo_flag": 0,
				"job_type": 5,
				"data": {
					"info_flag": "132"
				},
				"test_flag": 0,
				"method_flag": 3,
				"force_flag": 0,
				"timeout_flag": 0,
				"status": 1,
				"boot_count": 1,
				"end_count": 0,
				"start_time": 0,
				"end_time": 0,
				"point_x": 480,
				"point_y": 180,
				"job_id": "JOB-1",
				"jobnet_id": "",
				"job_name": "",
				"continue_flag": 0,
				"run_user": "",
				"run_user_password": "",
				"client_pid": 0,
				"stop_code": 0,
				"command_id": ""
			},
			"run_job_variable_data": {
				"inner_job_id": 298,
				"inner_jobnet_id": 1500000000000000073,
				"before_variable": {
				"inner_jobnet_main_id": 1500000000000000073,
				"jobnet_id": "JOBNET_1",
				"job_id": "JOB-1",
				"job_name": "",
				"full_job_id": "JOBNET_1/JOB-1",
				"jobnet_boot_time": "",
				"jobnet_scheduled_time": "",
				"current_time": "20250711161800"
				},
				"after_variable": null,
				"seq_no": 0
			},
			"RunValueJobConData": null,
			"run_value_job_data": null,
			"session_data": {
				"session_id": "",
				"inner_jobnet_main_id": 0,
				"inner_job_id": 0,
				"operation_flag": 0,
				"status": 0,
				"force_stop": 0,
				"pid": 0,
				"ssh_client_socket": ""
			},
			"run_flow_data": {
				"inner_flow_id": 0,
				"inner_jobnet_id": 0,
				"start_inner_job_id": 0,
				"end_inner_job_id": 0,
				"flow_type": 0,
				"flow_width": 0,
				"flow_style": ""
			},
			"job_result": {
				"jobid": "",
				"type": "",
				"method": 0,
				"script": "",
				"cur_unique_id": "",
				"pre_unique_id": "",
				"argument": null,
				"env": null,
				"run_user": null,
				"run_user_password": null,
				"jobstatus": 0,
				"pid": 0,
				"message": "",
				"hostname": "",
				"result": 0,
				"std_out": "",
				"std_err": "",
				"return_code": 0,
				"signal": 0
			},
			"parameter_data": {
				"parameter_name": "",
				"value": "",
				"created_date": 0
			},
			"jobnet_start_time": 0,
			"info_result_data": {
				"status": 0,
				"cal_result": false
			}
			}
		},
		"queries": [
			"DELETE FROM ja_2_run_job_variable_table WHERE inner_job_id = 298",
			"INSERT INTO ja_2_run_job_variable_table (inner_job_id, inner_jobnet_id, before_variable) VALUES (298, 1500000000000000073, '{\"inner_jobnet_main_id\":1500000000000000073,\"jobnet_id\":\"JOBNET_1\",\"job_id\":\"JOB-1\",\"job_name\":\"\",\"full_job_id\":\"JOBNET_1/JOB-1\",\"jobnet_boot_time\":\"\",\"jobnet_scheduled_time\":\"\",\"current_time\":\"20250711161800\"}')",
			"DELETE FROM ja_2_run_job_variable_table WHERE inner_job_id = 298",
			"INSERT INTO ja_2_run_job_variable_table (inner_job_id, inner_jobnet_id, before_variable) VALUES (298, 1500000000000000073, '{\"inner_jobnet_main_id\":1500000000000000073,\"jobnet_id\":\"JOBNET_1\",\"job_id\":\"JOB-1\",\"job_name\":\"\",\"full_job_id\":\"JOBNET_1/JOB-1\",\"jobnet_boot_time\":\"\",\"jobnet_scheduled_time\":\"\",\"current_time\":\"20250711161800\"}')",
			"select status from ja_2_run_job_table where inner_job_id = 298 for update",
			"update ja_2_run_job_table set status = 1, start_time = 0, end_time = 0 where inner_job_id = 298"
		],
		"transfer": {
			"files": [
			{
				"source": "/var/lib/jobarranger/server/dbsyncermanager/in/298_JOBNET_1_298_20250711161800.json",
				"destination": "/var/lib/jobarranger/server/iconexecmanager/in/298_JOBNET_1_298_20250711161800.json"
			}
			],
			"uds": {
			"socket_path": "/usr/local/bin/jobarranger/icon_exec_manager.sock"
			}
		}
	}
	`

	TestIfEndReadyEventStr = `
	{
		"event": {
			"name": "icon_ready",
			"unique_key": "flowmanager_20250711161807"
		},
		"next_process": {
			"name": "iconexecmanager",
			"data": {
			"run_job_data": {
				"inner_job_id": 298,
				"inner_jobnet_id": 1500000000000000073,
				"inner_jobnet_main_id": 1500000000000000073,
				"created_date": 1752218275,
				"invo_flag": 0,
				"job_type": 13,
				"data": {
				},
				"test_flag": 0,
				"method_flag": 0,
				"force_flag": 0,
				"timeout_flag": 0,
				"status": 1,
				"boot_count": 1,
				"end_count": 0,
				"start_time": 0,
				"end_time": 0,
				"point_x": 480,
				"point_y": 180,
				"job_id": "JOB-1",
				"jobnet_id": "",
				"job_name": "",
				"continue_flag": 0,
				"run_user": "",
				"run_user_password": "",
				"client_pid": 0,
				"stop_code": 0,
				"command_id": ""
			},
			"run_job_variable_data": {
				"inner_job_id": 298,
				"inner_jobnet_id": 1500000000000000073,
				"before_variable": {
				"inner_jobnet_main_id": 1500000000000000073,
				"jobnet_id": "JOBNET_1",
				"job_id": "JOB-1",
				"job_name": "",
				"full_job_id": "JOBNET_1/JOB-1",
				"jobnet_boot_time": "",
				"jobnet_scheduled_time": "",
				"current_time": "20250711161800"
				},
				"after_variable": null,
				"seq_no": 0
			},
			"RunValueJobConData": null,
			"run_value_job_data": null,
			"session_data": {
				"session_id": "",
				"inner_jobnet_main_id": 0,
				"inner_job_id": 0,
				"operation_flag": 0,
				"status": 0,
				"force_stop": 0,
				"pid": 0,
				"ssh_client_socket": ""
			},
			"run_flow_data": {
				"inner_flow_id": 0,
				"inner_jobnet_id": 0,
				"start_inner_job_id": 0,
				"end_inner_job_id": 0,
				"flow_type": 0,
				"flow_width": 0,
				"flow_style": ""
			},
			"job_result": {
				"jobid": "",
				"type": "",
				"method": 0,
				"script": "",
				"cur_unique_id": "",
				"pre_unique_id": "",
				"argument": null,
				"env": null,
				"run_user": null,
				"run_user_password": null,
				"jobstatus": 0,
				"pid": 0,
				"message": "",
				"hostname": "",
				"result": 0,
				"std_out": "",
				"std_err": "",
				"return_code": 0,
				"signal": 0
			},
			"parameter_data": {
				"parameter_name": "",
				"value": "",
				"created_date": 0
			},
			"jobnet_start_time": 0,
			"info_result_data": {
				"status": 0,
				"cal_result": false
			}
			}
		},
		"queries": [
			"DELETE FROM ja_2_run_job_variable_table WHERE inner_job_id = 298",
			"INSERT INTO ja_2_run_job_variable_table (inner_job_id, inner_jobnet_id, before_variable) VALUES (298, 1500000000000000073, '{\"inner_jobnet_main_id\":1500000000000000073,\"jobnet_id\":\"JOBNET_1\",\"job_id\":\"JOB-1\",\"job_name\":\"\",\"full_job_id\":\"JOBNET_1/JOB-1\",\"jobnet_boot_time\":\"\",\"jobnet_scheduled_time\":\"\",\"current_time\":\"20250711161800\"}')",
			"DELETE FROM ja_2_run_job_variable_table WHERE inner_job_id = 298",
			"INSERT INTO ja_2_run_job_variable_table (inner_job_id, inner_jobnet_id, before_variable) VALUES (298, 1500000000000000073, '{\"inner_jobnet_main_id\":1500000000000000073,\"jobnet_id\":\"JOBNET_1\",\"job_id\":\"JOB-1\",\"job_name\":\"\",\"full_job_id\":\"JOBNET_1/JOB-1\",\"jobnet_boot_time\":\"\",\"jobnet_scheduled_time\":\"\",\"current_time\":\"20250711161800\"}')",
			"select status from ja_2_run_job_table where inner_job_id = 298 for update",
			"update ja_2_run_job_table set status = 1, start_time = 0, end_time = 0 where inner_job_id = 298"
		],
		"transfer": {
			"files": [
			{
				"source": "/var/lib/jobarranger/server/dbsyncermanager/in/298_JOBNET_1_298_20250711161800.json",
				"destination": "/var/lib/jobarranger/server/iconexecmanager/in/298_JOBNET_1_298_20250711161800.json"
			}
			],
			"uds": {
			"socket_path": "/usr/local/bin/jobarranger/icon_exec_manager.sock"
			}
		}
	}
	`

	TestIfEndRunEventStr string = `
	{
		"event": {
			"name": "icon_exec_run",
			"unique_key": "ifend_icon_client_1750128515335531784"
		},
		"next_process": {
			"name": "iconexeccutionmanager",
			"data": {
				"transaction_file_id": "298_JOBNET_1_298_20250711161800",
				"exec_process_data": {
					"run_job_data": {
						"inner_job_id": 1428,
						"inner_jobnet_id": 1500000000000000033,
						"inner_jobnet_main_id": 1500000000000000033,
						"job_type": 13
					},
					"run_jobnet_data": {
						"inner_jobnet_id": 1234,
						"inner_jobnet_main_id": 1500000000000000033,
						"inner_job_id": 1428,
						"jobnet_id": ""
					}
				}
			}
		},
		"queries": null,
		"transfer": {
			"files": [
				{
					"source": "/var/lib/jobarranger/server/iconexecmanager/in/150000000000000020_123_20250617091835.json",
					"destination": "/var/lib/jobarranger/server/150000000000000020_123_20250617091835.json"
				}
			],
			"uds": {
			"socket_path": "iconexeccutionmanager.sock"
			}
		}
	}`

	TestIfEndEndEventStr string = `
	{
		"event": {
			"name": "icon_exec_end",
			"unique_key": "client_helper_1753260550013872037"
		},
		"next_process": {
			"name": "iconexecmanager",
			"data": {
			"transaction_file_id": "298_JOBNET_1_298_20250711161800",
			"exec_process_data": {
				"run_job_data": {
					"inner_job_id": 1428,
					"inner_jobnet_id": 1500000000000000033,
					"inner_jobnet_main_id": 1500000000000000033,
					"job_type": 13
				},
				"run_jobnet_data": {
					"inner_jobnet_id": 1234,
					"inner_jobnet_main_id": 1500000000000000033,
					"inner_job_id": 1428,
					"jobnet_id": ""
				}
			}
		}
		},
		"queries": null,
		"transfer": {
			"files": [
			{
				"source": "/var/lib/jobarranger/server/iconexecmanager/in/1500000000000000073_298_20250723151910.json",
				"destination": ""
			}
			],
			"uds": {
			"socket_path": ""
			}
		}
	}
	`

	TestLoopReadyEventStr = `
	{
		"event": {
			"name": "icon_ready",
			"unique_key": "flowmanager_20250711161807"
		},
		"next_process": {
			"name": "iconexecmanager",
			"data": {
			"run_job_data": {
				"inner_job_id": 298,
				"inner_jobnet_id": 1500000000000000073,
				"inner_jobnet_main_id": 1500000000000000073,
				"created_date": 1752218275,
				"invo_flag": 0,
				"job_type": 8,
				"data": {
				},
				"test_flag": 0,
				"method_flag": 0,
				"force_flag": 0,
				"timeout_flag": 0,
				"status": 1,
				"boot_count": 1,
				"end_count": 0,
				"start_time": 0,
				"end_time": 0,
				"point_x": 480,
				"point_y": 180,
				"job_id": "JOB-1",
				"jobnet_id": "",
				"job_name": "",
				"continue_flag": 0,
				"run_user": "",
				"run_user_password": "",
				"client_pid": 0,
				"stop_code": 0,
				"command_id": ""
			},
			"run_job_variable_data": {
				"inner_job_id": 298,
				"inner_jobnet_id": 1500000000000000073,
				"before_variable": {
				"inner_jobnet_main_id": 1500000000000000073,
				"jobnet_id": "JOBNET_1",
				"job_id": "JOB-1",
				"job_name": "",
				"full_job_id": "JOBNET_1/JOB-1",
				"jobnet_boot_time": "",
				"jobnet_scheduled_time": "",
				"current_time": "20250711161800"
				},
				"after_variable": null,
				"seq_no": 0
			},
			"RunValueJobConData": null,
			"run_value_job_data": null,
			"session_data": {
				"session_id": "",
				"inner_jobnet_main_id": 0,
				"inner_job_id": 0,
				"operation_flag": 0,
				"status": 0,
				"force_stop": 0,
				"pid": 0,
				"ssh_client_socket": ""
			},
			"run_flow_data": {
				"inner_flow_id": 0,
				"inner_jobnet_id": 0,
				"start_inner_job_id": 0,
				"end_inner_job_id": 0,
				"flow_type": 0,
				"flow_width": 0,
				"flow_style": ""
			},
			"job_result": {
				"jobid": "",
				"type": "",
				"method": 0,
				"script": "",
				"cur_unique_id": "",
				"pre_unique_id": "",
				"argument": null,
				"env": null,
				"run_user": null,
				"run_user_password": null,
				"jobstatus": 0,
				"pid": 0,
				"message": "",
				"hostname": "",
				"result": 0,
				"std_out": "",
				"std_err": "",
				"return_code": 0,
				"signal": 0
			},
			"parameter_data": {
				"parameter_name": "",
				"value": "",
				"created_date": 0
			},
			"jobnet_start_time": 0,
			"info_result_data": {
				"status": 0,
				"cal_result": false
			}
			}
		},
		"queries": [
			"DELETE FROM ja_2_run_job_variable_table WHERE inner_job_id = 298",
			"INSERT INTO ja_2_run_job_variable_table (inner_job_id, inner_jobnet_id, before_variable) VALUES (298, 1500000000000000073, '{\"inner_jobnet_main_id\":1500000000000000073,\"jobnet_id\":\"JOBNET_1\",\"job_id\":\"JOB-1\",\"job_name\":\"\",\"full_job_id\":\"JOBNET_1/JOB-1\",\"jobnet_boot_time\":\"\",\"jobnet_scheduled_time\":\"\",\"current_time\":\"20250711161800\"}')",
			"DELETE FROM ja_2_run_job_variable_table WHERE inner_job_id = 298",
			"INSERT INTO ja_2_run_job_variable_table (inner_job_id, inner_jobnet_id, before_variable) VALUES (298, 1500000000000000073, '{\"inner_jobnet_main_id\":1500000000000000073,\"jobnet_id\":\"JOBNET_1\",\"job_id\":\"JOB-1\",\"job_name\":\"\",\"full_job_id\":\"JOBNET_1/JOB-1\",\"jobnet_boot_time\":\"\",\"jobnet_scheduled_time\":\"\",\"current_time\":\"20250711161800\"}')",
			"select status from ja_2_run_job_table where inner_job_id = 298 for update",
			"update ja_2_run_job_table set status = 1, start_time = 0, end_time = 0 where inner_job_id = 298"
		],
		"transfer": {
			"files": [
			{
				"source": "/var/lib/jobarranger/server/dbsyncermanager/in/298_JOBNET_1_298_20250711161800.json",
				"destination": "/var/lib/jobarranger/server/iconexecmanager/in/298_JOBNET_1_298_20250711161800.json"
			}
			],
			"uds": {
			"socket_path": "/usr/local/bin/jobarranger/icon_exec_manager.sock"
			}
		}
	}
	`

	TestLoopRunEventStr string = `
	{
		"event": {
			"name": "icon_exec_run",
			"unique_key": "loop_icon_client_1750128515335531784"
		},
		"next_process": {
			"name": "iconexeccutionmanager",
			"data": {
				"transaction_file_id": "298_JOBNET_1_298_20250711161800",
				"exec_process_data": {
					"run_job_data": {
						"inner_job_id": 1428,
						"inner_jobnet_id": 1500000000000000033,
						"inner_jobnet_main_id": 1500000000000000033,
						"job_type": 8
					},
					"run_jobnet_data": {
						"inner_jobnet_id": 1234,
						"inner_jobnet_main_id": 1500000000000000033,
						"inner_job_id": 1428,
						"jobnet_id": ""
					}
				}
			}
		},
		"queries": null,
		"transfer": {
			"files": [
				{
					"source": "/var/lib/jobarranger/server/iconexecmanager/in/150000000000000020_123_20250617091835.json",
					"destination": "/var/lib/jobarranger/server/150000000000000020_123_20250617091835.json"
				}
			],
			"uds": {
			"socket_path": "iconexeccutionmanager.sock"
			}
		}
	}`

	TestLoopEndEventStr = `
	{
		"event": {
			"name": "icon_exec_end",
			"unique_key": "client_helper_1753262279498871416"
		},
		"next_process": {
			"name": "iconexecmanager",
			"data": {
			"transaction_file_id": "1500000000000000033_1428_20250601171106",
			"exec_process_data": {
				"run_job_data": {
					"inner_job_id": 1428,
					"inner_jobnet_id": 1500000000000000033,
					"inner_jobnet_main_id": 1500000000000000033,
					"job_type": 8
				},
				"run_jobnet_data": {
					"inner_jobnet_id": 1234,
					"inner_jobnet_main_id": 1500000000000000033,
					"inner_job_id": 1428,
					"jobnet_id": ""
				}
			}
		}
		},
		"queries": null,
		"transfer": {
			"files": [
			{
				"source": "/var/lib/jobarranger/server/iconexecmanager/in/1500000000000000073_298_20250723154759.json",
				"destination": ""
			}
			],
			"uds": {
			"socket_path": ""
			}
		}
		}
	`

	TestWReadyEventStr = `
	{
		"event": {
			"name": "icon_ready",
			"unique_key": "flowmanager_20250711161807"
		},
		"next_process": {
			"name": "iconexecmanager",
			"data": {
			"run_job_data": {
				"inner_job_id": 298,
				"inner_jobnet_id": 1500000000000000073,
				"inner_jobnet_main_id": 1500000000000000073,
				"created_date": 1752218275,
				"invo_flag": 0,
				"job_type": 7,
				"data": {
				},
				"test_flag": 0,
				"method_flag": 0,
				"force_flag": 0,
				"timeout_flag": 0,
				"status": 1,
				"boot_count": 1,
				"end_count": 0,
				"start_time": 0,
				"end_time": 0,
				"point_x": 480,
				"point_y": 180,
				"job_id": "JOB-1",
				"jobnet_id": "",
				"job_name": "",
				"continue_flag": 0,
				"run_user": "",
				"run_user_password": "",
				"client_pid": 0,
				"stop_code": 0,
				"command_id": ""
			},
			"run_job_variable_data": {
				"inner_job_id": 298,
				"inner_jobnet_id": 1500000000000000073,
				"before_variable": {
				"inner_jobnet_main_id": 1500000000000000073,
				"jobnet_id": "JOBNET_1",
				"job_id": "JOB-1",
				"job_name": "",
				"full_job_id": "JOBNET_1/JOB-1",
				"jobnet_boot_time": "",
				"jobnet_scheduled_time": "",
				"current_time": "20250711161800"
				},
				"after_variable": null,
				"seq_no": 0
			},
			"RunValueJobConData": null,
			"run_value_job_data": null,
			"session_data": {
				"session_id": "",
				"inner_jobnet_main_id": 0,
				"inner_job_id": 0,
				"operation_flag": 0,
				"status": 0,
				"force_stop": 0,
				"pid": 0,
				"ssh_client_socket": ""
			},
			"run_flow_data": {
				"inner_flow_id": 0,
				"inner_jobnet_id": 0,
				"start_inner_job_id": 0,
				"end_inner_job_id": 0,
				"flow_type": 0,
				"flow_width": 0,
				"flow_style": ""
			},
			"job_result": {
				"jobid": "",
				"type": "",
				"method": 0,
				"script": "",
				"cur_unique_id": "",
				"pre_unique_id": "",
				"argument": null,
				"env": null,
				"run_user": null,
				"run_user_password": null,
				"jobstatus": 0,
				"pid": 0,
				"message": "",
				"hostname": "",
				"result": 0,
				"std_out": "",
				"std_err": "",
				"return_code": 0,
				"signal": 0
			},
			"parameter_data": {
				"parameter_name": "",
				"value": "",
				"created_date": 0
			},
			"jobnet_start_time": 0,
			"info_result_data": {
				"status": 0,
				"cal_result": false
			}
			}
		},
		"queries": [
			"DELETE FROM ja_2_run_job_variable_table WHERE inner_job_id = 298",
			"INSERT INTO ja_2_run_job_variable_table (inner_job_id, inner_jobnet_id, before_variable) VALUES (298, 1500000000000000073, '{\"inner_jobnet_main_id\":1500000000000000073,\"jobnet_id\":\"JOBNET_1\",\"job_id\":\"JOB-1\",\"job_name\":\"\",\"full_job_id\":\"JOBNET_1/JOB-1\",\"jobnet_boot_time\":\"\",\"jobnet_scheduled_time\":\"\",\"current_time\":\"20250711161800\"}')",
			"DELETE FROM ja_2_run_job_variable_table WHERE inner_job_id = 298",
			"INSERT INTO ja_2_run_job_variable_table (inner_job_id, inner_jobnet_id, before_variable) VALUES (298, 1500000000000000073, '{\"inner_jobnet_main_id\":1500000000000000073,\"jobnet_id\":\"JOBNET_1\",\"job_id\":\"JOB-1\",\"job_name\":\"\",\"full_job_id\":\"JOBNET_1/JOB-1\",\"jobnet_boot_time\":\"\",\"jobnet_scheduled_time\":\"\",\"current_time\":\"20250711161800\"}')",
			"select status from ja_2_run_job_table where inner_job_id = 298 for update",
			"update ja_2_run_job_table set status = 1, start_time = 0, end_time = 0 where inner_job_id = 298"
		],
		"transfer": {
			"files": [
			{
				"source": "/var/lib/jobarranger/server/dbsyncermanager/in/298_JOBNET_1_298_20250711161800.json",
				"destination": "/var/lib/jobarranger/server/iconexecmanager/in/298_JOBNET_1_298_20250711161800.json"
			}
			],
			"uds": {
			"socket_path": "/usr/local/bin/jobarranger/icon_exec_manager.sock"
			}
		}
	}
	`

	TestWRunEventStr string = `
	{
		"event": {
			"name": "icon_exec_run",
			"unique_key": "w_icon_client_1750128515335531784"
		},
		"next_process": {
			"name": "iconexeccutionmanager",
			"data": {
				"transaction_file_id": "298_JOBNET_1_298_20250711161800",
				"exec_process_data": {
					"run_job_data": {
						"inner_job_id": 1428,
						"inner_jobnet_id": 1500000000000000033,
						"inner_jobnet_main_id": 1500000000000000033,
						"job_type": 7
					},
					"run_jobnet_data": {
						"inner_jobnet_id": 1234,
						"inner_jobnet_main_id": 1500000000000000033,
						"inner_job_id": 1428,
						"jobnet_id": ""
					}
				}
			}
		},
		"queries": null,
		"transfer": {
			"files": [
				{
					"source": "/var/lib/jobarranger/server/iconexecmanager/in/150000000000000020_123_20250617091835.json",
					"destination": "/var/lib/jobarranger/server/150000000000000020_123_20250617091835.json"
				}
			],
			"uds": {
			"socket_path": "iconexeccutionmanager.sock"
			}
		}
	}`

	TestWEndEventStr string = `
	{
		"event": {
			"name": "icon_exec_end",
			"unique_key": "client_helper_1753261488076266507"
		},
		"next_process": {
			"name": "iconexecmanager",
			"data": {
			"transaction_file_id": "298_JOBNET_1_298_20250711161800",
			"exec_process_data": {
				"run_job_data": {
					"inner_job_id": 1428,
					"inner_jobnet_id": 1500000000000000033,
					"inner_jobnet_main_id": 1500000000000000033,
					"job_type": 7
				},
				"run_jobnet_data": {
					"inner_jobnet_id": 1234,
					"inner_jobnet_main_id": 1500000000000000033,
					"inner_job_id": 1428,
					"jobnet_id": ""
				}
			}
			}
		},
		"queries": null,
		"transfer": {
			"files": [
			{
				"source": "/var/lib/jobarranger/server/iconexecmanager/in/1500000000000000073_298_20250723153448.json",
				"destination": ""
			}
			],
			"uds": {
			"socket_path": ""
			}
		}
	}
	`

	TestMReadyEventStr = `
	{
		"event": {
			"name": "icon_ready",
			"unique_key": "flowmanager_20250711161807"
		},
		"next_process": {
			"name": "iconexecmanager",
			"data": {
				"run_job_data": {
					"inner_job_id": 298,
					"inner_jobnet_id": 1500000000000000073,
					"inner_jobnet_main_id": 1500000000000000073,
					"created_date": 1752218275,
					"invo_flag": 0,
					"job_type": 6,
					"data": {
					},
					"test_flag": 0,
					"method_flag": 0,
					"force_flag": 0,
					"timeout_flag": 0,
					"status": 1,
					"boot_count": 1,
					"end_count": 0,
					"start_time": 0,
					"end_time": 0,
					"point_x": 480,
					"point_y": 180,
					"job_id": "JOB-1",
					"jobnet_id": "",
					"job_name": "",
					"continue_flag": 0,
					"run_user": "",
					"run_user_password": "",
					"client_pid": 0,
					"stop_code": 0,
					"command_id": ""
				},
				"run_job_variable_data": {
					"inner_job_id": 298,
					"inner_jobnet_id": 1500000000000000073,
					"before_variable": {
					"inner_jobnet_main_id": 1500000000000000073,
					"jobnet_id": "JOBNET_1",
					"job_id": "JOB-1",
					"job_name": "",
					"full_job_id": "JOBNET_1/JOB-1",
					"jobnet_boot_time": "",
					"jobnet_scheduled_time": "",
					"current_time": "20250711161800"
					},
					"after_variable": null,
					"seq_no": 0
				},
				"RunValueJobConData": null,
				"run_value_job_data": null,
				"session_data": {
					"session_id": "",
					"inner_jobnet_main_id": 0,
					"inner_job_id": 0,
					"operation_flag": 0,
					"status": 0,
					"force_stop": 0,
					"pid": 0,
					"ssh_client_socket": ""
				},
				"run_flow_data": {
					"inner_flow_id": 0,
					"inner_jobnet_id": 0,
					"start_inner_job_id": 0,
					"end_inner_job_id": 0,
					"flow_type": 0,
					"flow_width": 0,
					"flow_style": ""
				},
				"job_result": {
					"jobid": "",
					"type": "",
					"method": 0,
					"script": "",
					"cur_unique_id": "",
					"pre_unique_id": "",
					"argument": null,
					"env": null,
					"run_user": null,
					"run_user_password": null,
					"jobstatus": 0,
					"pid": 0,
					"message": "",
					"hostname": "",
					"result": 0,
					"std_out": "",
					"std_err": "",
					"return_code": 0,
					"signal": 0
				},
				"parameter_data": {
					"parameter_name": "",
					"value": "",
					"created_date": 0
				},
				"jobnet_start_time": 0,
				"info_result_data": {
					"status": 0,
					"cal_result": false
				}
			}
		},
		"queries": [
			"DELETE FROM ja_2_run_job_variable_table WHERE inner_job_id = 298",
			"INSERT INTO ja_2_run_job_variable_table (inner_job_id, inner_jobnet_id, before_variable) VALUES (298, 1500000000000000073, '{\"inner_jobnet_main_id\":1500000000000000073,\"jobnet_id\":\"JOBNET_1\",\"job_id\":\"JOB-1\",\"job_name\":\"\",\"full_job_id\":\"JOBNET_1/JOB-1\",\"jobnet_boot_time\":\"\",\"jobnet_scheduled_time\":\"\",\"current_time\":\"20250711161800\"}')",
			"DELETE FROM ja_2_run_job_variable_table WHERE inner_job_id = 298",
			"INSERT INTO ja_2_run_job_variable_table (inner_job_id, inner_jobnet_id, before_variable) VALUES (298, 1500000000000000073, '{\"inner_jobnet_main_id\":1500000000000000073,\"jobnet_id\":\"JOBNET_1\",\"job_id\":\"JOB-1\",\"job_name\":\"\",\"full_job_id\":\"JOBNET_1/JOB-1\",\"jobnet_boot_time\":\"\",\"jobnet_scheduled_time\":\"\",\"current_time\":\"20250711161800\"}')",
			"select status from ja_2_run_job_table where inner_job_id = 298 for update",
			"update ja_2_run_job_table set status = 1, start_time = 0, end_time = 0 where inner_job_id = 298"
		],
		"transfer": {
			"files": [
			{
				"source": "/var/lib/jobarranger/server/dbsyncermanager/in/298_JOBNET_1_298_20250711161800.json",
				"destination": "/var/lib/jobarranger/server/iconexecmanager/in/298_JOBNET_1_298_20250711161800.json"
			}
			],
			"uds": {
			"socket_path": "/usr/local/bin/jobarranger/icon_exec_manager.sock"
			}
		}
	}
	`

	TestMRunEventStr string = `
	{
		"event": {
			"name": "icon_exec_run",
			"unique_key": "m_icon_client_1750128515335531784"
		},
		"next_process": {
			"name": "iconexeccutionmanager",
			"data": {
				"transaction_file_id": "298_JOBNET_1_298_20250711161800",
				"exec_process_data": {
					"run_job_data": {
						"inner_job_id": 1428,
						"inner_jobnet_id": 1500000000000000033,
						"inner_jobnet_main_id": 1500000000000000033,
						"job_type": 6
					},
					"run_jobnet_data": {
						"inner_jobnet_id": 1234,
						"inner_jobnet_main_id": 1500000000000000033,
						"inner_job_id": 1428,
						"jobnet_id": ""
					}
				}
			}
		},
		"queries": null,
		"transfer": {
			"files": [
				{
					"source": "/var/lib/jobarranger/server/iconexecmanager/in/150000000000000020_123_20250617091835.json",
					"destination": "/var/lib/jobarranger/server/150000000000000020_123_20250617091835.json"
				}
			],
			"uds": {
			"socket_path": "iconexeccutionmanager.sock"
			}
		}
	}`

	TestMEndEventStr string = `
	{
		"event": {
			"name": "icon_exec_end",
			"unique_key": "client_helper_1753261547731791470"
		},
		"next_process": {
			"name": "iconexecmanager",
			"data": {
			"transaction_file_id": "298_JOBNET_1_298_20250711161800",
			"exec_process_data": {
				"run_job_data": {
					"inner_job_id": 1428,
					"inner_jobnet_id": 1500000000000000033,
					"inner_jobnet_main_id": 1500000000000000033,
					"job_type": 6
				},
				"run_jobnet_data": {
					"inner_jobnet_id": 1234,
					"inner_jobnet_main_id": 1500000000000000033,
					"inner_job_id": 1428,
					"jobnet_id": ""
				}
			}
		}
		},
		"queries": null,
		"transfer": {
			"files": [
			{
				"source": "/var/lib/jobarranger/server/iconexecmanager/in/1500000000000000073_298_20250723153547.json",
				"destination": ""
			}
			],
			"uds": {
			"socket_path": ""
			}
		}
	}
	`

	TestCommonAbortEventStr string = `
	{
		"event": {

			"name": "icon_abort",

			"unique_key": ""

		},

		"next_process": {

			"name": "icon_execution_manager",

			"data": {

			"run_job_data": {

				"inner_job_id": 1428,

				"inner_jobnet_id": 0,

				"inner_jobnet_main_id": 1500000000000000033,

				"inner_job_id_fs_link": 0,

				"created_date": 0,

				"invo_flag": 0,

				"job_type": 0,

				"test_flag": 0,

				"method_flag": 3,

				"force_flag": 0,

				"timeout_flag": 0,

				"status": 0,

				"boot_count": 0,

				"end_count": 0,

				"start_time": 0,

				"end_time": 0,

				"point_x": 0,

				"point_y": 0,

				"job_id": "",

				"job_name": "",

				"continue_flag": 0,

				"run_user": "",

				"run_user_password": ""

			},

			"RunJobVariableData": {

				"inner_job_id": 0,

				"inner_jobnet_id": 0,

				"before_variable": null,

				"after_variable": null,

				"before_seq_no": 0,

				"after_seq_no": 0

			}

		}

	},

		"queries": [

			"INSERT INTO ja_2_run_job_variable_table (inner_job_id, inner_jobnet_id, before_variable, before_seq_no) VALUES (1428, 1500000000000000033, '{\"JOBNET_ID\":1234,\"USER_NAME\":\"admin\",\"JOBNET_NAME\":\"SampleJobnet\",\"MANAGEMENT_ID\":1500000000000000006,\"JOBNET_BOOT_TIME\":\"20250520134658\",\"JOBNET_SCHEDULED_TIME\":\"20250519120000\"}', 20250601171106)",

			"select status from ja_run_job_table where inner_job_id = 1428 for update",

			"update ja_run_job_table set status = 1, start_time = 0, end_time = 0 where inner_job_id = 1428"

		],

		"transfer": {

			"files": [

			{

				"source": "/var/lib/jobarranger/server/iconexecmanager/in/1500000000000000033_1428_20250601171106.json",

				"destination": "/tmp"

			}

			],

			"uds": {

			"socket_path": ""

			}

		}

	}`
)

func encodeTestEvent(eventData common.EventData) error {
	eventFile := filepath.Base(eventData.Transfer.Files[0].Source)
	
	file, err := os.Create(filepath.Join(execManagerInPath, eventFile))
	if err != nil {
		return err
	}

	encoder := json.NewEncoder(file)
	encoder.SetIndent("", "  ") 
	return encoder.Encode(eventData)
}

func getAgentlessClientData() (map[string]int, error) {
	clientData := map[string]int {
		".clientPID": 0,
		".data": 0,
		".sshClientPID": 0,
	}

	files, err := os.ReadDir(clientDataPath)
	if err != nil {
		return nil, err
	}

	for _, file := range files {
		for key := range clientData {
			if !file.IsDir() && strings.HasSuffix(file.Name(), key) {
				fullPath := filepath.Join(clientDataPath, file.Name())
				fmt.Println("Found file:", fullPath)

				// Read file content
				byteData, err := os.ReadFile(fullPath)
				if err != nil {
					fmt.Println("Error reading file:", err)
					continue
				}

				if key == ".data" {
					var agentlessData common.IconLessData

					err = json.Unmarshal(byteData, &agentlessData)
					if err != nil {
						return nil, fmt.Errorf("json.Unmarshal(iconDataByte, &agentlessData) failed. error: %s, byteData: %s", err.Error(), string(byteData))
					}

					clientData[".sshClientPID"] = agentlessData.SshClientPid
					break
				} else {
					pid, err := strconv.Atoi(strings.TrimSuffix(string(byteData), "\n"))
					if err != nil {
						fmt.Println("Error converting int:", err)
						continue
					}

					clientData[key] = pid
				}
			}
		}
	}

	return clientData, nil
}

func cleanFolder(folderPath string) error {
	entries, err := os.ReadDir(folderPath)
	if err != nil {
		return fmt.Errorf("failed to read directory: %w", err)
	}

	for _, entry := range entries {
		entryPath := filepath.Join(folderPath, entry.Name())
		err := os.RemoveAll(entryPath) // handles both files and directories
		if err != nil {
			return fmt.Errorf("failed to remove %s: %w", entryPath, err)
		}
	}

	return nil
}

func prepareTestEvent(t *testing.T) common.EventData {
	var eventStr string
	var eventData common.EventData

	fmt.Println("TestEvent(*inputEvent):", TestEvent(*inputEvent))

	switch TestIcon(*inputIcon) {
	case TestAgentlessIcon:
		if TestEvent(*inputEvent) == TestReadyEvent {
			eventStr = TestAgentlessReadyEventStr
		} else if TestEvent(*inputEvent) == TestRunEvent {
			eventStr = TestAgentlessRunEventStr
		} else if TestEvent(*inputEvent) == TestEndEvent {
			eventStr = TestAgentlessEndEventStr
		} else if TestEvent(*inputEvent) == TestAbortEvent {
			eventStr = TestAgentlessAbortEventStr
		} else {
			t.Errorf("unknown event")
			t.FailNow()
		}
	case TestJobIcon:
		if TestEvent(*inputEvent) == TestReadyEvent {
			eventStr = TestJobReadyEventStr
		} else if TestEvent(*inputEvent) == TestRunEvent {
			eventStr = TestJobRunEventStr
		} else if TestEvent(*inputEvent) == TestEndEvent {
			eventStr = TestJobEndEventStr
		} else if TestEvent(*inputEvent) == TestAbortEvent {
			eventStr = TestJobAbortEventStr
		} else {
			t.Errorf("unknown event")
			t.FailNow()
		}
	case TestExtJobIcon:
		if TestEvent(*inputEvent) == TestReadyEvent {
			eventStr = TestExtJobReadyEventStr
		} else if TestEvent(*inputEvent) == TestRunEvent {
			eventStr = TestExtJobRunEventStr
		} else if TestEvent(*inputEvent) == TestEndEvent {
			eventStr = TestExtJobEndEventStr
		} else if TestEvent(*inputEvent) == TestAbortEvent {
			eventStr = TestExtJobAbortEventStr
		} else {
			t.Errorf("unknown event")
			t.FailNow()
		}
	case TestIfIcon:
		if TestEvent(*inputEvent) == TestReadyEvent {
			eventStr = TestIfReadyEventStr
		} else if TestEvent(*inputEvent) == TestRunEvent {
			eventStr = TestIfRunEventStr
		} else if TestEvent(*inputEvent) == TestEndEvent {
			eventStr = TestIfEndEventStr
		} else if TestEvent(*inputEvent) == TestAbortEvent {
			eventStr = TestCommonAbortEventStr
		} else {
			t.Errorf("unknown event")
			t.FailNow()
		}
	case TestStartIcon:
		if TestEvent(*inputEvent) == TestReadyEvent {
			eventStr = TestStartReadyEventStr
		} else if TestEvent(*inputEvent) == TestRunEvent {
			eventStr = TestStartRunEventStr
		} else if TestEvent(*inputEvent) == TestEndEvent {
			eventStr = TestStartEndEventStr
		} else if TestEvent(*inputEvent) == TestAbortEvent {
			eventStr = TestCommonAbortEventStr
		} else {
			t.Errorf("unknown event")
			t.FailNow()
		}
	case TestEndIcon:
		if TestEvent(*inputEvent) == TestReadyEvent {
			eventStr = TestEndReadyEventStr
		} else if TestEvent(*inputEvent) == TestRunEvent {
			eventStr = TestEndRunEventStr
		} else if TestEvent(*inputEvent) == TestEndEvent {
			eventStr = TestEndEndEventStr
		} else if TestEvent(*inputEvent) == TestAbortEvent {
			eventStr = TestCommonAbortEventStr
		} else {
			t.Errorf("unknown event")
			t.FailNow()
		}
	case TestCalcuIcon:
		if TestEvent(*inputEvent) == TestReadyEvent {
			eventStr = TestCalculateReadyEventStr
		} else if TestEvent(*inputEvent) == TestRunEvent {
			eventStr = TestCalculateRunEventStr
		}  else if TestEvent(*inputEvent) == TestEndEvent {
			eventStr = TestCalculateEndEventStr
		} else if TestEvent(*inputEvent) == TestAbortEvent {
			eventStr = TestCommonAbortEventStr
		} else {
			t.Errorf("unknown event")
			t.FailNow()
		}
	case TestFwaitIcon:
		if TestEvent(*inputEvent) == TestReadyEvent {
			eventStr = TestFwaitReadyEventStr
		} else if TestEvent(*inputEvent) == TestRunEvent {
			eventStr = TestFwaitRunEventStr
		} else if TestEvent(*inputEvent) == TestEndEvent {
			eventStr = TestFwaitEndEventStr
		} else if TestEvent(*inputEvent) == TestAbortEvent {
			eventStr = TestFwaitAbortEventStr
		} else {
			t.Errorf("unknown event")
			t.FailNow()
		}
	case TestFcopyIcon:
		if TestEvent(*inputEvent) == TestReadyEvent {
			eventStr = TestFcopyReadyEventStr
		} else if TestEvent(*inputEvent) == TestRunEvent {
			eventStr = TestFcopyRunEventStr
		} else if TestEvent(*inputEvent) == TestEndEvent {
			eventStr = TestFcopyEndEventStr
		} else if TestEvent(*inputEvent) == TestAbortEvent {
			eventStr = TestCommonAbortEventStr
		} else {
			t.Errorf("unknown event")
			t.FailNow()
		}
	case TestRebootIcon:
		if TestEvent(*inputEvent) == TestReadyEvent {
			eventStr = TestRebootReadyEventStr
		} else if TestEvent(*inputEvent) == TestRunEvent {
			eventStr = TestRebootRunEventStr
		} else if TestEvent(*inputEvent) == TestEndEvent {
			eventStr = TestRebootEndEventStr
		} else if TestEvent(*inputEvent) == TestAbortEvent {
			eventStr = TestRebootAbortEventStr
		}  else {
			t.Errorf("unknown event")
			t.FailNow()
		}
	case TestZabbixLinkIcon:
		if TestEvent(*inputEvent) == TestReadyEvent {
			eventStr = TestZbxLinkReadyEventStr
		} else if TestEvent(*inputEvent) == TestRunEvent {
			eventStr = TestZbxLinkRunEventStr
		} else if TestEvent(*inputEvent) == TestEndEvent {
			eventStr = TestZbxLinkEndEventStr
		} else if TestEvent(*inputEvent) == TestAbortEvent {
			eventStr = TestCommonAbortEventStr
		} else {
			t.Errorf("unknown event")
			t.FailNow()
		}
	case TestTaskIcon:
		if TestEvent(*inputEvent) == TestReadyEvent {
			eventStr = TestTaskReadyEventStr
		} else if TestEvent(*inputEvent) == TestRunEvent {
			eventStr = TestTaskRunEventStr
		} else if TestEvent(*inputEvent) == TestEndEvent {
			eventStr = TestTaskEndEventStr
		} else if TestEvent(*inputEvent) == TestAbortEvent {
			eventStr = TestCommonAbortEventStr
		} else {
			t.Errorf("unknown event")
			t.FailNow()
		}
	case TestReleaseIcon:
		if TestEvent(*inputEvent) == TestReadyEvent {
			eventStr = TestRelReadyEventStr
		} else if TestEvent(*inputEvent) == TestRunEvent {
			eventStr = TestRelRunEventStr
		} else if TestEvent(*inputEvent) == TestEndEvent {
			eventStr = TestRelEndEventStr
		} else if TestEvent(*inputEvent) == TestAbortEvent {
			eventStr = TestCommonAbortEventStr
		} else {
			t.Errorf("unknown event")
			t.FailNow()
		}
	case TestValueIcon:
		if TestEvent(*inputEvent) == TestReadyEvent {
			eventStr = TestValueReadyEventStr
		} else if TestEvent(*inputEvent) == TestRunEvent {
			eventStr = TestValueRunEventStr
		} else if TestEvent(*inputEvent) == TestEndEvent {
			eventStr = TestValueEndEventStr
		} else if TestEvent(*inputEvent) == TestAbortEvent {
			eventStr = TestCommonAbortEventStr
		} else {
			t.Errorf("unknown event")
			t.FailNow()
		}
	case TestInfoIcon:
		if TestEvent(*inputEvent) == TestReadyEvent {
			eventStr = TestInfoReadyEventStr
		} else if TestEvent(*inputEvent) == TestRunEvent {
			eventStr = TestInfoRunEventStr
		} else if TestEvent(*inputEvent) == TestEndEvent {
			eventStr = TestInfoEndEventStr
		} else if TestEvent(*inputEvent) == TestAbortEvent {
			eventStr = TestCommonAbortEventStr
		} else {
			t.Errorf("unknown event")
			t.FailNow()
		}
	case TestJobnetIcon:
		if TestEvent(*inputEvent) == TestReadyEvent {
			eventStr = TestJobnetReadyEventStr
		} else if TestEvent(*inputEvent) == TestRunEvent {
			eventStr = TestJobnetRunEventStr
		} else if TestEvent(*inputEvent) == TestEndEvent {
			eventStr = TestJobnetEndEventStr
		} else if TestEvent(*inputEvent) == TestAbortEvent {
			eventStr = TestJobnetAbortEventStr
		} else {
			t.Errorf("unknown event")
			t.FailNow()
		}
	case TestIfEndICon:
		if TestEvent(*inputEvent) == TestReadyEvent {
			eventStr = TestIfEndReadyEventStr
		} else if TestEvent(*inputEvent) == TestRunEvent {
			eventStr = TestIfEndRunEventStr
		} else if TestEvent(*inputEvent) == TestEndEvent {
			eventStr = TestIfEndEndEventStr
		} else if TestEvent(*inputEvent) == TestAbortEvent {
			eventStr = TestCommonAbortEventStr
		} else {
			t.Errorf("unknown event")
			t.FailNow()
		}
	case TestWIcon:
		if TestEvent(*inputEvent) == TestReadyEvent {
			eventStr = TestWReadyEventStr
		} else if TestEvent(*inputEvent) == TestRunEvent {
			eventStr = TestWRunEventStr
		} else if TestEvent(*inputEvent) == TestEndEvent {
			eventStr = TestWEndEventStr
		} else if TestEvent(*inputEvent) == TestAbortEvent {
			eventStr = TestCommonAbortEventStr
		} else {
			t.Errorf("unknown event")
			t.FailNow()
		}
	case TestMIcon:
		if TestEvent(*inputEvent) == TestReadyEvent {
			eventStr = TestMReadyEventStr
		} else if TestEvent(*inputEvent) == TestRunEvent {
			eventStr = TestMRunEventStr
		} else if TestEvent(*inputEvent) == TestEndEvent {
			eventStr = TestMEndEventStr
		} else if TestEvent(*inputEvent) == TestAbortEvent {
			eventStr = TestCommonAbortEventStr
		} else {
			t.Errorf("unknown event")
			t.FailNow()
		}
	case TestLoopIcon:
		if TestEvent(*inputEvent) == TestReadyEvent {
			eventStr = TestLoopReadyEventStr
		} else if TestEvent(*inputEvent) == TestRunEvent {
			eventStr = TestLoopRunEventStr
		} else if TestEvent(*inputEvent) == TestEndEvent {
			eventStr = TestLoopEndEventStr
		} else if TestEvent(*inputEvent) == TestAbortEvent {
			eventStr = TestCommonAbortEventStr
		} else {
			t.Errorf("unknown event")
			t.FailNow()
		}
	default:
		t.Errorf("unknown icon")
		t.FailNow()
	}

	err := utils.UnmarshalEventData([]byte(eventStr), &eventData)
	if err != nil {
		t.Error(err.Error())
		t.FailNow()
	}

	if len(eventData.Transfer.Files) == 0 {
		t.Errorf("transfer file is empty")
		t.FailNow()
	}

	if TestEvent(*inputEvent) == TestEndEvent {
		runData, ok :=  eventData.NextProcess.Data.(common.IconRunData)
		if !ok {
			t.Errorf("type cast to common.IconExecutionProcessData failed, type: %s", eventData.NextProcess.Data)
			t.FailNow()
		}
		
		resultMap := map[string][]byte {
			".out": nil,
			".ret": nil,
			".data": nil,
			".err": nil,
		}

		for ext := range resultMap {
			filePath := filepath.Join(clientDataPath, runData.TransactionFileId+ext)

			data, err := os.ReadFile(filePath)
			if err != nil {
				if ext == ".err" {
					resultMap[ext] = []byte(fmt.Sprintf("could not get stderr, err: %v", err))
				} else {
					fmt.Printf("could not get %s, err: %v\n", ext, err)
				}
				continue
			}
			resultMap[ext] = data
		}

		runData.ClientData = resultMap
		eventData.NextProcess.Data = runData
	}

	// prepare eventData for each icons
	switch TestIcon(*inputIcon) {
	case TestAgentlessIcon:
		if TestEvent(*inputEvent) == TestAbortEvent {
			clientData, err := getAgentlessClientData()
			if err != nil {
				t.Errorf("getAgentlessClientData() failed, err: %s", err.Error())
				t.FailNow()
			}

			processData, ok :=  eventData.NextProcess.Data.(common.IconExecutionProcessData)
			if !ok {
				t.Errorf("type cast to common.IconExecutionProcessData failed, type: %s", eventData.NextProcess.Data)
				t.FailNow()
			}

			if clientData[".clientPID"] <= 0 {
				t.Errorf("clientPID: %d cant be killed", clientData[".clientPID"])
				t.FailNow()
			} else {
				processData.RunJobData.ClientPID = clientData[".clientPID"]
			}

			if clientData[".sshClientPID"] <= 0 {
				t.Errorf("sshClientPID: %d cant be killed", clientData[".sshClientPID"])
				t.FailNow()
			} else {
				processData.SessionData.PID = clientData[".sshClientPID"]
			}

			eventData.NextProcess.Data = processData
		}
	case TestExtJobIcon:
		if TestEvent(*inputEvent) == TestReadyEvent {
			processData, ok := eventData.NextProcess.Data.(common.IconExecutionProcessData)
			if !ok {
				t.Errorf("type cast failed expected: common.IconExecutionProcessData, got: %v\n", eventData.NextProcess.Data)
				t.FailNow()
			}

			switch *inputCmdType {
			case common.JA_CMD_SLEEP:
				processData.RunJobData.Data["command_id"] = common.JA_CMD_SLEEP
			case common.JA_CMD_TIME:
				processData.RunJobData.Data["command_id"] = common.JA_CMD_TIME
			case common.JA_CMD_WEEK:
				processData.RunJobData.Data["command_id"] = common.JA_CMD_WEEK
			case common.ZABBIX_SENDER:
				processData.RunJobData.Data["command_id"] = common.ZABBIX_SENDER
			default:
				t.Error("-cmd flag is required, avaliable cmds: jacmdsleep, jacmdtime, jacmdweek, zabbix_sender")
				t.FailNow()
			}

			eventData.NextProcess.Data = processData
		} else if TestEvent(*inputEvent) == TestRunEvent {
			runData, ok := eventData.NextProcess.Data.(common.IconRunData)
			if !ok {
				t.Errorf("type cast failed expected: common.IconExecutionProcessData, got: %v\n", eventData.NextProcess.Data)
				t.FailNow()
			}

			runData.ExecProcessData.RunJobData.Data = make(map[string]interface{})

			switch *inputCmdType {
			case common.JA_CMD_SLEEP:
				runData.ExecProcessData.RunJobData.Data["command_id"] = common.JA_CMD_SLEEP
			case common.JA_CMD_TIME:
				runData.ExecProcessData.RunJobData.Data["command_id"] = common.JA_CMD_TIME
			case common.JA_CMD_WEEK:
				runData.ExecProcessData.RunJobData.Data["command_id"] = common.JA_CMD_WEEK
			case common.ZABBIX_SENDER:
				runData.ExecProcessData.RunJobData.Data["command_id"] = common.ZABBIX_SENDER
			default:
				t.Error("-cmd flag is required, avaliable cmds: jacmdsleep, jacmdtime, jacmdweek, zabbix_sender")
				t.FailNow()
			}

			eventData.NextProcess.Data = runData
		} else if TestEvent(*inputEvent) == TestAbortEvent {
			processData, ok := eventData.NextProcess.Data.(common.IconExecutionProcessData)
			if !ok {
				t.Errorf("type cast failed expected: common.IconExecutionProcessData, got: %v\n", eventData.NextProcess.Data)
				t.FailNow()
			}

			switch *inputCmdType {
			case common.JA_CMD_SLEEP:
				processData.RunJobData.Data["command_id"] = common.JA_CMD_SLEEP
			case common.JA_CMD_TIME:
				processData.RunJobData.Data["command_id"] = common.JA_CMD_TIME
			case common.JA_CMD_WEEK:
				processData.RunJobData.Data["command_id"] = common.JA_CMD_WEEK
			case common.ZABBIX_SENDER:
				processData.RunJobData.Data["command_id"] = common.ZABBIX_SENDER
			default:
				t.Error("-cmd flag is required, avaliable cmds: jacmdsleep, jacmdtime, jacmdweek, zabbix_sender")
				t.FailNow()
			}

			eventData.NextProcess.Data = processData
		}
	}

	return eventData
}
