/*
** Job Arranger for ZABBIX
** Copyright (C) 2025 Daiwa Institute of Research Ltd. All Rights Reserved.
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
**/

#include <stdio.h>
#include <vterm.h>

void fill_vterm_cells(VTerm *vterm, VTermScreenCell *out_cells, int max_cells) {
    VTermScreen *screen = vterm_obtain_screen(vterm);
     VTermState *state = vterm_obtain_state(vterm);
    VTermPos pos;
    VTermScreenCell cell;
    int rows,col, cols;
        VTermPos cursor_pos;
    vterm_get_size(vterm, &rows, &cols);
    int total = rows * cols;
    if (max_cells < total) total = max_cells;

    int index = 0;
    for (int row = 0; row < rows && index < total; row++) {
        int is_empty_row = 1; // 行が空かどうかを判定するフラグ
        vterm_state_get_cursorpos(state, &cursor_pos); // カーソル位置を取得

        for (int col = 0; col < cols && index < total; col++) {
            pos.row = row;
            pos.col = col;
            if (vterm_screen_get_cell(screen, pos, &cell) && cell.chars[0]) {
is_empty_row = 0; // 行に内容がある場合、フラグをオフ
                out_cells[index++] = cell;
// セル幅に応じてスキップ：width=2 なら次のcolを飛ばす
//cell.width == 2 の場合：全角
//cell.width == 1 の場合：半角
//cell.width == 0 の場合：継続セル（直前の全角の後半）
                if ( cell.width == 0 ) { col++; }
            }
/* 取得エラーなので、何もしない
              else {
                VTermScreenCell empty = {0};
                out_cells[index++] = empty;
            }
*/
        }
                // 空でない行のみ改行を追加
                if (!is_empty_row && col < cols ) { //行跨ぎデータ対応
                        // カーソルの行で改行を検出
                        if (cursor_pos.row == row) {
                                //printf(" <--- Cursor here\n");
                        } else {
                                VTermScreenCell empty = {0};
                                out_cells[index++] = empty;
                                //printf("\n");
                        }
                }
    }
{
                                VTermScreenCell empty = {0};
                                out_cells[index++] = empty;
                                out_cells[index++] = empty;
}
}


void process_vterm_output(VTerm *vterm,VTermScreenCell *out_cells, int max_cells) {

        VTermScreen *screen = vterm_obtain_screen(vterm);
        VTermPos pos;
        VTermScreenCell cell;
        int rows, cols;
        char mbstr[MB_CUR_MAX];  // Buffer for multibyte string

        VTermState *state = vterm_obtain_state(vterm);
        vterm_get_size(vterm, &rows, &cols);
        VTermPos cursor_pos;
        vterm_state_get_cursorpos(state, &cursor_pos); // カーソル位置を取得

        printf("\nProcessed output:\n");
        for (int row = 0; row < rows; row++) {
                int is_empty_row = 1; // 行が空かどうかを判定するフラグ
                int col;
                for (col = 0; col < cols; col++) {
                        pos.row = row;
                        pos.col = col;
if (vterm_screen_get_cell(screen, pos, &cell) && cell.chars[0]) {
is_empty_row = 0; // 行に内容がある場合、フラグをオフ

                        for (int i = 0; i < VTERM_MAX_CHARS_PER_CELL; i++) {
                                if (cell.chars[i] == 0) {
                                        break; // 文字の終端に達した場合
                                }
                                /* print_utf8(cell.chars[i]); // UTF-8として出力 */
                                char buffer[256];
                                int length = wcstombs( buffer, cell.chars, 255 );
                                if ( length >= 0 ) {
                                        buffer[length] = 0x00;
                                        printf("%s",buffer);
                                } else {
                                        printf("ERROR");
                                }
                                if ( length > 1 ) { // ２バイト以上の文字の場合、次のセルを読み飛ばす
                                        col++;
                                }

                        }
}
                }
                // 空でない行のみ改行を追加
                if (!is_empty_row && col < cols ) { //行跨ぎデータ対応
                        // カーソルの行で改行を検出
                        if (cursor_pos.row == row) {
                                printf(" <--- Cursor here\n");
                        } else {
                                printf("\n");
                        }
                }
        }
}