/*
** Job Arranger for ZABBIX
** Copyright (C) 2025 Daiwa Institute of Research Ltd. All Rights Reserved.
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
**/

package zbxlink

import "jobarranger2/src/libs/golibs/database"

type ZabbixUpdater interface {
	GetHostId(groupId string) (database.DBresult, error)
	SetHostStatus(hostId string, status int) error
	GetHostStatus(hostId string) (database.DBresult, error)
	SetItemStatus(itemId string, status int) error
	GetItemStatus(itemId string) (database.DBresult, error)
	GetItemData(getItemId string) (database.DBresult, error)
	GetHistoryData(getItemId string, valueType int) (database.DBresult, error)
	SetTriggerStatus(triggerId string, status int) error
	GetTriggerStatus(triggerId string) (database.DBresult, error)
}
