package main

import (
	"fmt"
	"os"
	"reflect"

	"jobarranger2/src/libs/golibs/config_reader/agent"
	"jobarranger2/src/libs/golibs/config_reader/conf"
	"jobarranger2/src/libs/golibs/config_reader/server"
)

func printStructValues(s any) {
	val := reflect.ValueOf(s)
	typ := reflect.TypeOf(s)

	for i := range val.NumField() {
		field := typ.Field(i)
		value := val.Field(i)

		fmt.Printf("%s: %v\n", field.Name, value.Interface())
	}
}

func main() {

	// AGENT config load & check (LINUX)
	configPath := "/etc/jobarranger/jobarg_agentd.conf.test"

	fmt.Println("============== AGENT CONFIG (LINUX) =================")

	// Loading the config and stored it in agent.Options (AgentOptions)
	err := conf.Load(configPath, &agent.Options)
	if err != nil {
		fmt.Fprintf(os.Stderr, "failed to parse the config: %v\n", err)
		os.Exit(1)
	}

	printStructValues(agent.Options)

	// SERVER config load & check
	fmt.Println("============== SERVER CONFIG =================")
	serverConfigPath := "/etc/jobarranger/jobarg_server.conf.test"

	// Loading the config and stored it in server.Options (ServerOptions)
	err = conf.Load(serverConfigPath, &server.Options)
	if err != nil {
		fmt.Fprintf(os.Stderr, "failed to parse the config: %v\n", err)
		os.Exit(1)
	}

	printStructValues(server.Options)

}
