package main

import (
	"fmt"
	"os"
	"reflect"

	"jobarranger2/src/libs/golibs/config_reader/agent"
	"jobarranger2/src/libs/golibs/config_reader/conf"
)

func printStructValues(s any) {
	val := reflect.ValueOf(s)
	typ := reflect.TypeOf(s)

	for i := range val.NumField() {
		field := typ.Field(i)
		value := val.Field(i)

		fmt.Printf("%s: %v\n", field.Name, value.Interface())
	}
}

func main() {

	// AGENT config load & check (WINDOWS)
	configPath := "C:\\Program Files\\Job Arranger\\Job Arranger Agent\\conf\\jobarg_agentd.conf"

	fmt.Println("============== AGENT CONFIG (WINDOWS) =================")

	// Loading the config and stored it in agent.Options (AgentOptions)
	err := conf.Load(configPath, &agent.Options)
	if err != nil {
		fmt.Fprintf(os.Stderr, "failed to parse the config: %v\n", err)
		os.Exit(1)
	}

	printStructValues(agent.Options)

}
