/*
** Job Arranger for ZABBIX
** Copyright (C) 2025 Daiwa Institute of Research Ltd. All Rights Reserved.
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
**/
package event

import (
	db "jobarranger2/src/libs/golibs/database"
)

type EventData struct {
	Event       EventInfo       `json:"event"`
	NextProcess ProcessInfo     `json:"next_process"`
	Queries     []string        `json:"queries"`
	Transfer    TransferSection `json:"transfer"`
}

type EventInfo struct {
	Name      string `json:"name"`
	UniqueKey string `json:"unique_key"`
}

type ProcessInfo struct {
	Name string         `json:"name"`
	Data map[string]any `json:"data"`
}

type FileEntry struct {
	Source      string `json:"source"`
	Destination string `json:"destination"`
}

type UDSInfo struct {
	SocketPath string `json:"socket_path"`
}

type TransferSection struct {
	Files []FileEntry `json:"files"`
	UDS   UDSInfo     `json:"uds"`
}

type Data struct {
	EventData EventData
	DBConn    db.DBConnection
}
