//go:build windows

/*
** Job Arranger for ZABBIX
** Copyright (C) 2025 Daiwa Institute of Research Ltd. All Rights Reserved.
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
**/

package flock

import (
	"golang.org/x/sys/windows"
)

const (
	LOCKFILE_EXCLUSIVE_LOCK = 0x00000002
	LOCKFILE_FAIL_ON_LOCK   = 0x00000001
)

// LockFileFD locks a file given its file descriptor (Windows) using dynamic flags.
func LockFile(fd int, flags uint32) error {
	handle := windows.Handle(uintptr(fd))
	var overlapped windows.Overlapped

	// Lock 1 byte from offset 0 — enough to block others
	return windows.LockFileEx(
		handle,
		flags,
		0,    // Reserved
		1, 0, // Lock 1 byte starting at offset 0
		&overlapped,
	)
}

// UnlockFileFD unlocks a previously locked file using its file descriptor (Windows).
func UnlockFile(fd int) error {
	handle := windows.Handle(uintptr(fd))
	var overlapped windows.Overlapped

	return windows.UnlockFileEx(handle, 0, 1, 0, &overlapped)
}
