package main

import (
	"fmt"
	"os"

	"jobarranger2/src/libs/golibs/logger/logger"
)

func main() {
	// Necessary values to initialize logger
	logFilePath := "C:\\Program Files\\Job Arranger\\Job Arranger Agent\\logs\\jobarg_agentd.log"
	messageFilePath := "C:\\Program Files\\Job Arranger\\Job Arranger Agent\\locale\\logmessage_agent.txt"
	logTypeStr := "file"
	maxLogFileSize := 10 * 1024 * 1024 // 10 MB
	debugLevel := 4

	// Initialize logger
	err := logger.InitLogger(logFilePath, messageFilePath, logTypeStr, maxLogFileSize, debugLevel, logger.TargetTypeAgent)
	if err != nil {
		fmt.Fprintf(os.Stderr, "failed to get logger: %v\n", err)
		os.Exit(1)
	}

	text := `Line 1: Hello, world!
	Line 2: This is a Go program.
	Line 3: It prints multiple lines.
	Line 4: Done!Line 2: This is a Go program.
	Line 3: It prints multiple lines.Line 2: This is a Go program.
	Line 3: It prints multiple lines.Line 2: This is a Go program.
	Line 3: It prints multiple lines.`

	// cmd := exec.Command("C:\\Program Files\\Job Arranger\\Job Arranger Agent\\write_log_child.exe")
	// if err := cmd.Start(); err != nil {
	// 	log.Fatalf("failed to start the child: %v", err)
	// }

	// // Write logs
	// for {
	// 	_, err = logger.WriteLog("JAAGENTHOUSEKEEPER400001", "main", 24, 24)

	// 	if err != nil {
	// 		fmt.Fprintf(os.Stderr, "failed to write log: %v\n", err)
	// 	}

	// 	time.Sleep(400 * time.Millisecond)
	// }

	logger.WriteLog("JAAGENTHOUSEKEEPER200001", "main", "test.txt", text)

}
