/*
** Job Arranger for ZABBIX
** Copyright (C) 2025 Daiwa Institute of Research Ltd. All Rights Reserved.
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
**/
package uds

import (
	"errors"
	"net"

	"jobarranger2/src/libs/golibs/common"
)

type UdsServer struct {
	listener net.Listener
}

func CreateUdsServer(socketPath string) (*UdsServer, error) {
	server, err := net.Listen("unix", socketPath)
	if err != nil {
		return nil, err
	}

	return &UdsServer{
		listener: server,
	}, nil
}

func (server *UdsServer) Accept() (*common.NetConnection, error) {
	if server.listener == nil {
		return nil, errors.New("listener is nil")
	}

	conn, err := server.listener.Accept()
	if err != nil {
		return nil, err
	}

	return &common.NetConnection{
		Conn: conn,
	}, nil
}

func (server *UdsServer) Close() error {
	return server.listener.Close()
}
