#!/bin/bash

# Check if user supplied an argument
if [ $# -ne 1 ]; then
    echo "Usage: $0 <n_hours>"
    exit 1
fi

# Validate that the input is a positive integer or float
if ! [[ "$1" =~ ^[0-9]+([.][0-9]+)?$ ]]; then
    echo "Error: '$1' is not a valid number of hours"
    exit 1
fi

# Convert hours to seconds
N_HOURS=$1
INTERVAL_SECONDS=$(echo "$N_HOURS * 3600" | bc)

# Main loop
while true; do
    echo "Running task at $(date)"
    
    # Put your task here
    # Example: run a script or command
    # ./my_task.sh
    echo "git fetching all..."
    git fetch --all

    echo "Sleeping for $N_HOURS hour(s) ($INTERVAL_SECONDS seconds)..."
    sleep $INTERVAL_SECONDS
done
