<?php
namespace Modules\JazManager\Actions;

use CController;
use CControllerResponseRedirect;
use CControllerResponseFatal;
use CCookieHelper;
use CView;

class JazManagerApp extends CController
{

    public function init(): void
    {
        $this->disableCsrfValidation();
    }

    protected function checkInput(): bool
    {
        return true;
    }

    protected function checkPermissions(): bool
    {
        return true;
    }

    protected function doAction(): void
    {
        $config = __DIR__ . "/../config/jam.module.config.php";
        $session = json_decode(base64_decode(CCookieHelper::get(ZBX_SESSION_NAME)), true);
        $encodeSession = base64_encode(json_encode($session['sessionid']));
        $urlEncodedSession = urlencode($encodeSession);

        // Include config to get JAM_URL, if it exists
        if (file_exists($config)) {
            require_once $config;

            if (defined('JAM_URL')) {
                $jamUrl = rtrim(JAM_URL, '/');

                // Redirect with the encoded session ID as token
                $_SESSION['loading'] = true;

                $this->displayLoader();

                ob_flush();
                flush();

                         // If the response type is Ok, redirect the user
                echo '
                <script>
                    setTimeout(function() {
                window.location.href = "' . $jamUrl . '/redirect?token=' . $urlEncodedSession . '";
                    }, 300);
                </script>';
                $_SESSION['loading'] = false;
            } else {
                echo (new CView('jaz.manager.error', [
                    'errorMessage' => 'JAM_URL not defined in config.'
                ]))->getOutput();
            }
        } else {
            echo (new CView('jaz.manager.error', [
                'errorMessage' => 'Configuration file not found.'
            ]))->getOutput();
        }
    }

    private function displayLoader(): void
    {
        echo '
    <!DOCTYPE html>
    <html lang="en">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Redirecting</title>
        <style>

html,body{
background-color:white !important;
}
        body {
top:40%;
left:45%;

display:flex; 
    margin: 0 ;
    padding: 0 ;
    font-family: Arial, sans-serif;
  
        height: 100vh ;
    overflow: hidden;
}

.msg-global.msg-bad {
        display: none;


    }

.loader {
   border: 8px solid rgba(0, 0, 0, 0.1);
            border-radius: 50%;
            border-top: 8px solid #007bff;
            width: 70px;
            height:70px;
            animation: spin 1.5s linear infinite;
            margin-bottom: 20px;
            }
 .loader {
    box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
  }

.content {

margin-left:2rem;
margin-top:2.5%;

    text-align: center ;
    font-size: 16px ;
    color: #333 ;
}

.content h2 {
margin-top:5rem;
font-weight: 600;

    font-size: 24px ;
    margin: 0;
}

        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

         </style>    </head>
    <body>
        <div class="loader">

</div>
        <div class="content">
            <h2>Redirecting to Job Arranger...</h2>
        </div>
    </body>
    </html>
    ';
    }
}