import { createSlice } from "@reduxjs/toolkit";

const initialState = {
  timeZone: "",
  standardTime: "",
};

export const TimeZoneSlice = createSlice({
  name: "JobExecutionManagement",
  initialState,
  reducers: {
    setTimeZone: (state, action) => {
      state.timeZone = action.payload;
    },
    setStandardTime: (state, action) => {
      state.standardTime = action.payload
    }
  },
});

export const { setTimeZone, setStandardTime } =
  TimeZoneSlice.actions;

export default TimeZoneSlice.reducer;
