import React, { useState } from "react";
import { Form, Input, Select, Checkbox } from "antd";
import { REGEX_PATTERM } from "../../constants";

const formItemLayout = {
    labelCol: {
        xs: {
            span: 25,
        },
        sm: {
            span: 5,
        },
    },
    wrapperCol: {
        xs: {
            span: 25,
        },
        sm: {
            span: 12,
        },
    },

};

function TLSConnection({ form, onFinish, initialValues }) {
  const jaDbEncryption = Form.useWatch("JA_DB_ENCRYPTION", form);
  const dbEncryption = Form.useWatch("DB_ENCRYPTION", form);

  return (
    <Form
      {...formItemLayout}
      labelAlign="left"
      style={{ marginLeft: '24px', marginRight:'10px', marginTop: '10px', marginBottom: '10px' }}
      form={form}
      onFinish={onFinish}
      initialValues={initialValues}
      scrollToFirstError
    >
      <h3 className="tabHead">Configure TLS connection:</h3>

      <p className="info">
        Please configure TLS manually and set the required parameters.
        Press "Next step" when done.
      </p>

      {/* Scrollable area */}
      <div
        style={{
          maxHeight: "400px",
          overflow: "auto",
          paddingRight: "10px",
          marginTop: "10px",
        }}
      >
        {/* ================= Job Arranger TLS ================= */}
        <div style={{ fontWeight: "bold", fontSize: "15px", marginTop: "5px" }}>
          Job Arranger TLS
        </div>

        <Form.Item
          className="tlscon-form-item"
          name="JA_DB_ENCRYPTION"
          valuePropName="checked"
        >
          <Checkbox>Enable TLS Encryption</Checkbox>
        </Form.Item>

        {jaDbEncryption && (
          <>
            <Form.Item
              className="tlscon-form-item"
              name="JA_DB_CA_FILE"
              label="CA File"
              rules={[{ required: true, message: "Please input CA FILE!" }]}
            >
              <Input />
            </Form.Item>

            <Form.Item
              className="tlscon-form-item"
              name="JA_DB_KEY_FILE"
              label="Key File"
            >
              <Input />
            </Form.Item>

            <Form.Item
              className="tlscon-form-item"
              name="JA_DB_CERT_FILE"
              label="Cert File"
            >
              <Input />
            </Form.Item>

            <Form.Item
              className="tlscon-form-item"
              name="JA_DB_VERIFY_HOST"
              label="Verify Host"
              valuePropName="checked"
            >
              <Checkbox />
            </Form.Item>

            <Form.Item
              className="tlscon-form-item"
              name="JA_DB_CIPHER_LIST"
              label="Cipher List"
              extra="(For multiple cipher lists, separate with a semicolon)"
            >
              <Input />
            </Form.Item>
          </>
        )}


        {/* ================= Zabbix TLS ================= */}
        <div
          style={{
            fontWeight: "bold",
            fontSize: "15px",
            marginTop: "15px",
          }}
        >
          Zabbix TLS
        </div>

        <Form.Item
          className="tlscon-form-item"
          name="DB_ENCRYPTION"
          valuePropName="checked"
        >
          <Checkbox>Enable TLS Encryption</Checkbox>
        </Form.Item>

        {dbEncryption && (
          <>
            <Form.Item
              className="tlscon-form-item"
              name="DB_CA_FILE"
              label="CA File"
              rules={[{ required: true, message: "Please input CA FILE!" }]}
            >
              <Input />
            </Form.Item>

            <Form.Item
              className="tlscon-form-item"
              name="DB_KEY_FILE"
              label="Key File"
            >
              <Input />
            </Form.Item>

            <Form.Item
              className="tlscon-form-item"
              name="DB_CERT_FILE"
              label="Cert File"
            >
              <Input />
            </Form.Item>

            <Form.Item
              className="tlscon-form-item"
              name="DB_VERIFY_HOST"
              label="Verify Host"
              valuePropName="checked"
            >
              <Checkbox />
            </Form.Item>

            <Form.Item
              className="tlscon-form-item"
              name="DB_CIPHER_LIST"
              label="Cipher List"
              extra="(For multiple cipher lists, separate with a semicolon)"
            >
              <Input />
            </Form.Item>
          </>
        )}

      </div>
    </Form>
  );
}

export default TLSConnection;
