%define         _localsbindir /usr/local/sbin
%define         _localbinjobargdir /usr/local/bin/%{name}
%define         debug_package %{nil}
%define         _build_id_links none

Name:           jobarranger
Version:        %{version}
Release:        1%{?dist}
Summary:        Open-source job controller solution for your IT infrastructure
Vendor:         Daiwa Institute of Research Ltd.

Group:          Applications/Internet
License:        GPL
URL:            https://www.%{name}.info/redmine/

Buildroot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

%description
Job Arranger for ZABBIX.

%package utils
Summary:         Job Arranger Utils
Group:           Applications/Internet
Requires(pre):   /usr/sbin/useradd

%description utils
The Job Arranger utils, to be installed on systems.

%prep
cp %{jobarg_source}/AUTHORS .
cp %{jobarg_source}/README.md .
cp %{jobarg_source}/COPYING .
cp %{jobarg_source}/ChangeLog .

%install
rm -rf $RPM_BUILD_ROOT
cd  %{jobarg_source}
make DESTDIR=$RPM_BUILD_ROOT install

%clean
rm -rf $RPM_BUILD_ROOT

%pre utils
/usr/sbin/useradd -c "Job Arranger user" \
        -s /sbin/nologin -r -d %{_sysconfdir}/zabbix zabbix 2> /dev/null || :

%post utils
if [ $1 -eq 1 ]; then
  if [ ! -f %{_localsbindir}/jobarg_release ]; then
     ln -s %{_localbinjobargdir}/jobarg_release %{_localsbindir}/jobarg_release || :
  fi
  if [ ! -f %{_localsbindir}/jobarg_exec ]; then
     ln -s %{_localbinjobargdir}/jobarg_exec %{_localsbindir}/jobarg_exec || :
  fi
  if [ ! -f %{_localsbindir}/jobarg_get ]; then
     ln -s %{_localbinjobargdir}/jobarg_get %{_localsbindir}/jobarg_get || :
  fi
  if [ ! -f %{_localsbindir}/jobarg_joblogput ]; then
     ln -s %{_localbinjobargdir}/jobarg_joblogput %{_localsbindir}/jobarg_joblogput || :
  fi
fi

%preun utils
if [ $1 -eq 0 ]; then
  if [ -L %{_localsbindir}/jobarg_release ]; then
    rm -f %{_localsbindir}/jobarg_release || :
  fi
  if [ -L %{_localsbindir}/jobarg_exec ]; then
    rm -f %{_localsbindir}/jobarg_exec || :
  fi
  if [ -L %{_localsbindir}/jobarg_get ]; then
    rm -f %{_localsbindir}/jobarg_get || :
  fi
  if [ -L %{_localsbindir}/jobarg_joblogput ]; then
    rm -f %{_localsbindir}/jobarg_joblogput || :
  fi
fi

%files utils
%defattr(-,root,root,-)
%doc AUTHORS README.md COPYING ChangeLog
%{_mandir}/man1/jobarg_exec*
%{_mandir}/man1/jobarg_get*
%{_mandir}/man1/jobarg_joblogput*
%{_mandir}/man1/jobarg_release*
%attr(0755,zabbix,zabbix) %{_localbinjobargdir}/jobarg_release
%attr(0755,zabbix,zabbix) %{_localbinjobargdir}/jobarg_exec
%attr(0755,zabbix,zabbix) %{_localbinjobargdir}/jobarg_get
%attr(0755,zabbix,zabbix) %{_localbinjobargdir}/jobarg_joblogput

%changelog
* Sun Oct 12 2025 Copyright Daiwa Institute of Research Ltd. All Rights Reserved. <https://www.%{name}.info/jaz/jaz_release_note.html> %{version}
- Lastest RPM relese