/*
** Job Arranger for ZABBIX
** Copyright (C) 2025 Daiwa Institute of Research Ltd. All Rights Reserved.
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
**/

package main

const (
	JA_JOBNET_STATUS_BEGIN = iota
	JA_JOBNET_STATUS_READY
	JA_JOBNET_STATUS_RUN
	JA_JOBNET_STATUS_END
	JA_JOBNET_STATUS_RUNERR
	JA_JOBNET_STATUS_ENDERR
	JA_JOBNET_STATUS_STOPPING
	JA_JOBNET_STATUS_ENDING
)

type JobStatusSummary int

const (
	JA_SUMMARY_JOB_STATUS_NORMAL  JobStatusSummary = 0
	JA_SUMMARY_JOB_STATUS_TIMEOUT JobStatusSummary = 1
	JA_SUMMARY_JOB_STATUS_ERROR   JobStatusSummary = 2
)

const (
	JA_JOBNET_RUN_TYPE_NORMAL = iota
	JA_JOBNET_RUN_TYPE_IMMEDIATE
	JA_JOBNET_RUN_TYPE_WAIT
	JA_JOBNET_RUN_TYPE_TEST
	JA_JOBNET_RUN_TYPE_SCHEDULED
	JA_JOBNET_RUN_TYPE_JOBALONE
)

const (
	JA_JOBNET_MULTIPLE_YES = iota
	JA_JOBNET_MULTIPLE_SKIP
	JA_JOBNET_MULTIPLE_WAIT
)

const (
	JA_JOBNET_MAIN_FLAG_MAIN = iota
	JA_JOBNET_MAIN_FLAG_SUB
)

/* job status */
const (
	JA_JOB_STATUS_BEGIN = iota
	JA_JOB_STATUS_READY
	JA_JOB_STATUS_RUN
	JA_JOB_STATUS_END
	JA_JOB_STATUS_RUNERR
	JA_JOB_STATUS_ENDERR
	JA_JOB_STATUS_ABORT
)

const (
	JOBNET_ID                = "JOBNET_ID"
	JOBNET_NAME              = "JOBNET_NAME"
	USER_NAME                = "USER_NAME"
	MANAGEMENT_ID            = "MANAGEMENT_ID"
	JOBNET_BOOT_TIME         = "JOBNET_BOOT_TIME"
	JOBNET_BOOT_TIME_TZ      = "JOBNET_BOOT_TIME_TZ"
	JOBNET_SCHEDULED_TIME    = "JOBNET_SCHEDULED_TIME"
	JOBNET_SCHEDULED_TIME_TZ = "JOBNET_SCHEDULED_TIME_TZ"
	CURRENT_TIME             = "CURRENT_TIME"
	CURRENT_TIME_TZ          = "CURRENT_TIME_TZ"
	TIMEZONE                 = "TIMEZONE"
)

/* start pending flag */
const (
	JA_SUMMARY_START_PENDING_NONE = iota
	JA_SUMMARY_START_PENDING_ON
	JA_SUMMARY_START_PENDING_OFF
)

const (
	JA_JOBNET_ABORT_FLAG_OFF = iota
	JA_JOBNET_ABORT_FLAG_ON
)
