package main

import (
	"encoding/json"

	"jobarranger2/src/libs/golibs/common"
	"jobarranger2/src/libs/golibs/logger/logger"
	"jobarranger2/src/libs/golibs/utils"
)

const (
	NEW            = "new"
	DUPLICATE_DATA = "DUPLICATE DATA"
	DATA_RECOVERY  = "Data recovery"
)

var TrapperLogger logger.Logging

func StartDaemonWorkers(data common.Data) {}

func ProcessEventData(data common.Data) {
	funcname := "ProcessEventData"
	TrapperLogger.JaLog("JATRAPPERMANAGER400001", `TrapperManager's `+funcname)
	if data.NetConn == nil {
		TrapperLogger.JaLog("JATRAPPER200039")
		return
	}

	var eventData common.EventData
	err := utils.UnmarshalEventData(data.EventData, &eventData)
	if err != nil {
		TrapperLogger.JaLog("JATRAPPERMANAGER000001")
		tcpObj := new(common.TCPMessage)
		err := json.Unmarshal(data.EventData, tcpObj)
		if err != nil {
			TrapperLogger.JaLog("JATRAPPERMANAGER200001", funcname, err.Error())
			return
		}

		eventData = common.EventData{
			TCPMessage: tcpObj,
		}
	}
	handler := EventHandlerFactory()
	_ = handler.Handle(eventData, data.NetConn) // You can handle the error as needed

	TrapperLogger.JaLog("JATRAPPERMANAGER400008", `TrapperManager's `+funcname)
}
