#include "sysinc.h"

#ifndef COMMON_H
#define COMMON_H

extern char *jaz_optarg;
extern char *CONFIG_JA_EXECUTION_USER;
extern const char *progname;
extern int JAZ_TASK_FLAG_FOREGROUND;

struct jaz_option
{
  const char *name;
  /* has_arg can't be an enum because some compilers complain about
     type mismatches in all the code that assumes it is an int.  */
  int has_arg;
  int *flag;
  int val;
};

typedef enum
{
	JAZ_TASK_CONFIG_CACHE_RELOAD
}
jaz_task_t;

#define	SUCCEED		0
#define	FAIL       -1

#define JA_SERVERID_LEN			32+1

#define JA_PROCESS_TYPE_UNKNOWN		255

#define JAZ_PROCESS_TYPE_CONFSYNCER	18

/* daemon type */
#define JAZ_DAEMON_TYPE_SERVER		0x01
#define JAZ_DAEMON_TYPE_PROXY_PASSIVE	0x04

#ifndef NULL
#define NULL 0
#endif

#define jaz_free(ptr)		\
				\
do				\
{				\
	if (ptr)		\
	{			\
		free(ptr);	\
		ptr = NULL;	\
	}			\
}				\
while (0)

#define jaz_fclose(file)	\
				\
do				\
{				\
	if (file)		\
	{			\
		fclose(file);	\
		file = NULL;	\
	}			\
}				\
while (0)

#define EOF (-1)

#define jaz_strdup(old, str)		jaz_strdup2(__FILE__, __LINE__, old, str);
char *jaz_strdup2(const char *file, int line, char *old, const char *str);

const char	*get_program_name(const char *path);
void usage(void);

int jaz_getopt_long (int argc, char **argv, const char *optstring,
	const struct jaz_option *longopts, int *longind,int long_only);

void	ja_wakeup();

int	JAZ_MAIN_ENTRY();

void jaz_on_exit();

#endif