/*
** Job Arranger for ZABBIX
** Copyright (C) 2025 Daiwa Institute of Research Ltd. All Rights Reserved.
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
**/
package common

import (
	"path/filepath"

	"jobarranger2/src/libs/golibs/config_reader/server"
)

var TransactionFolders = map[EventName]FileTransfer{
	// jobnet related events
	EventJobnetLoad: {
		Source:      filepath.Join(DBSyncerManagerFolder, "in/"),
		Destination: filepath.Join(JobnetManagerFolder, "in/"),
	}, EventStandAloneJob: {
		Source:      filepath.Join(JobnetManagerFolder, "in/"),
		Destination: "",
	}, EventJobnetRunError: {
		Source:      filepath.Join(JobnetManagerFolder, "in/"),
		Destination: "",
	}, EventJobnetTimeout: {
		Source:      filepath.Join(JobnetManagerFolder, "in/"),
		Destination: "",
	}, EventJobnetEnd: {
		Source:      filepath.Join(DBSyncerManagerFolder, "in/"),
		Destination: "",
	}, EventJobnetRun: {
		Source:      filepath.Join(DBSyncerManagerFolder, "in/"),
		Destination: filepath.Join(FlowManagerFolder, "in/"),
	}, EventJobnetStopping: {
		Source:      filepath.Join(DBSyncerManagerFolder, "in/"),
		Destination: filepath.Join(FlowManagerFolder, "in/"),
	}, EventJobnetEnding: {
		Source:      filepath.Join(DBSyncerManagerFolder, "in/"),
		Destination: "",
	}, EventSubJobnetStatusChange: {
		Source:      filepath.Join(DBSyncerManagerFolder, "in/"),
		Destination: filepath.Join(FlowManagerFolder, "in/"),
	}, EventJobnetStatusChange: {
		Source:      filepath.Join(DBSyncerManagerFolder, "in/"),
		Destination: "",
	},
	// jobnet interaction events
	EventJobnetHold: {
		Source:      filepath.Join(JobnetManagerFolder, "in/"),
		Destination: "",
	},
	EventJobnetUnhold: {
		Source:      filepath.Join(JobnetManagerFolder, "in/"),
		Destination: "",
	}, EventScheduleDelete: {
		Source:      filepath.Join(JobnetManagerFolder, "in/"),
		Destination: "",
	}, EventJobnetStop: {
		Source:      filepath.Join(JobnetManagerFolder, "in/"),
		Destination: "",
	}, EventJobnetIconStop: {
		Source:      filepath.Join(JobnetManagerFolder, "in/"),
		Destination: "",
	}, EventDelayedStart: {
		Source:      filepath.Join(JobnetManagerFolder, "in/"),
		Destination: "",
	}, EventScheduleUpdate: {
		Source:      filepath.Join(JobnetManagerFolder, "in/"),
		Destination: "",
	}, EventScheduleDeleteDBSync: {
		Source:      filepath.Join(DBSyncerManagerFolder, "in/"),
		Destination: "",
	}, EventScheduleHoldDBSync: {
		Source:      filepath.Join(DBSyncerManagerFolder, "in/"),
		Destination: "",
	}, EventScheduleReleaseDBSync: {
		Source:      filepath.Join(DBSyncerManagerFolder, "in/"),
		Destination: "",
	}, EventScheduleUpdateDBSync: {
		Source:      filepath.Join(DBSyncerManagerFolder, "in/"),
		Destination: "",
	},

	// icon related events
	EventIconReady: {
		Source:      filepath.Join(DBSyncerManagerFolder, "in/"),
		Destination: filepath.Join(IconExecManagerFolder, "in/"),
	}, EventIconHold: {
		Source:      filepath.Join(DBSyncerManagerFolder, "in/"),
		Destination: "",
	}, EventIconRun: {
		Source:      filepath.Join(DBSyncerManagerFolder, "in/"),
		Destination: "?",
	}, EventIconExecEnd: {
		Source:      filepath.Join(IconExecManagerFolder, "in/"),
		Destination: "",
	}, EventIconAbort: {
		Source:      filepath.Join(DBSyncerManagerFolder, "in/"),
		Destination: filepath.Join(IconExecManagerFolder, "in/"),
	}, EventIconTimeout: {
		Source:      filepath.Join(IconResultManagerFolder, "in/"),
		Destination: "",
	}, EventIconTimeoutAbort: {
		Source:      filepath.Join(IconResultManagerFolder, "in/"),
		Destination: "",
	}, EventIconExecRun: {
		Source:      filepath.Join(IconExecManagerFolder, "in/"),
		Destination: "",
	}, EventMIconRun: {
		Source:      filepath.Join(DBSyncerManagerFolder, "in/"),
		Destination: filepath.Join(FlowManagerFolder, "in/"),
	}, EventOneWayIconRun: {
		Source:      filepath.Join(DBSyncerManagerFolder, "in/"),
		Destination: filepath.Join(IconResultManagerFolder, "in/"),
	}, EventTwoWayIconRun: {
		Source:      filepath.Join(DBSyncerManagerFolder, "in/"),
		Destination: "",
	}, EventJobnetIconRun: {
		Source:      filepath.Join(DBSyncerManagerFolder, "in/"),
		Destination: filepath.Join(JobnetManagerFolder, "in/"),
	}, EventIconResultEnd: {
		Source:      filepath.Join(DBSyncerManagerFolder, "in/"),
		Destination: filepath.Join(FlowManagerFolder, "in/"),
	}, EventIconResultRunErr: {
		Source:      filepath.Join(DBSyncerManagerFolder, "in/"),
		Destination: filepath.Join(FlowManagerFolder, "in/"),
	}, EventIconResultEndErr: {
		Source:      filepath.Join(DBSyncerManagerFolder, "in/"),
		Destination: filepath.Join(FlowManagerFolder, "in/"),
	}, EventIconTimeoutStop: {
		Source:      filepath.Join(DBSyncerManagerFolder, "in/"),
		Destination: filepath.Join(FlowManagerFolder, "in/"),
	}, EventIconTimeoutWarning: {
		Source:      filepath.Join(DBSyncerManagerFolder, "in/"),
		Destination: filepath.Join(JobnetManagerFolder, "in/"),
	}, EventEndCountPlus: {
		Source:      filepath.Join(DBSyncerManagerFolder, "in/"),
		Destination: filepath.Join(FlowManagerFolder, "in/"),
	}, EventIconRetry: {
		Source:      filepath.Join(FlowManagerFolder, "in/"),
		Destination: "",
	}, EventExtIconFinish: {
		Source:      filepath.Join(IconResultManagerFolder, "in/"),
		Destination: "",
	}, EventIconResultUpdate: {
		Source:      filepath.Join(IconResultManagerFolder, "in/"),
		Destination: "",
	}, EventFlowRunErr: {
		Source:      filepath.Join(DBSyncerManagerFolder, "in/"),
		Destination: filepath.Join(IconResultManagerFolder, "in/"),
	}, EventEndIconEnd: {
		Source:      filepath.Join(JobnetManagerFolder, "in/"),
		Destination: "",
	}, EventExecCheckAgent: {
		Source:      filepath.Join(IconExecManagerFolder, "in/"),
		Destination: "",
	}, EventExecCheckLocal: {
		Source:      filepath.Join(IconExecManagerFolder, "in/"),
		Destination: "",
	}, EventFlowCheckLocal: {
		Source:      filepath.Join(FlowManagerFolder, "in/"),
		Destination: "",
	}, EventFlowCheckAgent: {
		Source:      filepath.Join(FlowManagerFolder, "in/"),
		Destination: "",
	},

	// User Action events (Icon)
	EventIconUnhold: {
		Source:      filepath.Join(FlowManagerFolder, "in/"),
		Destination: "",
	}, EventIconSkip: {
		Source:      filepath.Join(DBSyncerManagerFolder, "in/"),
		Destination: filepath.Join(IconResultManagerFolder, "in/"),
	}, EventIconStop: {
		Source:      filepath.Join(FlowManagerFolder, "in/"),
		Destination: "",
	}, EventIconRerun: {
		Source:      filepath.Join(FlowManagerFolder, "in/"),
		Destination: "",
	}, EventIconRunErrSkip: {
		Source:      filepath.Join(JobnetManagerFolder, "in/"),
		Destination: "",
	}, EventIconHoldSkip: {
		Source:      filepath.Join(FlowManagerFolder, "in/"),
		Destination: "",
	}, EventIconRerunStatusSync: {
		Source:      filepath.Join(JobnetManagerFolder, "in/"),
		Destination: "",
	}, EventJobnetDelayError: {
		Source:      filepath.Join(DBSyncerManagerFolder, "in/"),
		Destination: "",
	}, EventFlowIconSkip: {
		Source:      filepath.Join(FlowManagerFolder, "in/"),
		Destination: "",
	},

	// Agent Job Run Events
	EventAgentJobRun: {
		Source:      filepath.Join(AgentManagerFolder, "in/"),
		Destination: "",
	}, EventAgentJobRunResp: {
		Source:      "",
		Destination: "",
	}, EventAgentJobRan: {
		Source:      filepath.Join(AgentManagerFolder, "in/"),
		Destination: "",
	},

	// Logging insert
	EventInsertLogTable: {
		Source:      filepath.Join(DBSyncerManagerFolder, "in/"),
		Destination: "",
	},
	EventInsertSendMsg: {
		Source:      filepath.Join(NotificationManagerFolder, "in/"),
		Destination: "",
	},

	// zabbix send info insert
	EventInsertSendMsgTable: {
		Source:      filepath.Join(DBSyncerManagerFolder, "in/"),
		Destination: "",
	},

	// DB query failure events
	EventDBJobnetRunQueryFailure: {
		Source:      filepath.Join(JobnetManagerFolder, "in"),
		Destination: "",
	},
	EventDBIconQueryFailure: {
		Source:      filepath.Join(IconResultManagerFolder, "in"),
		Destination: "",
	},
	EventFlowJobnetIconStatusChange: {
		Source:      filepath.Join(DBSyncerManagerFolder, "in"),
		Destination: filepath.Join(JobnetManagerFolder, "in"),
	},
}

type SocketPaths struct {
	SocketPath1 string
	SocketPath2 string
}

func GetCurrentCommunicationSocketPath(event EventName) string {
	base := server.Options.UnixSockParentDir

	switch event {
	case EventJobnetLoad, EventJobnetRun,
		EventJobnetStopping, EventJobnetEnding, EventJobnetEnd,
		EventJobnetHold, EventIconReady, EventIconRun, EventIconHold,
		EventIconAbort, EventIconResultEnd, EventJobnetIconRun, EventFlowRunErr,
		EventIconResultRunErr, EventIconResultEndErr, EventIconTimeoutWarning, EventIconTimeoutStop,
		EventEndCountPlus, EventIconSkip, EventInsertLogTable,
		EventInsertSendMsgTable, EventOneWayIconRun, EventTwoWayIconRun, EventJobnetStatusChange,
		EventScheduleUpdateDBSync, EventMIconRun, EventFlowJobnetIconStatusChange,
		EventJobnetDelayError:
		return filepath.Join(base, DBSyncerManagerSockFile)

	case EventStandAloneJob, EventJobnetRunError, EventJobnetTimeout, EventJobnetUnhold,
		EventScheduleDelete, EventJobnetStop, EventJobnetIconStop, EventDelayedStart,
		EventScheduleUpdate, EventEndIconEnd, EventDBJobnetRunQueryFailure, EventIconRunErrSkip,
		EventIconRerunStatusSync:
		return filepath.Join(base, JobnetManagerSockFile)

	case EventIconExecRun, EventIconExecEnd,
		EventExecCheckAgent, EventExecCheckLocal:
		return filepath.Join(base, IconExecManagerSockFile)

	case EventIconResultUpdate, EventExtIconFinish, EventDBIconQueryFailure,
		EventIconTimeout, EventIconTimeoutAbort:
		return filepath.Join(base, IconResultManagerSockFile)

	case EventIconUnhold, EventIconStop, EventIconRerun, EventIconRetry, EventSubJobnetStatusChange, EventFlowCheckAgent, EventFlowCheckLocal,
		EventIconHoldSkip, EventFlowIconSkip:
		return filepath.Join(base, FlowManagerSockFile)

	case EventAgentJobRun, EventAgentJobRan:
		return "agent_manager/in/"

	case EventZabbixHostIp:
		return filepath.Join(base, ZabbixLinkManagerSockFile)

	case EventInsertSendMsg:
		return filepath.Join(base, NotificationManagerSockFile)

	default:
		return ""
	}
}

func GetNextCommunicationSocketPath(event EventName) string {
	base := server.Options.UnixSockParentDir

	switch event {

	case EventJobnetLoad, EventJobnetIconRun,
		EventJobnetRunError, EventEndIconEnd:
		return filepath.Join(base, JobnetManagerSockFile)

	case EventJobnetRun, EventJobnetStopping, EventMIconRun:
		return filepath.Join(base, FlowManagerSockFile)

	case EventIconReady, EventIconAbort:
		return filepath.Join(base, IconExecManagerSockFile)

	case EventIconExecEnd, EventIconSkip, EventIconResultUpdate,
		EventOneWayIconRun, EventFlowRunErr:
		return filepath.Join(base, IconResultManagerSockFile)

	case EventIconResultEnd, EventIconResultRunErr, EventEndCountPlus:
		return filepath.Join(base, FlowManagerSockFile)

	default:
		return ""
	}
}
