/*
** Job Arranger for ZABBIX
** Copyright (C) 2025 Daiwa Institute of Research Ltd. All Rights Reserved.
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
**/
package common

type TableName string

const (
	Ja2CalendarControlTable     TableName = "ja_2_calendar_control_table"
	Ja2CalendarDetailTable      TableName = "ja_2_calendar_detail_table"
	Ja2FilterControlTable       TableName = "ja_2_filter_control_table"
	Ja2ScheduleControlTable     TableName = "ja_2_schedule_control_table"
	Ja2ScheduleDetailTable      TableName = "ja_2_schedule_detail_table"
	Ja2ScheduleJobnetTable      TableName = "ja_2_schedule_jobnet_table"
	Ja2JobnetControlTable       TableName = "ja_2_jobnet_control_table"
	Ja2JobControlTable          TableName = "ja_2_job_control_table"
	Ja2FlowControlTable         TableName = "ja_2_flow_control_table"
	Ja2IconAgentlessTable       TableName = "ja_2_icon_agentless_table"
	Ja2IconCalcTable            TableName = "ja_2_icon_calc_table"
	Ja2IconEndTable             TableName = "ja_2_icon_end_table"
	Ja2IconExtjobTable          TableName = "ja_2_icon_extjob_table"
	Ja2IconFcopyTable           TableName = "ja_2_icon_fcopy_table"
	Ja2IconFwaitTable           TableName = "ja_2_icon_fwait_table"
	Ja2IconIfTable              TableName = "ja_2_icon_if_table"
	Ja2IconInfoTable            TableName = "ja_2_icon_info_table"
	Ja2IconJobnetTable          TableName = "ja_2_icon_jobnet_table"
	Ja2IconJobTable             TableName = "ja_2_icon_job_table"
	Ja2JobCommandTable          TableName = "ja_2_job_command_table"
	Ja2ValueJobTable            TableName = "ja_2_value_job_table"
	Ja2ValueJobconTable         TableName = "ja_2_value_jobcon_table"
	Ja2IconRebootTable          TableName = "ja_2_icon_reboot_table"
	Ja2IconReleaseTable         TableName = "ja_2_icon_release_table"
	Ja2IconTaskTable            TableName = "ja_2_icon_task_table"
	Ja2IconValueTable           TableName = "ja_2_icon_value_table"
	Ja2IconZabbixLinkTable      TableName = "ja_2_icon_zabbix_link_table"
	Ja2DefineValueJobconTable   TableName = "ja_2_define_value_jobcon_table"
	Ja2DefineExtjobTable        TableName = "ja_2_define_extjob_table"
	Ja2RunJobnetSummaryTable    TableName = "ja_2_run_jobnet_summary_table"
	Ja2RunJobnetTable           TableName = "ja_2_run_jobnet_table"
	Ja2RunJobTable              TableName = "ja_2_run_job_table"
	Ja2RunFlowTable             TableName = "ja_2_run_flow_table"
	Ja2RunJobCommandTable       TableName = "ja_2_run_job_command_table"
	Ja2RunValueJobTable         TableName = "ja_2_run_value_job_table"
	Ja2RunValueJobconTable      TableName = "ja_2_run_value_jobcon_table"
	Ja2RunJobVariableTable      TableName = "ja_2_run_job_variable_table"
	Ja2RunJobnetVariableTable   TableName = "ja_2_run_jobnet_variable_table"
	Ja2SessionTable             TableName = "ja_2_session_table"
	Ja2RunLogTable              TableName = "ja_2_run_log_table"
	Ja2RunTimeOutTable          TableName = "ja_2_run_timeout_table"
	Ja2DefineRunLogMessageTable TableName = "ja_2_define_run_log_message_table"
	Ja2SendMessageTable         TableName = "ja_2_send_message_table"
	Ja2IndexTable               TableName = "ja_2_index_table"
	Ja2ParameterTable           TableName = "ja_2_parameter_table"
	Ja2HostLockTable            TableName = "ja_2_host_lock_table"
	Ja2ObjectLockTable          TableName = "ja_2_object_lock_table"
	Ja2RanJobnetSummaryTable    TableName = "ja_2_ran_jobnet_summary_table"
	Ja2RanJobnetTable           TableName = "ja_2_ran_jobnet_table"
	Ja2RanJobTable              TableName = "ja_2_ran_job_table"
	Ja2RanFlowTable             TableName = "ja_2_ran_flow_table"
	Ja2RanJobCommandTable       TableName = "ja_2_ran_job_command_table"
	Ja2RanValueJobTable         TableName = "ja_2_ran_value_job_table"
	Ja2RanValueJobconTable      TableName = "ja_2_ran_value_jobcon_table"
	Ja2RanJobVariableTable      TableName = "ja_2_ran_job_variable_table"
	Ja2RanJobnetVariableTable   TableName = "ja_2_ran_jobnet_variable_table"
	Ja2RanLogTable              TableName = "ja_2_ran_log_table"
)

var (
	StartIconClientExecPath       string = "/usr/local/bin/jobarranger/start_icon_client"     // IconTypeStart
	EndIconClientExecPath         string = "/usr/local/bin/jobarranger/end_icon_client"       // IconTypeEnd
	IfIconClientExecPath          string = "/usr/local/bin/jobarranger/if_icon_client"        // IconTypeIf
	ValueIconClientExecPath       string = "/usr/local/bin/jobarranger/variable_icon_client"  // IconTypeValue
	JobIconClientExecPath         string = "/usr/local/bin/jobarranger/job_icon_client"       // IconTypeJob
	JobnetIconClientExecPath      string = "/usr/local/bin/jobarranger/jobnet_icon_client"    // IconTypeJobnet
	MIconClientExecPath           string = "/usr/local/bin/jobarranger/m_icon_client"         // IconTypeM
	WIconClientExecPath           string = "/usr/local/bin/jobarranger/w_icon_client"         // IconTypeW
	LoopIconClientExecPath        string = "/usr/local/bin/jobarranger/loop_icon_client"      // IconTypeL
	ExtJobIconClientExecPath      string = "/usr/local/bin/jobarranger/extension_icon_client" // IconTypeExtJob
	CalculationIconClientExecPath string = "/usr/local/bin/jobarranger/calc_icon_client"      // IconTypeCalc
	TaskIconClientExecPath        string = "/usr/local/bin/jobarranger/task_icon_client"      // IconTypeTask
	InfoIconClientExecPath        string = "/usr/local/bin/jobarranger/info_icon_client"      // IconTypeInfo
	IfEndIconClientExecPath       string = "/usr/local/bin/jobarranger/ifend_icon_client"     // IconTypeIfEnd
	FCopyIconClientExecPath       string = "/usr/local/bin/jobarranger/fcopy_icon_client"     // IconTypeFCopy
	FWaitIconClientExecPath       string = "/usr/local/bin/jobarranger/fwait_icon_client"     // IconTypeFWait
	RebootIconClientExecPath      string = "/usr/local/bin/jobarranger/reboot_icon_client"    // IconTypeReboot
	RelIconClientExecPath         string = "/usr/local/bin/jobarranger/release_icon_client"   // IconTypeRel
	LessIconClientExecPath        string = "/usr/local/bin/jobarranger/agentless_icon_client" // IconTypeLess
	LinkIconClientExecPath        string = "/usr/local/bin/jobarranger/zabbix_icon_client"    // IconTypeLink

	CheckClientExecPath string = "/usr/local/bin/jobarranger/checkjob_client" // checkprocess

	ClientHelperExecPath string = "/usr/local/bin/jobarranger/client_helper" // clienthelper

	SshClientExecPath string = "/usr/local/bin/jobarranger/ssh_client" //ssh client
)
