/*
** Job Arranger for ZABBIX
** Copyright (C) 2025 Daiwa Institute of Research Ltd. All Rights Reserved.
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
**/
package agent

type AgentOptions struct {
	TmpDir               string `conf:"mandatory"`
	UnixSockParentDir    string `conf:"optional"`
	Server               string `conf:"optional"`
	Hostname             string `conf:"optional"`
	AllowRoot            int    `conf:"optional,range=0:1"`
	ListenIP             string `conf:"optional"`
	Timeout              int    `conf:"optional,range=1:300,default=5"`
	DebugLevel           int    `conf:"optional,range=0:4,default=3"`
	LogFileSize          int    `conf:"optional,range=0:1024,default=1"`
	LogType              string `conf:"optional,nonempty,default=file,oneof=file system"`
	JaLogFile            string `conf:"mandatory,nonempty"`
	JaLogMessageFile     string `conf:"mandatory"`
	JaPidFile            string `conf:"optional"`
	JaServerPort         int    `conf:"optional,range=1024:32767,default=10061"`
	JaListenPort         int    `conf:"optional,range=1024:32767,default=10055"`
	JaJobHistory         int    `conf:"optional,range=1:365,default=1"`
	JaJobRunCountHistory int    `conf:"optional,range=1:365,default=7"`
	JaCleanupTime        int    `conf:"optional,range=1:24,default=24"`
	JaCleanupRunTime     int    `conf:"optional,range=0:24,default=24"`
	JaExtjobPath         string `conf:"mandatory,nonempty"`
	JaFcopyTimeout       int    `conf:"optional,range=1:3600,default=180"`
	JaBkupLoopTimeout    int    `conf:"optional,range=0:3600,default=300"`
	JaExecutionUser      string `conf:"optional,default=zabbix"`
	JaCommandUser        string `conf:"optional"`
	JaCommandPassword    string `conf:"optional"`
	Locale               string `conf:"optional"`
	ExtUnsignedFlag      int    `conf:"optional,range=0:1,default=0"`
	GCInterval           int    `conf:"optional,range=5:60,default=5"`
}
