/*
** Job Arranger for ZABBIX
** Copyright (C) 2025 Daiwa Institute of Research Ltd. All Rights Reserved.
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
**/
package server

import "jobarranger2/src/libs/golibs/database"

type ServerOptions struct {
	DBType                database.DBType `conf:"mandatory,oneof=maria mysql postgres"`
	DBHost                string          `conf:"optional,default=localhost"`
	DBName                string          `conf:"mandatory"`
	DBSchema              string          `conf:"optional"`
	DBUser                string          `conf:"mandatory"`
	DBPassword            string          `conf:"optional"`
	DBPasswordExternal    string          `conf:"optional"`
	DBSocket              string          `conf:"optional"`
	DBPort                int             `conf:"optional,range=1024:65535"`
	JazDBHost             string          `conf:"optional,default=localhost"`
	JazDBName             string          `conf:"mandatory"`
	JazDBSchema           string          `conf:"optional"`
	JazDBUser             string          `conf:"mandatory"`
	JazDBPassword         string          `conf:"optional"`
	JazDBPasswordExternal string          `conf:"optional"`
	JazDBSocket           string          `conf:"optional"`
	JazDBPort             int             `conf:"optional,range=1024:65535"`
	MaxConCount           int             `conf:"optional"`
	MariaDBPlugin         string          `conf:"optional,default=/usr/local/bin/jobarranger/maria_database.so"`
	MysqlDBPlugin         string          `conf:"optional,default=/usr/local/bin/jobarranger/mysql_database.so"`
	PostgresDBPlugin      string          `conf:"optional,default=/usr/local/bin/jobarranger/psql_database.so"`

	MariaDBRetryCodes    string `conf:"mandatory"`
	MysqlDBRetryCodes    string `conf:"mandatory"`
	PostgresDBRetryCodes string `conf:"mandatory"`

	// Zabbix Database encryption options
	DBTLSConnect  string `conf:"optional,oneof=required verify_ca verify_full"`
	DBTLSCertFile string `conf:"optional"`
	DBTLSKeyFile  string `conf:"optional"`
	DBTLSCAFile   string `conf:"optional"`
	DBTLSCipher   string `conf:"optional"`
	DBTLSCipher13 string `conf:"optional"`

	// Jobarranger Database encryption options
	JazDBTLSConnect  string `conf:"optional,oneof=required verify_ca verify_full"`
	JazDBTLSCertFile string `conf:"optional"`
	JazDBTLSKeyFile  string `conf:"optional"`
	JazDBTLSCAFile   string `conf:"optional"`
	JazDBTLSCipher   string `conf:"optional"`
	JazDBTLSCipher13 string `conf:"optional"`

	// Database Max Connection counts
	JobnetManagerMaxDBConCount       int `conf:"optional,default=4,range=4:50000"`
	FlowManagerMaxDBConCount         int `conf:"optional,default=2,range=2:50000"`
	IconResultManagerMaxDBConCount   int `conf:"optional,default=2,range=2:50000"`
	ZabbixLinkManagerMaxDBConCount   int `conf:"optional,default=3,range=3:50000"`
	TimerManagerMaxDBConCount        int `conf:"optional,default=2,range=2:50000"`
	HousekeeperManagerMaxDBConCount  int `conf:"optional,default=4,range=4:50000"`
	NotificationManagerMaxDBConCount int `conf:"optional,default=3,range=3:50000"`
	DBSyncerManagerMaxDBConCount     int `conf:"optional,default=4,range=4:50000"`
	RecoveryManagerMaxDBConCount     int `conf:"optional,default=3,range=3:50000"`

	// Transaction file timeout to be treated as delayed (seconds)
	JobnetManagerTransactionTimeout       int `conf:"optional,default=60"`
	DBSyncerManagerTransactionTimeout     int `conf:"optional,default=30"`
	FlowManagerTransactionTimeout         int `conf:"optional,default=30"`
	IconExecManagerTransactionTimeout     int `conf:"optional,default=30"`
	IconResultManagerTransactionTimeout   int `conf:"optional,default=30"`
	NotificationManagerTransactionTimeout int `conf:"optional,default=30"`

	LogSlowQueries      int    `conf:"optional,range=0:3600000"`
	ListenIP            string `conf:"optional"`
	SourceIP            string `conf:"optional"`
	Timeout             int    `conf:"optional,range=1:300,default=300"`
	DebugLevel          int    `conf:"optional,range=0:4,default=4"`
	TmpDir              string `conf:"mandatory"`
	UnixSockParentDir   string `conf:"mandatory"`
	LogFileSize         int    `conf:"optional,range=0:1024,default=1"`
	LogType             string `conf:"optional,default=file"`
	JaLogFile           string `conf:"optional"`
	JaPidFile           string `conf:"optional,default=/var/run/jobarranger/jobarg_server.pid"`
	JaLoaderInterval    int    `conf:"optional,range=1:9999999,default=1"`
	JaJobInterval       int    `conf:"optional,range=1:9999999,default=1"`
	JaCheckJobInterval  int    `conf:"optional,range=1:9999999,default=60"`
	JaSendRetry         int    `conf:"optional,range=0:3600,default=3600"`
	JaRunInterval       int    `conf:"optional,range=1:9999999,default=1"`
	JaTrapperListenPort int    `conf:"optional,range=1:65535,default=10061"`
	JaAgentListenPort   int    `conf:"optional,range=1:65535,default=10055"`
	JaLogMessageFile    string `conf:"mandatory"`
	JaFcopyTimeout      int    `conf:"optional,range=1:3600,default=180"`

	JaLoaderTimeout   int `conf:"optional,range=1:3600,default=600"`
	JaMsgsndTimeout   int `conf:"optional,range=1:3600,default=600"`
	JaPurgeTimeout    int `conf:"optional,range=1:3600,default=1800"`
	JaCheckJobTimeout int `conf:"optional,range=1:3600,default=1800"`

	JaLaunchInterval    int    `conf:"optional,range=1:9999999,default=1"`
	JaZabbixMessageFile string `conf:"mandatory"`
	JaExecutionUser     string `conf:"optional"`
	JaMsgsndInterval    int    `conf:"optional,range=1:9999999,default=1"`
	JaExtjobWaitTime    int    `conf:"optional,range=0:9999999,default=300"`
	JaZabbixURL         string `conf:"optional"`
	ServerID            string `conf:"optional,default=1"`
	DBconCount          int    `conf:"optional,range=1:9999999,default=10"`
	JaPurgeTime         string `conf:"optional,default=00:00-00:00"`
	JaPurgeLimit        int    `conf:"optional,range=1:9999999,default=500"`

	JaChangeStatusTime int `conf:"optional,range=3600:604800,default=43200"`
	RunRecordMoveTime  int `conf:"optional,range=600:86400,default=3600"`
	Jaz1Support        int `conf:"optional,range=0:1,default=0"`
	JaIconRetry        int `conf:"optional,range=0:9999999,default=30"`
	InitialStartTime   int `conf:"optional,range=1:3600,default=600"`
	IconStopInterval   int `conf:"optional,range=1:3600,default=60"`
	ArchiveInterval    int `conf:"optional,range=600:86400,default=600"`
	GCInterval         int `conf:"optional,range=5:60,default=5"`
}

var Options ServerOptions
