/*
** Job Arranger for ZABBIX
** Copyright (C) 2025 Daiwa Institute of Research Ltd. All Rights Reserved.
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
**/
package uds

import (
	"fmt"
	"path/filepath"

	"jobarranger2/src/libs/golibs/common"
	"jobarranger2/src/libs/golibs/config_reader/server"
)

// Send EventData to the Unix Domain Socket
func SendViaUDS(unixSocketPath string, e *common.EventData) error {
	// Get UDS Client
	udsClient := CreateUdsClient(unixSocketPath, 1)
	udsConn, err := udsClient.Connect()
	if err != nil {
		return fmt.Errorf("uds client connect error: %w", err)
	}
	defer udsConn.Close()

	// Send Data
	if err := udsConn.Send(e); err != nil {
		return fmt.Errorf("uds client send error: %w", err)
	}

	// Assuming the server does not return any response

	return nil
}

func GetUDSPathByProcessType(procType string) string {
	return filepath.Join(server.Options.UnixSockParentDir, procType)
}
